/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedFloorBoardGeometry
extends Geometry {
    private final boolean top;

    public FramedFloorBoardGeometry(GeometryFactory.Context ctx) {
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        if (!this.top && face == Direction.UP || this.top && face == Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
        } else if (!Utils.isY(quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.0625f)).export(quadMap.get(quad.getDirection()));
        }
    }
}

