/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.door;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedTrapDoorGeometry
extends Geometry {
    private static final float DEPTH = 0.1875f;
    private static final Vector3f ZERO = new Vector3f();
    private final Direction dir;
    private final boolean top;
    private final boolean open;
    private final boolean rotate;
    private final Direction.Axis rotAxis;
    private final Vector3f rotOrigin;
    private final int rotAngle;

    public FramedTrapDoorGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.top = ctx.state().getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        this.open = (Boolean)ctx.state().getValue((Property)BlockStateProperties.OPEN);
        this.rotate = (Boolean)ctx.state().getValue((Property)PropertyHolder.ROTATE_TEXTURE);
        if (this.rotate) {
            this.rotAxis = this.dir.getClockWise().getAxis();
            boolean positive = Utils.isPositive(this.dir);
            float xzOrigin = positive ? 0.09375f : 0.90625f;
            this.rotOrigin = new Vector3f(xzOrigin, this.top ? 0.90625f : 0.09375f, xzOrigin);
            this.rotAngle = (positive ^ Utils.isZ(this.dir)) == this.top ? -90 : 90;
        } else {
            this.rotAxis = Direction.Axis.X;
            this.rotOrigin = ZERO;
            this.rotAngle = 0;
        }
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.open && !this.rotate) {
            if (quadDir == this.dir) {
                QuadModifier.of(quad).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.1875f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.1875f)).export(quadMap.get(quadDir));
            }
        } else {
            Direction topFace;
            Direction direction = topFace = this.top ? Direction.UP : Direction.DOWN;
            if (quadDir == topFace.getOpposite()) {
                Direction exportDir = this.open ? this.dir.getOpposite() : quadDir;
                QuadModifier.of(quad).apply(Modifiers.setPosition(0.1875f)).applyIf(Modifiers.rotate(this.rotAxis, this.rotOrigin, this.rotAngle, false), this.open).export(quadMap.get(exportDir));
            } else if (this.open && quadDir == topFace) {
                QuadModifier.of(quad).apply(Modifiers.rotate(this.rotAxis, this.rotOrigin, this.rotAngle, false)).export(quadMap.get(null));
            } else if (!Utils.isY(quadDir)) {
                Direction exportDir = quadDir;
                if (this.open && quadDir.getAxis() == this.dir.getAxis()) {
                    boolean up = quadDir == this.dir != this.top;
                    exportDir = up ? Direction.UP : Direction.DOWN;
                }
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.1875f)).applyIf(Modifiers.rotate(this.rotAxis, this.rotOrigin, this.rotAngle, false), this.open).export(quadMap.get(exportDir));
            }
        }
    }
}

