/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.ghost;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.blockentity.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.client.data.ghost.DoubleBlockGhostRenderBehaviour;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.slab.FramedAdjustableDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.component.AdjustableDoubleBlockData;

public final class AdjustableDoubleBlockGhostRenderBehaviour
extends DoubleBlockGhostRenderBehaviour {
    private final ModelProperty<Integer> offsetProperty;
    private final FramedAdjustableDoubleBlockEntity.OffsetPacker offsetPacker;

    private AdjustableDoubleBlockGhostRenderBehaviour(ModelProperty<Integer> offsetProperty, FramedAdjustableDoubleBlockEntity.OffsetPacker offsetPacker) {
        this.offsetProperty = offsetProperty;
        this.offsetPacker = offsetPacker;
    }

    @Override
    public ModelData appendModelData(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, int renderPass, ModelData data) {
        AdjustableDoubleBlockData blockData = (AdjustableDoubleBlockData)stack.get(FBContent.DC_TYPE_ADJ_DOUBLE_BLOCK_DATA);
        int firstHeight = blockData != null ? blockData.firstHeight() : 8;
        int offsetsLeft = this.offsetPacker.pack(renderState, firstHeight, false);
        int offsetsRight = this.offsetPacker.pack(renderState, firstHeight, true);
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)data.get(IFramedDoubleBlockEntity.DATA_ONE), ModelData.EMPTY).derive().with(this.offsetProperty, (Object)offsetsLeft).build();
        ModelData dataRight = Objects.requireNonNullElse((ModelData)data.get(IFramedDoubleBlockEntity.DATA_TWO), ModelData.EMPTY).derive().with(this.offsetProperty, (Object)offsetsRight).build();
        return data.derive().with(IFramedDoubleBlockEntity.DATA_ONE, (Object)dataLeft).with(IFramedDoubleBlockEntity.DATA_TWO, (Object)dataRight).build();
    }

    public static AdjustableDoubleBlockGhostRenderBehaviour standard() {
        return new AdjustableDoubleBlockGhostRenderBehaviour(FramedCollapsibleBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsStandard);
    }

    public static AdjustableDoubleBlockGhostRenderBehaviour copycat() {
        return new AdjustableDoubleBlockGhostRenderBehaviour(FramedCollapsibleCopycatBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsCopycat);
    }
}

