/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.pipeline.transformers;

import codechicken.lib.model.IVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.model.pipeline.IPipelineElementFactory;
import codechicken.lib.model.pipeline.QuadTransformer;

public class QuadTinter
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadTinter> FACTORY = QuadTinter::new;
    private int tint;

    QuadTinter() {
    }

    public QuadTinter(IVertexConsumer consumer, int tint) {
        super(consumer);
        this.tint = tint;
    }

    public QuadTinter setTint(int tint) {
        this.tint = tint;
        return this;
    }

    @Override
    public boolean transform() {
        this.quad.tintIndex = -1;
        if (this.format.hasColor) {
            float r = (float)(this.tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.tint & 0xFF) / 255.0f;
            for (Quad.Vertex v : this.quad.vertices) {
                float[] fArray = v.color();
                fArray[0] = fArray[0] * r;
                float[] fArray2 = v.color();
                fArray2[1] = fArray2[1] * g;
                float[] fArray3 = v.color();
                fArray3[2] = fArray3[2] * b;
            }
        }
        return true;
    }
}

