/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container;

import codechicken.lib.inventory.container.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerExtended
extends AbstractContainerMenu {
    @Nullable
    protected ServerPlayer player;

    protected ContainerExtended(MenuType<?> type, int id, Inventory inv) {
        super(type, id);
        Player player = inv.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2;
            this.player = player2 = (ServerPlayer)player;
        }
    }

    public void setSynchronizer(final ContainerSynchronizer delegate) {
        super.setSynchronizer(new ContainerSynchronizer(){

            public void sendInitialData(AbstractContainerMenu container, NonNullList<ItemStack> stacks, ItemStack carried, int[] data) {
                delegate.sendInitialData(container, stacks, carried, data);
                if (ContainerExtended.this.player != null) {
                    for (int i = 0; i < stacks.size(); ++i) {
                        ItemStack stack = (ItemStack)stacks.get(i);
                        if (stack.getCount() <= 127) continue;
                        ContainerExtended.this.sendLargeStack(stack, i, ContainerExtended.this.player);
                    }
                }
            }

            public void sendSlotChange(AbstractContainerMenu container, int slot, ItemStack stack) {
                delegate.sendSlotChange(container, slot, stack);
                if (ContainerExtended.this.player != null && stack.getCount() > 127) {
                    ContainerExtended.this.sendLargeStack(stack, slot, ContainerExtended.this.player);
                }
            }

            public void sendCarriedChange(AbstractContainerMenu container, ItemStack stack) {
                delegate.sendCarriedChange(container, stack);
            }

            public void sendDataChange(AbstractContainerMenu container, int slot, int data) {
                delegate.sendDataChange(container, slot, data);
            }
        });
    }

    public void sendLargeStack(ItemStack stack, int slot, ServerPlayer player) {
    }

    public void clicked(int slot, int dragType, ClickType clickType, Player player) {
        Slot actualSlot;
        if (slot >= 0 && slot < this.slots.size() && (actualSlot = this.getSlot(slot)) instanceof SlotHandleClicks) {
            ((SlotHandleClicks)actualSlot).slotClick(this, player, dragType, clickType);
            return;
        }
        super.clicked(slot, dragType, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack transferredStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            transferredStack = stack.copy();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return transferredStack;
    }

    public boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.isStackable()) {
            while (stack.getCount() > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.slots.get(slotIndex);
                ItemStack slotStack = slot.getItem();
                if (!slotStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) {
                    int maxStackSize;
                    int totalStackSize = slotStack.getCount() + stack.getCount();
                    if (totalStackSize <= (maxStackSize = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize()))) {
                        stack.setCount(0);
                        slotStack.setCount(totalStackSize);
                        slot.setChanged();
                        merged = true;
                    } else if (slotStack.getCount() < maxStackSize) {
                        stack.shrink(maxStackSize - slotStack.getCount());
                        slotStack.setCount(maxStackSize);
                        slot.setChanged();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.getCount() > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.getCount() > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.slots.get(slotIndex);
                if (!slot.hasItem() && slot.mayPlace(stack)) {
                    int maxStackSize = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize());
                    if (stack.getCount() <= maxStackSize) {
                        slot.set(stack.copy());
                        slot.setChanged();
                        stack.setCount(0);
                    } else {
                        slot.set(stack.split(maxStackSize));
                        slot.setChanged();
                    }
                    merged = true;
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot(new Slot((Container)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean stillValid(Player var1) {
        return true;
    }

    public void handleOutputPacket(PacketCustom packet) {
    }

    public void handleInputPacket(PacketCustom packet) {
    }

    public void handleGuiChange(int ID, int value) {
    }
}

