/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class InventoryRange {
    public final Container inv;
    @Nullable
    public final Direction face;
    @Nullable
    public WorldlyContainer sidedInv;
    public final int[] slots;

    public InventoryRange(Container inv, Direction side) {
        this.inv = inv;
        this.face = side;
        if (inv instanceof WorldlyContainer) {
            this.sidedInv = (WorldlyContainer)inv;
            this.slots = this.sidedInv.getSlotsForFace(this.face);
        } else {
            this.slots = new int[inv.getContainerSize()];
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = i;
            }
        }
    }

    public InventoryRange(Container inv) {
        this(inv, Direction.DOWN);
    }

    public InventoryRange(Container inv, int fslot, int lslot) {
        this.inv = inv;
        this.face = null;
        this.slots = new int[lslot - fslot];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = fslot + i;
        }
    }

    public InventoryRange(Container inv, InventoryRange access) {
        this.inv = inv;
        this.slots = access.slots;
        this.face = access.face;
        if (inv instanceof WorldlyContainer) {
            this.sidedInv = (WorldlyContainer)inv;
        }
    }

    public boolean canInsertItem(int slot, ItemStack item) {
        return this.sidedInv == null ? this.inv.canPlaceItem(slot, item) : this.sidedInv.canPlaceItemThroughFace(slot, item, this.face);
    }

    public boolean canExtractItem(int slot, ItemStack item) {
        return this.sidedInv == null ? this.inv.canPlaceItem(slot, item) : this.sidedInv.canTakeItemThroughFace(slot, item, this.face);
    }

    public int lastSlot() {
        int last = 0;
        for (int slot : this.slots) {
            if (slot <= last) continue;
            last = slot;
        }
        return last;
    }
}

