/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.data;

import io.github.projectet.ae2things.data.CraftingRecipeProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ae2things", bus=EventBusSubscriber.Bus.MOD)
public class AE2ThingsDataGenerator {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        DataGenerator.PackGenerator pack = generator.getVanillaPack(true);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        pack.addProvider(AE2ThingsDataGenerator.bindRegistries(CraftingRecipeProvider::new, registries));
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> factory, CompletableFuture<HolderLookup.Provider> factories) {
        return packOutput -> (DataProvider)factory.apply(packOutput, factories);
    }
}

