/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import io.github.projectet.ae2things.util.StorageManager;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class Command {
    static LiteralCommandNode<CommandSourceStack> commandRoot = ((LiteralArgumentBuilder)Commands.literal((String)"ae2things").executes(Command::help)).build();
    static LiteralCommandNode<CommandSourceStack> recoverArg = ((LiteralArgumentBuilder)Commands.literal((String)"ae2things").then(Commands.literal((String)"recover").then(((RequiredArgumentBuilder)Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> Command.spawnDrive((CommandContext<CommandSourceStack>)context, (UUID)context.getArgument("uuid", UUID.class)))))).build();
    static LiteralCommandNode<CommandSourceStack> copyUUID = ((LiteralArgumentBuilder)Commands.literal((String)"ae2things").then(Commands.literal((String)"getuuid").executes(Command::getUUID))).build();

    public static void commandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.getRoot().addChild(commandRoot);
        dispatcher.getRoot().addChild(recoverArg);
        dispatcher.getRoot().addChild(copyUUID);
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Available Argument(s): "), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/ae2things recover <UUID> - Spawns a drive with the given UUID, if it doesn't exist, does not spawn any item."), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"/ae2things getuuid - Gets the UUID of the drive in the player's hand if it has a UUID. Returns the DISKS uuid."), false);
        return 0;
    }

    private static int spawnDrive(CommandContext<CommandSourceStack> context, UUID uuid) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        StorageManager storageManager = AE2Things.currentStorageManager();
        if (storageManager != null && storageManager.hasUUID(uuid)) {
            ItemStack stack = new ItemStack((ItemLike)AETItems.DISK_DRIVE_256K.get());
            stack.set(AE2Things.DATA_DISK_ID, (Object)uuid);
            stack.set(AE2Things.DATA_DISK_ITEM_COUNT, (Object)storageManager.getOrCreateDisk((UUID)uuid).itemCount);
            player.addItem(stack);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Command.lambda$spawnDrive$5((Player)player, uuid), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ae2things.recover_fail", (Object[])new Object[]{uuid}));
        return 1;
    }

    private static int getUUID(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack mainStack = player.getMainHandItem();
        if (mainStack.getItem() instanceof IDISKCellItem) {
            UUID diskId = (UUID)mainStack.get(AE2Things.DATA_DISK_ID);
            if (diskId != null) {
                Component text = Command.copyToClipboard(diskId.toString());
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.ae2things.getuuid_success", (Object[])new Object[]{text}), false);
                return 0;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ae2things.getuuid_fail_nouuid"));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ae2things.getuuid_fail_notdisk"));
        return 1;
    }

    private static Component copyToClipboard(String string) {
        return Component.literal((String)string).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, string)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.copy.click"))).withInsertion(string).withColor(ChatFormatting.GREEN));
    }

    private static /* synthetic */ Component lambda$spawnDrive$5(Player player, UUID uuid) {
        return Component.translatable((String)"command.ae2things.recover_success", (Object[])new Object[]{player.getDisplayName(), uuid});
    }
}

