/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;

public class PhantomSpawner
implements CustomSpawner {
    private int nextTick;

    public int tick(ServerLevel p_64576_, boolean p_64577_, boolean p_64578_) {
        if (!p_64577_) {
            return 0;
        }
        if (!p_64576_.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return 0;
        }
        RandomSource randomsource = p_64576_.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += (60 + randomsource.nextInt(60)) * 20;
        if (p_64576_.getSkyDarken() < 5 && p_64576_.dimensionType().hasSkyLight()) {
            return 0;
        }
        int i = 0;
        for (ServerPlayer serverplayer : p_64576_.players()) {
            FluidState fluidstate;
            BlockState blockstate;
            BlockPos blockpos1;
            boolean isAllow;
            if (serverplayer.isSpectator()) continue;
            BlockPos blockpos = serverplayer.blockPosition();
            PlayerSpawnPhantomsEvent event = EventHooks.firePlayerSpawnPhantoms((ServerPlayer)serverplayer, (ServerLevel)p_64576_, (BlockPos)blockpos);
            boolean bl = isAllow = event.getResult() == PlayerSpawnPhantomsEvent.Result.ALLOW;
            if (!event.shouldSpawnPhantoms(p_64576_, blockpos)) continue;
            DifficultyInstance difficultyinstance = p_64576_.getCurrentDifficultyAt(blockpos);
            if (!isAllow && !difficultyinstance.isHarderThan(randomsource.nextFloat() * 3.0f)) continue;
            ServerStatsCounter serverstatscounter = serverplayer.getStats();
            int j = Mth.clamp((int)serverstatscounter.getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)), (int)1, (int)Integer.MAX_VALUE);
            int k = 24000;
            if (!isAllow && randomsource.nextInt(j) < 72000 || !NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)((Object)p_64576_), blockpos1 = blockpos.above(20 + randomsource.nextInt(15)).east(-10 + randomsource.nextInt(21)).south(-10 + randomsource.nextInt(21)), blockstate = p_64576_.getBlockState(blockpos1), fluidstate = p_64576_.getFluidState(blockpos1), EntityType.PHANTOM)) continue;
            SpawnGroupData spawngroupdata = null;
            int l = event.getPhantomsToSpawn();
            for (int i1 = 0; i1 < l; ++i1) {
                Phantom phantom = EntityType.PHANTOM.create(p_64576_);
                if (phantom == null) continue;
                phantom.moveTo(blockpos1, 0.0f, 0.0f);
                spawngroupdata = phantom.finalizeSpawn((ServerLevelAccessor)p_64576_, difficultyinstance, MobSpawnType.NATURAL, spawngroupdata);
                p_64576_.addFreshEntityWithPassengers((Entity)phantom);
                ++i;
            }
        }
        return i;
    }
}

