/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;

public class BrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    public static final int FUEL_USES = 20;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int NUM_DATA_VALUES = 2;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    int brewTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_59038_) {
            return switch (p_59038_) {
                case 0 -> BrewingStandBlockEntity.this.brewTime;
                case 1 -> BrewingStandBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void set(int p_59040_, int p_59041_) {
            switch (p_59040_) {
                case 0: {
                    BrewingStandBlockEntity.this.brewTime = p_59041_;
                    break;
                }
                case 1: {
                    BrewingStandBlockEntity.this.fuel = p_59041_;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public BrewingStandBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        super(BlockEntityType.BREWING_STAND, p_155283_, p_155284_);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.brewing");
    }

    public int getContainerSize() {
        return this.items.size();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> p_332710_) {
        this.items = p_332710_;
    }

    public static void serverTick(Level p_155286_, BlockPos p_155287_, BlockState p_155288_, BrewingStandBlockEntity p_155289_) {
        ItemStack itemstack = p_155289_.items.get(4);
        if (p_155289_.fuel <= 0 && itemstack.is(Items.BLAZE_POWDER)) {
            p_155289_.fuel = 20;
            itemstack.shrink(1);
            BrewingStandBlockEntity.setChanged((Level)p_155286_, (BlockPos)p_155287_, (BlockState)p_155288_);
        }
        boolean flag = BrewingStandBlockEntity.isBrewable(p_155286_.potionBrewing(), p_155289_.items);
        boolean flag1 = p_155289_.brewTime > 0;
        ItemStack itemstack1 = p_155289_.items.get(3);
        if (flag1) {
            boolean flag2;
            --p_155289_.brewTime;
            boolean bl = flag2 = p_155289_.brewTime == 0;
            if (flag2 && flag) {
                BrewingStandBlockEntity.doBrew(p_155286_, p_155287_, p_155289_.items);
            } else if (!flag || !itemstack1.is(p_155289_.ingredient)) {
                p_155289_.brewTime = 0;
            }
            BrewingStandBlockEntity.setChanged((Level)p_155286_, (BlockPos)p_155287_, (BlockState)p_155288_);
        } else if (flag && p_155289_.fuel > 0) {
            --p_155289_.fuel;
            p_155289_.brewTime = 400;
            p_155289_.ingredient = itemstack1.getItem();
            BrewingStandBlockEntity.setChanged((Level)p_155286_, (BlockPos)p_155287_, (BlockState)p_155288_);
        }
        boolean[] aboolean = p_155289_.getPotionBits();
        if (!Arrays.equals(aboolean, p_155289_.lastPotionCount)) {
            p_155289_.lastPotionCount = aboolean;
            BlockState blockstate = p_155288_;
            if (!(p_155288_.getBlock() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.HAS_BOTTLE.length; ++i) {
                blockstate = (BlockState)((Object)blockstate.setValue((Property)BrewingStandBlock.HAS_BOTTLE[i], Boolean.valueOf(aboolean[i])));
            }
            p_155286_.setBlock(p_155287_, blockstate, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.items.get(i).isEmpty()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private static boolean isBrewable(PotionBrewing p_341061_, NonNullList<ItemStack> p_155295_) {
        ItemStack itemstack = p_155295_.get(3);
        if (itemstack.isEmpty()) {
            return false;
        }
        if (!p_341061_.isIngredient(itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = p_155295_.get(i);
            if (itemstack1.isEmpty() || !p_341061_.hasMix(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level p_155291_, BlockPos p_155292_, NonNullList<ItemStack> p_155293_) {
        if (EventHooks.onPotionAttemptBrew(p_155293_)) {
            return;
        }
        ItemStack itemstack = p_155293_.get(3);
        PotionBrewing potionbrewing = p_155291_.potionBrewing();
        for (int i = 0; i < 3; ++i) {
            p_155293_.set(i, potionbrewing.mix(itemstack, p_155293_.get(i)));
        }
        EventHooks.onPotionBrewed(p_155293_);
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.shrink(1);
            if (itemstack.isEmpty()) {
                itemstack = itemstack1;
            } else {
                Containers.dropItemStack((Level)p_155291_, (double)p_155292_.getX(), (double)p_155292_.getY(), (double)p_155292_.getZ(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.shrink(1);
        }
        p_155293_.set(3, itemstack);
        p_155291_.levelEvent(1035, p_155292_, 0);
    }

    protected void loadAdditional(CompoundTag p_338530_, HolderLookup.Provider p_338200_) {
        super.loadAdditional(p_338530_, p_338200_);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)p_338530_, this.items, (HolderLookup.Provider)p_338200_);
        this.brewTime = p_338530_.getShort("BrewTime");
        if (this.brewTime > 0) {
            this.ingredient = this.items.get(3).getItem();
        }
        this.fuel = p_338530_.getByte("Fuel");
    }

    protected void saveAdditional(CompoundTag p_187484_, HolderLookup.Provider p_324461_) {
        super.saveAdditional(p_187484_, p_324461_);
        p_187484_.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems((CompoundTag)p_187484_, this.items, (HolderLookup.Provider)p_324461_);
        p_187484_.putByte("Fuel", (byte)this.fuel);
    }

    public boolean canPlaceItem(int p_59017_, ItemStack p_59018_) {
        PotionBrewing potionbrewing;
        PotionBrewing potionBrewing = potionbrewing = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
        if (p_59017_ == 3) {
            return potionbrewing.isIngredient(p_59018_);
        }
        return p_59017_ == 4 ? p_59018_.is(Items.BLAZE_POWDER) : (potionbrewing.isInput(p_59018_) || p_59018_.is(Items.GLASS_BOTTLE)) && this.getItem(p_59017_).isEmpty();
    }

    public int[] getSlotsForFace(Direction p_59010_) {
        if (p_59010_ == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return p_59010_ == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int p_58996_, ItemStack p_58997_, @Nullable Direction p_58998_) {
        return this.canPlaceItem(p_58996_, p_58997_);
    }

    public boolean canTakeItemThroughFace(int p_59020_, ItemStack p_59021_, Direction p_59022_) {
        return p_59020_ == 3 ? p_59021_.is(Items.GLASS_BOTTLE) : true;
    }

    protected AbstractContainerMenu createMenu(int p_58990_, Inventory p_58991_) {
        return new BrewingStandMenu(p_58990_, p_58991_, (Container)this, this.dataAccess);
    }
}

