/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.util;

import com.google.common.collect.Streams;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.niofs.union.UnionFileSystem;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.stream.Stream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.jarjar.nio.pathfs.PathFileSystem;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IOrderedProvider;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ServiceLoaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderUtil.class);

    private ServiceLoaderUtil() {
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass) {
        return ServiceLoaderUtil.loadServices(context, serviceClass, List.of());
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass, Collection<T> additionalServices) {
        Stream<Object> serviceLoaderServices = context.loadServices(serviceClass).map(p -> {
            try {
                return p.get();
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.error("Failed to load implementation for {}", (Object)serviceClass, (Object)sce);
                return null;
            }
        }).filter(Objects::nonNull);
        Stream<Object> servicesStream = Streams.concat((Stream[])new Stream[]{additionalServices.stream(), serviceLoaderServices}).distinct();
        boolean applyPriority = IOrderedProvider.class.isAssignableFrom(serviceClass);
        if (applyPriority) {
            servicesStream = servicesStream.sorted(Comparator.comparingInt(service -> ((IOrderedProvider)service).getPriority()).reversed());
        }
        List services = servicesStream.toList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogMarkers.CORE, "Found {} implementations of {}:", (Object)services.size(), (Object)serviceClass.getSimpleName());
            for (Object service2 : services) {
                String priorityPrefix = "";
                if (applyPriority) {
                    priorityPrefix = String.format(Locale.ROOT, "%8d - ", ((IOrderedProvider)service2).getPriority());
                }
                if (additionalServices.contains(service2)) {
                    LOGGER.debug(LogMarkers.CORE, "\t{}[built-in] {}", (Object)priorityPrefix, (Object)ServiceLoaderUtil.identifyService(context, service2));
                    continue;
                }
                LOGGER.debug(LogMarkers.CORE, "\t{}{}", (Object)priorityPrefix, (Object)ServiceLoaderUtil.identifyService(context, service2));
            }
        }
        return services;
    }

    private static String identifyService(ILaunchContext context, Object o) {
        String sourcePath = ServiceLoaderUtil.identifySourcePath(context, o);
        return o.getClass().getName() + " from " + sourcePath;
    }

    public static String identifySourcePath(ILaunchContext context, Object object) {
        URL codeLocation = object.getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            return ServiceLoaderUtil.unwrapPath(context, Paths.get(codeLocation.toURI()));
        }
        catch (URISyntaxException e) {
            return codeLocation.toString();
        }
    }

    private static String unwrapPath(ILaunchContext context, Path path) {
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem instanceof PathFileSystem) {
            PathFileSystem pathFileSystem = (PathFileSystem)fileSystem;
            return ServiceLoaderUtil.unwrapPath(context, pathFileSystem.getTarget());
        }
        fileSystem = path.getFileSystem();
        if (fileSystem instanceof UnionFileSystem) {
            UnionFileSystem unionFileSystem = (UnionFileSystem)fileSystem;
            if (path.equals(unionFileSystem.getRoot())) {
                return ServiceLoaderUtil.unwrapPath(context, unionFileSystem.getPrimaryPath());
            }
            return ServiceLoaderUtil.unwrapPath(context, unionFileSystem.getPrimaryPath()) + " > " + ServiceLoaderUtil.relativizePath(context, path);
        }
        return ServiceLoaderUtil.relativizePath(context, path);
    }

    private static String relativizePath(ILaunchContext context, Path path) {
        Path gameDir = context.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElse(null);
        String resultPath = gameDir != null && path.startsWith(gameDir) ? gameDir.relativize(path).toString() : (Files.isDirectory(path, new LinkOption[0]) ? path.toAbsolutePath().toString() : path.getFileName().toString());
        return resultPath.replace('\\', '/');
    }
}

