/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class RegionFileVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Int2ObjectMap<RegionFileVersion> VERSIONS = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<String, RegionFileVersion> VERSIONS_BY_NAME = new Object2ObjectOpenHashMap();
    public static final RegionFileVersion VERSION_GZIP = RegionFileVersion.register(new RegionFileVersion(1, null, p_63767_ -> new FastBufferedInputStream(new GZIPInputStream((InputStream)p_63767_)), p_63769_ -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)p_63769_))));
    public static final RegionFileVersion VERSION_DEFLATE = RegionFileVersion.register(new RegionFileVersion(2, "deflate", p_196964_ -> new FastBufferedInputStream(new InflaterInputStream((InputStream)p_196964_)), p_196966_ -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)p_196966_))));
    public static final RegionFileVersion VERSION_NONE = RegionFileVersion.register(new RegionFileVersion(3, "none", FastBufferedInputStream::new, BufferedOutputStream::new));
    public static final RegionFileVersion VERSION_LZ4 = RegionFileVersion.register(new RegionFileVersion(4, "lz4", p_321472_ -> new FastBufferedInputStream((InputStream)new LZ4BlockInputStream(p_321472_)), p_321471_ -> new BufferedOutputStream((OutputStream)new LZ4BlockOutputStream(p_321471_))));
    public static final RegionFileVersion VERSION_CUSTOM = RegionFileVersion.register(new RegionFileVersion(127, null, p_323443_ -> {
        throw new UnsupportedOperationException();
    }, p_323444_ -> {
        throw new UnsupportedOperationException();
    }));
    public static final RegionFileVersion DEFAULT;
    private static volatile RegionFileVersion selected;
    private final int id;
    @Nullable
    private final String optionName;
    private final StreamWrapper<InputStream> inputWrapper;
    private final StreamWrapper<OutputStream> outputWrapper;

    private RegionFileVersion(int p_63752_, @Nullable String p_321638_, StreamWrapper<InputStream> p_63753_, StreamWrapper<OutputStream> p_63754_) {
        this.id = p_63752_;
        this.optionName = p_321638_;
        this.inputWrapper = p_63753_;
        this.outputWrapper = p_63754_;
    }

    private static RegionFileVersion register(RegionFileVersion p_63759_) {
        VERSIONS.put(p_63759_.id, (Object)p_63759_);
        if (p_63759_.optionName != null) {
            VERSIONS_BY_NAME.put((Object)p_63759_.optionName, (Object)p_63759_);
        }
        return p_63759_;
    }

    @Nullable
    public static RegionFileVersion fromId(int p_63757_) {
        return (RegionFileVersion)VERSIONS.get(p_63757_);
    }

    public static void configure(String p_321707_) {
        RegionFileVersion $$1 = (RegionFileVersion)VERSIONS_BY_NAME.get((Object)p_321707_);
        if ($$1 != null) {
            selected = $$1;
        } else {
            LOGGER.error("Invalid `region-file-compression` value `{}` in server.properties. Please use one of: {}", (Object)p_321707_, (Object)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)VERSIONS_BY_NAME.keySet()));
        }
    }

    public static RegionFileVersion getSelected() {
        return selected;
    }

    public static boolean isValidVersion(int p_63765_) {
        return VERSIONS.containsKey(p_63765_);
    }

    public int getId() {
        return this.id;
    }

    public OutputStream wrap(OutputStream p_63763_) throws IOException {
        return this.outputWrapper.wrap(p_63763_);
    }

    public InputStream wrap(InputStream p_63761_) throws IOException {
        return this.inputWrapper.wrap(p_63761_);
    }

    static {
        selected = DEFAULT = VERSION_DEFLATE;
    }

    @FunctionalInterface
    static interface StreamWrapper<O> {
        public O wrap(O var1) throws IOException;
    }
}

