/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class Projectile
extends Entity
implements TraceableEntity {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private boolean hasBeenShot;
    @Nullable
    private Entity lastDeflectedBy;

    Projectile(EntityType<? extends Projectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    public void setOwner(@Nullable Entity p_37263_) {
        if (p_37263_ != null) {
            this.ownerUUID = p_37263_.getUUID();
            this.cachedOwner = p_37263_;
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level;
            this.cachedOwner = $$0.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_37265_) {
        if (this.ownerUUID != null) {
            p_37265_.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            p_37265_.putBoolean("LeftOwner", true);
        }
        p_37265_.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity p_150172_) {
        return p_150172_.getUUID().equals(this.ownerUUID);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_37262_) {
        if (p_37262_.hasUUID("Owner")) {
            this.ownerUUID = p_37262_.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = p_37262_.getBoolean("LeftOwner");
        this.hasBeenShot = p_37262_.getBoolean("HasBeenShot");
    }

    @Override
    public void restoreFrom(Entity p_305838_) {
        super.restoreFrom(p_305838_);
        if (p_305838_ instanceof Projectile) {
            Projectile $$1 = (Projectile)p_305838_;
            this.cachedOwner = $$1.cachedOwner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity $$0 = this.getOwner();
        if ($$0 != null) {
            for (Entity $$1 : this.level().getEntities(this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_37272_ -> !p_37272_.isSpectator() && p_37272_.isPickable())) {
                if ($$1.getRootVehicle() != $$0.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3 getMovementToShoot(double p_338345_, double p_338731_, double p_338427_, float p_338430_, float p_338697_) {
        return new Vec3(p_338345_, p_338731_, p_338427_).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)p_338697_), this.random.triangle(0.0, 0.0172275 * (double)p_338697_), this.random.triangle(0.0, 0.0172275 * (double)p_338697_)).scale(p_338430_);
    }

    public void shoot(double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_) {
        Vec3 $$5 = this.getMovementToShoot(p_37266_, p_37267_, p_37268_, p_37269_, p_37270_);
        this.setDeltaMovement($$5);
        this.hasImpulse = true;
        double $$6 = $$5.horizontalDistance();
        this.setYRot((float)(Mth.atan2($$5.x, $$5.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2($$5.y, $$6) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity p_37252_, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_) {
        float $$6 = -Mth.sin(p_37254_ * ((float)Math.PI / 180)) * Mth.cos(p_37253_ * ((float)Math.PI / 180));
        float $$7 = -Mth.sin((p_37253_ + p_37255_) * ((float)Math.PI / 180));
        float $$8 = Mth.cos(p_37254_ * ((float)Math.PI / 180)) * Mth.cos(p_37253_ * ((float)Math.PI / 180));
        this.shoot($$6, $$7, $$8, p_37256_, p_37257_);
        Vec3 $$9 = p_37252_.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add($$9.x, p_37252_.onGround() ? 0.0 : $$9.y, $$9.z));
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(HitResult p_341949_) {
        EntityHitResult $$1;
        Entity $$2;
        ProjectileDeflection $$3;
        if (p_341949_.getType() == HitResult.Type.ENTITY && ($$3 = ($$2 = ($$1 = (EntityHitResult)p_341949_).getEntity()).deflection(this)) != ProjectileDeflection.NONE) {
            if ($$2 != this.lastDeflectedBy && this.deflect($$3, $$2, this.getOwner(), false)) {
                this.lastDeflectedBy = $$2;
            }
            return $$3;
        }
        this.onHit(p_341949_);
        return ProjectileDeflection.NONE;
    }

    public boolean deflect(ProjectileDeflection p_341900_, @Nullable Entity p_341912_, @Nullable Entity p_341932_, boolean p_341948_) {
        if (!this.level().isClientSide) {
            p_341900_.deflect(this, p_341912_, this.random);
            this.setOwner(p_341932_);
            this.onDeflection(p_341912_, p_341948_);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity p_341918_, boolean p_341907_) {
    }

    protected void onHit(HitResult p_37260_) {
        HitResult.Type $$1 = p_37260_.getType();
        if ($$1 == HitResult.Type.ENTITY) {
            EntityHitResult $$2 = (EntityHitResult)p_37260_;
            Entity $$3 = $$2.getEntity();
            if ($$3.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && $$3 instanceof Projectile) {
                Projectile $$4 = (Projectile)$$3;
                $$4.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity($$2);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, p_37260_.getLocation(), GameEvent.Context.of(this, null));
        } else if ($$1 == HitResult.Type.BLOCK) {
            BlockHitResult $$5 = (BlockHitResult)p_37260_;
            this.onHitBlock($$5);
            BlockPos $$6 = $$5.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, $$6, GameEvent.Context.of(this, this.level().getBlockState($$6)));
        }
    }

    protected void onHitEntity(EntityHitResult p_37259_) {
    }

    protected void onHitBlock(BlockHitResult p_37258_) {
        BlockState $$1 = this.level().getBlockState(p_37258_.getBlockPos());
        $$1.onProjectileHit(this.level(), $$1, p_37258_, this);
    }

    @Override
    public void lerpMotion(double p_37279_, double p_37280_, double p_37281_) {
        this.setDeltaMovement(p_37279_, p_37280_, p_37281_);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double $$3 = Math.sqrt(p_37279_ * p_37279_ + p_37281_ * p_37281_);
            this.setXRot((float)(Mth.atan2(p_37280_, $$3) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2(p_37279_, p_37281_) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity p_37250_) {
        if (!p_37250_.canBeHitByProjectile()) {
            return false;
        }
        Entity $$1 = this.getOwner();
        return $$1 == null || this.leftOwner || !$$1.isPassengerOfSameVehicle(p_37250_);
    }

    protected void updateRotation() {
        Vec3 $$0 = this.getDeltaMovement();
        double $$1 = $$0.horizontalDistance();
        this.setXRot(Projectile.lerpRotation(this.xRotO, (float)(Mth.atan2($$0.y, $$1) * 57.2957763671875)));
        this.setYRot(Projectile.lerpRotation(this.yRotO, (float)(Mth.atan2($$0.x, $$0.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.lerp(0.2f, p_37274_, p_37275_);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352459_) {
        Entity $$1 = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, p_352459_, $$1 == null ? 0 : $$1.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_150170_) {
        super.recreateFromPacket(p_150170_);
        Entity $$1 = this.level().getEntity(p_150170_.getData());
        if ($$1 != null) {
            this.setOwner($$1);
        }
    }

    @Override
    public boolean mayInteract(Level p_150167_, BlockPos p_150168_) {
        Entity $$2 = this.getOwner();
        if ($$2 instanceof Player) {
            return $$2.mayInteract(p_150167_, p_150168_);
        }
        return $$2 == null || p_150167_.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(Level p_307481_) {
        return this.getType().is(EntityTypeTags.IMPACT_PROJECTILES) && p_307481_.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity p_344992_, DamageSource p_345905_) {
        double $$2 = this.getDeltaMovement().x;
        double $$3 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)$$2, (double)$$3);
    }
}

