/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.schedule.Activity;

public class PiglinBruteAi {
    private static final int ANGER_DURATION = 600;
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final double ACTIVITY_SOUND_LIKELIHOOD_PER_TICK = 0.0125;
    private static final int MAX_LOOK_DIST = 8;
    private static final int INTERACTION_RANGE = 8;
    private static final double TARGETING_RANGE = 12.0;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;
    private static final int HOME_CLOSE_ENOUGH_DISTANCE = 2;
    private static final int HOME_TOO_FAR_DISTANCE = 100;
    private static final int HOME_STROLL_AROUND_DISTANCE = 5;

    protected static Brain<?> makeBrain(PiglinBrute p_35100_, Brain<PiglinBrute> p_35101_) {
        PiglinBruteAi.initCoreActivity(p_35100_, p_35101_);
        PiglinBruteAi.initIdleActivity(p_35100_, p_35101_);
        PiglinBruteAi.initFightActivity(p_35100_, p_35101_);
        p_35101_.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        p_35101_.setDefaultActivity(Activity.IDLE);
        p_35101_.useDefaultActivity();
        return p_35101_;
    }

    protected static void initMemories(PiglinBrute p_35095_) {
        GlobalPos $$1 = GlobalPos.of(p_35095_.level().dimension(), p_35095_.blockPosition());
        p_35095_.getBrain().setMemory(MemoryModuleType.HOME, $$1);
    }

    private static void initCoreActivity(PiglinBrute p_35112_, Brain<PiglinBrute> p_35113_) {
        p_35113_.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<PiglinBrute>>)ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), InteractWithDoor.create(), StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(PiglinBrute p_35120_, Brain<PiglinBrute> p_35121_) {
        p_35121_.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<PiglinBrute>>)ImmutableList.of(StartAttacking.create(PiglinBruteAi::findNearestValidAttackTarget), PiglinBruteAi.createIdleLookBehaviors(), PiglinBruteAi.createIdleMovementBehaviors(), SetLookAndInteract.create(EntityType.PLAYER, 4)));
    }

    private static void initFightActivity(PiglinBrute p_35125_, Brain<PiglinBrute> p_35126_) {
        p_35126_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<PiglinBrute>>)ImmutableList.of(StopAttackingIfTargetInvalid.create(p_35118_ -> !PiglinBruteAi.isNearestValidAttackTarget(p_35125_, p_35118_)), SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.0f), MeleeAttack.create(20)), MemoryModuleType.ATTACK_TARGET);
    }

    private static RunOne<PiglinBrute> createIdleLookBehaviors() {
        return new RunOne<PiglinBrute>((List<Pair<BehaviorControl<PiglinBrute>, Integer>>)ImmutableList.of((Object)Pair.of(SetEntityLookTarget.create(EntityType.PLAYER, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(EntityType.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(EntityType.PIGLIN_BRUTE, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<PiglinBrute> createIdleMovementBehaviors() {
        return new RunOne<PiglinBrute>((List<Pair<BehaviorControl<PiglinBrute>, Integer>>)ImmutableList.of((Object)Pair.of(RandomStroll.stroll(0.6f), (Object)2), (Object)Pair.of(InteractWith.of(EntityType.PIGLIN, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(InteractWith.of(EntityType.PIGLIN_BRUTE, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(StrollToPoi.create(MemoryModuleType.HOME, 0.6f, 2, 100), (Object)2), (Object)Pair.of(StrollAroundPoi.create(MemoryModuleType.HOME, 0.6f, 5), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    protected static void updateActivity(PiglinBrute p_35110_) {
        Brain<PiglinBrute> $$1 = p_35110_.getBrain();
        Activity $$2 = $$1.getActiveNonCoreActivity().orElse(null);
        $$1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        Activity $$3 = $$1.getActiveNonCoreActivity().orElse(null);
        if ($$2 != $$3) {
            PiglinBruteAi.playActivitySound(p_35110_);
        }
        p_35110_.setAggressive($$1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static boolean isNearestValidAttackTarget(AbstractPiglin p_35089_, LivingEntity p_35090_) {
        return PiglinBruteAi.findNearestValidAttackTarget(p_35089_).filter(p_35085_ -> p_35085_ == p_35090_).isPresent();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(AbstractPiglin p_35087_) {
        Optional<LivingEntity> $$1 = BehaviorUtils.getLivingEntityFromUUIDMemory(p_35087_, MemoryModuleType.ANGRY_AT);
        if ($$1.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight(p_35087_, $$1.get())) {
            return $$1;
        }
        Optional<? extends LivingEntity> $$2 = PiglinBruteAi.getTargetIfWithinRange(p_35087_, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
        if ($$2.isPresent()) {
            return $$2;
        }
        return p_35087_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
    }

    private static Optional<? extends LivingEntity> getTargetIfWithinRange(AbstractPiglin p_35092_, MemoryModuleType<? extends LivingEntity> p_35093_) {
        return p_35092_.getBrain().getMemory(p_35093_).filter(p_35108_ -> p_35108_.closerThan(p_35092_, 12.0));
    }

    protected static void wasHurtBy(PiglinBrute p_35097_, LivingEntity p_35098_) {
        if (p_35098_ instanceof AbstractPiglin) {
            return;
        }
        PiglinAi.maybeRetaliate(p_35097_, p_35098_);
    }

    protected static void setAngerTarget(PiglinBrute p_149989_, LivingEntity p_149990_) {
        p_149989_.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        p_149989_.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, p_149990_.getUUID(), 600L);
    }

    protected static void maybePlayActivitySound(PiglinBrute p_35115_) {
        if ((double)p_35115_.level().random.nextFloat() < 0.0125) {
            PiglinBruteAi.playActivitySound(p_35115_);
        }
    }

    private static void playActivitySound(PiglinBrute p_35123_) {
        p_35123_.getBrain().getActiveNonCoreActivity().ifPresent(p_35104_ -> {
            if (p_35104_ == Activity.FIGHT) {
                p_35123_.playAngrySound();
            }
        });
    }
}

