/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class Strider
extends Animal
implements ItemSteerable,
Saddleable {
    private static final ResourceLocation SUFFOCATING_MODIFIER_ID = ResourceLocation.withDefaultNamespace("suffocating");
    private static final AttributeModifier SUFFOCATING_MODIFIER = new AttributeModifier(SUFFOCATING_MODIFIER_ID, -0.34f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final float SUFFOCATE_STEERING_MODIFIER = 0.35f;
    private static final float STEERING_MODIFIER = 0.55f;
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.defineId(Strider.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_SUFFOCATING = SynchedEntityData.defineId(Strider.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.defineId(Strider.class, EntityDataSerializers.BOOLEAN);
    private final ItemBasedSteering steering;
    @Nullable
    private TemptGoal temptGoal;

    public Strider(EntityType<? extends Strider> p_33862_, Level p_33863_) {
        super((EntityType<? extends Animal>)p_33862_, p_33863_);
        this.steering = new ItemBasedSteering(this.entityData, DATA_BOOST_TIME, DATA_SADDLE_ID);
        this.blocksBuilding = true;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean checkStriderSpawnRules(EntityType<Strider> p_219129_, LevelAccessor p_219130_, MobSpawnType p_219131_, BlockPos p_219132_, RandomSource p_219133_) {
        BlockPos.MutableBlockPos $$5 = p_219132_.mutable();
        do {
            $$5.move(Direction.UP);
        } while (p_219130_.getFluidState($$5).is(FluidTags.LAVA));
        return p_219130_.getBlockState($$5).isAir();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_33900_) {
        if (DATA_BOOST_TIME.equals(p_33900_) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(p_33900_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325918_) {
        super.defineSynchedData(p_325918_);
        p_325918_.define(DATA_BOOST_TIME, 0);
        p_325918_.define(DATA_SUFFOCATING, false);
        p_325918_.define(DATA_SADDLE_ID, false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_33918_) {
        super.addAdditionalSaveData(p_33918_);
        this.steering.addAdditionalSaveData(p_33918_);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_33898_) {
        super.readAdditionalSaveData(p_33898_);
        this.steering.readAdditionalSaveData(p_33898_);
    }

    @Override
    public boolean isSaddled() {
        return this.steering.hasSaddle();
    }

    @Override
    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void equipSaddle(ItemStack p_352201_, @Nullable SoundSource p_33878_) {
        this.steering.setSaddle(true);
        if (p_33878_ != null) {
            this.level().playSound(null, this, SoundEvents.STRIDER_SADDLE, p_33878_, 0.5f, 1.0f);
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.65));
        this.goalSelector.addGoal(2, new BreedGoal(this, 1.0));
        this.temptGoal = new TemptGoal(this, 1.4, p_335880_ -> p_335880_.is(ItemTags.STRIDER_TEMPT_ITEMS), false);
        this.goalSelector.addGoal(3, this.temptGoal);
        this.goalSelector.addGoal(4, new StriderGoToLavaGoal(this, 1.0));
        this.goalSelector.addGoal(5, new FollowParentGoal(this, 1.0));
        this.goalSelector.addGoal(7, new RandomStrollGoal(this, 1.0, 60));
        this.goalSelector.addGoal(8, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        this.goalSelector.addGoal(9, new LookAtPlayerGoal(this, Strider.class, 8.0f));
    }

    public void setSuffocating(boolean p_33952_) {
        this.entityData.set(DATA_SUFFOCATING, p_33952_);
        AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if ($$1 != null) {
            if (p_33952_) {
                $$1.addOrUpdateTransientModifier(SUFFOCATING_MODIFIER);
            } else {
                $$1.removeModifier(SUFFOCATING_MODIFIER_ID);
            }
        }
    }

    public boolean isSuffocating() {
        return this.entityData.get(DATA_SUFFOCATING);
    }

    @Override
    public boolean canStandOnFluid(FluidState p_204067_) {
        return p_204067_.is(FluidTags.LAVA);
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity p_294748_, EntityDimensions p_295089_, float p_295230_) {
        float $$3 = Math.min(0.25f, this.walkAnimation.speed());
        float $$4 = this.walkAnimation.position();
        float $$5 = 0.12f * Mth.cos($$4 * 1.5f) * 2.0f * $$3;
        return super.getPassengerAttachmentPoint(p_294748_, p_295089_, p_295230_).add(0.0, $$5 * p_295230_, 0.0);
    }

    @Override
    public boolean checkSpawnObstruction(LevelReader p_33880_) {
        return p_33880_.isUnobstructed(this);
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Player $$0;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && ($$0 = (Player)entity).isHolding(Items.WARPED_FUNGUS_ON_A_STICK)) {
            return $$0;
        }
        return super.getControllingPassenger();
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity p_33908_) {
        Vec3[] $$1 = new Vec3[]{Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_33908_.getBbWidth(), p_33908_.getYRot()), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_33908_.getBbWidth(), p_33908_.getYRot() - 22.5f), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_33908_.getBbWidth(), p_33908_.getYRot() + 22.5f), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_33908_.getBbWidth(), p_33908_.getYRot() - 45.0f), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_33908_.getBbWidth(), p_33908_.getYRot() + 45.0f)};
        LinkedHashSet $$2 = Sets.newLinkedHashSet();
        double $$3 = this.getBoundingBox().maxY;
        double $$4 = this.getBoundingBox().minY - 0.5;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (Vec3 $$6 : $$1) {
            $$5.set(this.getX() + $$6.x, $$3, this.getZ() + $$6.z);
            for (double $$7 = $$3; $$7 > $$4; $$7 -= 1.0) {
                $$2.add($$5.immutable());
                $$5.move(Direction.DOWN);
            }
        }
        for (BlockPos $$8 : $$2) {
            double $$9;
            if (this.level().getFluidState($$8).is(FluidTags.LAVA) || !DismountHelper.isBlockFloorValid($$9 = this.level().getBlockFloorHeight($$8))) continue;
            Vec3 $$10 = Vec3.upFromBottomCenterOf($$8, $$9);
            for (Pose $$11 : p_33908_.getDismountPoses()) {
                AABB $$12 = p_33908_.getLocalBoundsForPose($$11);
                if (!DismountHelper.canDismountTo(this.level(), p_33908_, $$12.move($$10))) continue;
                p_33908_.setPose($$11);
                return $$10;
            }
        }
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Override
    protected void tickRidden(Player p_278331_, Vec3 p_278234_) {
        this.setRot(p_278331_.getYRot(), p_278331_.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
        super.tickRidden(p_278331_, p_278234_);
    }

    @Override
    protected Vec3 getRiddenInput(Player p_278251_, Vec3 p_275578_) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(Player p_278317_) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)(this.isSuffocating() ? 0.35f : 0.55f) * (double)this.steering.boostFactor());
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    @Override
    protected void playStepSound(BlockPos p_33915_, BlockState p_33916_) {
        this.playSound(this.isInLava() ? SoundEvents.STRIDER_STEP_LAVA : SoundEvents.STRIDER_STEP, 1.0f, 1.0f);
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    protected void checkFallDamage(double p_33870_, boolean p_33871_, BlockState p_33872_, BlockPos p_33873_) {
        this.checkInsideBlocks();
        if (this.isInLava()) {
            this.resetFallDistance();
            return;
        }
        super.checkFallDamage(p_33870_, p_33871_, p_33872_, p_33873_);
    }

    @Override
    public void tick() {
        if (this.isBeingTempted() && this.random.nextInt(140) == 0) {
            this.makeSound(SoundEvents.STRIDER_HAPPY);
        } else if (this.isPanicking() && this.random.nextInt(60) == 0) {
            this.makeSound(SoundEvents.STRIDER_RETREAT);
        }
        if (!this.isNoAi()) {
            Strider $$3;
            BlockState $$0 = this.level().getBlockState(this.blockPosition());
            BlockState $$1 = this.getBlockStateOnLegacy();
            boolean $$2 = $$0.is(BlockTags.STRIDER_WARM_BLOCKS) || $$1.is(BlockTags.STRIDER_WARM_BLOCKS) || this.getFluidHeight(FluidTags.LAVA) > 0.0;
            Entity entity = this.getVehicle();
            boolean $$4 = entity instanceof Strider && ($$3 = (Strider)entity).isSuffocating();
            this.setSuffocating(!$$2 || $$4);
        }
        super.tick();
        this.floatStrider();
        this.checkInsideBlocks();
    }

    private boolean isBeingTempted() {
        return this.temptGoal != null && this.temptGoal.isRunning();
    }

    @Override
    protected boolean shouldPassengersInheritMalus() {
        return true;
    }

    private void floatStrider() {
        if (this.isInLava()) {
            CollisionContext $$0 = CollisionContext.of(this);
            if (!$$0.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) || this.level().getFluidState(this.blockPosition().above()).is(FluidTags.LAVA)) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            } else {
                this.setOnGround(true);
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.175f).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if (this.isPanicking() || this.isBeingTempted()) {
            return null;
        }
        return SoundEvents.STRIDER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_33934_) {
        return SoundEvents.STRIDER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.STRIDER_DEATH;
    }

    @Override
    protected boolean canAddPassenger(Entity p_33950_) {
        return !this.isVehicle() && !this.isEyeInFluid(FluidTags.LAVA);
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    protected PathNavigation createNavigation(Level p_33913_) {
        return new StriderPathNavigation(this, p_33913_);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_33895_, LevelReader p_33896_) {
        if (p_33896_.getBlockState(p_33895_).getFluidState().is(FluidTags.LAVA)) {
            return 10.0f;
        }
        return this.isInLava() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Override
    @Nullable
    public Strider getBreedOffspring(ServerLevel p_149861_, AgeableMob p_149862_) {
        return EntityType.STRIDER.create(p_149861_);
    }

    @Override
    public boolean isFood(ItemStack p_33946_) {
        return p_33946_.is(ItemTags.STRIDER_FOOD);
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation(Items.SADDLE);
        }
    }

    @Override
    public InteractionResult mobInteract(Player p_33910_, InteractionHand p_33911_) {
        boolean $$2 = this.isFood(p_33910_.getItemInHand(p_33911_));
        if (!$$2 && this.isSaddled() && !this.isVehicle() && !p_33910_.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                p_33910_.startRiding(this);
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        InteractionResult $$3 = super.mobInteract(p_33910_, p_33911_);
        if (!$$3.consumesAction()) {
            ItemStack $$4 = p_33910_.getItemInHand(p_33911_);
            if ($$4.is(Items.SADDLE)) {
                return $$4.interactLivingEntity(p_33910_, this, p_33911_);
            }
            return InteractionResult.PASS;
        }
        if ($$2 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.STRIDER_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return $$3;
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_33887_, DifficultyInstance p_33888_, MobSpawnType p_33889_, @Nullable SpawnGroupData p_33890_) {
        if (this.isBaby()) {
            return super.finalizeSpawn(p_33887_, p_33888_, p_33889_, p_33890_);
        }
        RandomSource $$4 = p_33887_.getRandom();
        if ($$4.nextInt(30) == 0) {
            Mob $$5 = EntityType.ZOMBIFIED_PIGLIN.create(p_33887_.getLevel());
            if ($$5 != null) {
                p_33890_ = this.spawnJockey(p_33887_, p_33888_, $$5, new Zombie.ZombieGroupData(Zombie.getSpawnAsBabyOdds($$4), false));
                $$5.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.WARPED_FUNGUS_ON_A_STICK));
                this.equipSaddle(new ItemStack(Items.SADDLE), null);
            }
        } else if ($$4.nextInt(10) == 0) {
            AgeableMob $$6 = EntityType.STRIDER.create(p_33887_.getLevel());
            if ($$6 != null) {
                $$6.setAge(-24000);
                p_33890_ = this.spawnJockey(p_33887_, p_33888_, $$6, null);
            }
        } else {
            p_33890_ = new AgeableMob.AgeableMobGroupData(0.5f);
        }
        return super.finalizeSpawn(p_33887_, p_33888_, p_33889_, p_33890_);
    }

    private SpawnGroupData spawnJockey(ServerLevelAccessor p_33882_, DifficultyInstance p_33883_, Mob p_33884_, @Nullable SpawnGroupData p_33885_) {
        p_33884_.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
        p_33884_.finalizeSpawn(p_33882_, p_33883_, MobSpawnType.JOCKEY, p_33885_);
        p_33884_.startRiding(this, true);
        return new AgeableMob.AgeableMobGroupData(0.0f);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    static class StriderGoToLavaGoal
    extends MoveToBlockGoal {
        private final Strider strider;

        StriderGoToLavaGoal(Strider p_33955_, double p_33956_) {
            super(p_33955_, p_33956_, 8, 2);
            this.strider = p_33955_;
        }

        @Override
        public BlockPos getMoveToTarget() {
            return this.blockPos;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.strider.isInLava() && this.isValidTarget(this.strider.level(), this.blockPos);
        }

        @Override
        public boolean canUse() {
            return !this.strider.isInLava() && super.canUse();
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        @Override
        protected boolean isValidTarget(LevelReader p_33963_, BlockPos p_33964_) {
            return p_33963_.getBlockState(p_33964_).is(Blocks.LAVA) && p_33963_.getBlockState(p_33964_.above()).isPathfindable(PathComputationType.LAND);
        }
    }

    static class StriderPathNavigation
    extends GroundPathNavigation {
        StriderPathNavigation(Strider p_33969_, Level p_33970_) {
            super(p_33969_, p_33970_);
        }

        @Override
        protected PathFinder createPathFinder(int p_33972_) {
            this.nodeEvaluator = new WalkNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this.nodeEvaluator, p_33972_);
        }

        @Override
        protected boolean hasValidPathType(PathType p_326840_) {
            if (p_326840_ == PathType.LAVA || p_326840_ == PathType.DAMAGE_FIRE || p_326840_ == PathType.DANGER_FIRE) {
                return true;
            }
            return super.hasValidPathType(p_326840_);
        }

        @Override
        public boolean isStableDestination(BlockPos p_33976_) {
            return this.level.getBlockState(p_33976_).is(Blocks.LAVA) || super.isStableDestination(p_33976_);
        }
    }
}

