/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(EnderDragon.class, EntityDataSerializers.INT);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    private final EnderDragonPart[] subEntities;
    public final EnderDragonPart head;
    private final EnderDragonPart neck;
    private final EnderDragonPart body;
    private final EnderDragonPart tail1;
    private final EnderDragonPart tail2;
    private final EnderDragonPart tail3;
    private final EnderDragonPart wing1;
    private final EnderDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @Nullable
    public EndCrystal nearestCrystal;
    @Nullable
    private EndDragonFight dragonFight;
    private BlockPos fightOrigin = BlockPos.ZERO;
    private final EnderDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();

    public EnderDragon(EntityType<? extends EnderDragon> p_31096_, Level p_31097_) {
        super((EntityType<? extends Mob>)EntityType.ENDER_DRAGON, p_31097_);
        this.head = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.neck = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.body = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.phaseManager = new EnderDragonPhaseManager(this);
    }

    public void setDragonFight(EndDragonFight p_287736_) {
        this.dragonFight = p_287736_;
    }

    public void setFightOrigin(BlockPos p_287665_) {
        this.fightOrigin = p_287665_;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0);
    }

    @Override
    public boolean isFlapping() {
        float $$0 = Mth.cos(this.flapTime * ((float)Math.PI * 2));
        float $$1 = Mth.cos(this.oFlapTime * ((float)Math.PI * 2));
        return $$1 <= -0.3f && $$0 >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326491_) {
        super.defineSynchedData(p_326491_);
        p_326491_.define(DATA_PHASE, EnderDragonPhase.HOVERING.getId());
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.isDeadOrDying()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int $$2 = this.posPointer - p_31102_ & 0x3F;
        int $$3 = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] $$4 = new double[3];
        double $$5 = this.positions[$$2][0];
        double $$6 = Mth.wrapDegrees(this.positions[$$3][0] - $$5);
        $$4[0] = $$5 + $$6 * (double)p_31103_;
        $$5 = this.positions[$$2][1];
        $$6 = this.positions[$$3][1] - $$5;
        $$4[1] = $$5 + $$6 * (double)p_31103_;
        $$4[2] = Mth.lerp((double)p_31103_, this.positions[$$2][2], this.positions[$$3][2]);
        return $$4;
    }

    @Override
    public void aiStep() {
        ServerLevel $$0;
        EndDragonFight $$1;
        Level level;
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (level = this.level()) instanceof ServerLevel && ($$1 = ($$0 = (ServerLevel)level).getDragonFight()) != null && this.getUUID().equals($$1.getDragonUUID())) {
            this.dragonFight = $$1;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float $$2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float $$3 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float $$4 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION, this.getX() + (double)$$2, this.getY() + 2.0 + (double)$$3, this.getZ() + (double)$$4, 0.0, 0.0, 0.0);
            return;
        }
        this.checkCrystals();
        Vec3 $$5 = this.getDeltaMovement();
        float $$6 = 0.2f / ((float)$$5.horizontalDistance() * 10.0f + 1.0f);
        this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += $$6 * 0.5f) : (this.flapTime += ($$6 *= (float)Math.pow(2.0, $$5.y))));
        this.setYRot(Mth.wrapDegrees(this.getYRot()));
        if (this.isNoAi()) {
            this.flapTime = 0.5f;
            return;
        }
        if (this.posPointer < 0) {
            for (int $$7 = 0; $$7 < this.positions.length; ++$$7) {
                this.positions[$$7][0] = this.getYRot();
                this.positions[$$7][1] = this.getY();
            }
        }
        if (++this.posPointer == this.positions.length) {
            this.posPointer = 0;
        }
        this.positions[this.posPointer][0] = this.getYRot();
        this.positions[this.posPointer][1] = this.getY();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            }
            this.phaseManager.getCurrentPhase().doClientTick();
        } else {
            Vec3 $$9;
            DragonPhaseInstance $$8 = this.phaseManager.getCurrentPhase();
            $$8.doServerTick();
            if (this.phaseManager.getCurrentPhase() != $$8) {
                $$8 = this.phaseManager.getCurrentPhase();
                $$8.doServerTick();
            }
            if (($$9 = $$8.getFlyTargetLocation()) != null) {
                double $$10 = $$9.x - this.getX();
                double $$11 = $$9.y - this.getY();
                double $$12 = $$9.z - this.getZ();
                double $$13 = $$10 * $$10 + $$11 * $$11 + $$12 * $$12;
                float $$14 = $$8.getFlySpeed();
                double $$15 = Math.sqrt($$10 * $$10 + $$12 * $$12);
                if ($$15 > 0.0) {
                    $$11 = Mth.clamp($$11 / $$15, (double)(-$$14), (double)$$14);
                }
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, $$11 * 0.01, 0.0));
                this.setYRot(Mth.wrapDegrees(this.getYRot()));
                Vec3 $$16 = $$9.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                Vec3 $$17 = new Vec3(Mth.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -Mth.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                float $$18 = Math.max(((float)$$17.dot($$16) + 0.5f) / 1.5f, 0.0f);
                if (Math.abs($$10) > (double)1.0E-5f || Math.abs($$12) > (double)1.0E-5f) {
                    float $$19 = Mth.clamp(Mth.wrapDegrees(180.0f - (float)Mth.atan2($$10, $$12) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                    this.yRotA *= 0.8f;
                    this.yRotA += $$19 * $$8.getTurnSpeed();
                    this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                }
                float $$20 = (float)(2.0 / ($$13 + 1.0));
                float $$21 = 0.06f;
                this.moveRelative(0.06f * ($$18 * $$20 + (1.0f - $$20)), new Vec3(0.0, 0.0, -1.0));
                if (this.inWall) {
                    this.move(MoverType.SELF, this.getDeltaMovement().scale(0.8f));
                } else {
                    this.move(MoverType.SELF, this.getDeltaMovement());
                }
                Vec3 $$22 = this.getDeltaMovement().normalize();
                double $$23 = 0.8 + 0.15 * ($$22.dot($$17) + 1.0) / 2.0;
                this.setDeltaMovement(this.getDeltaMovement().multiply($$23, 0.91f, $$23));
            }
        }
        this.yBodyRot = this.getYRot();
        Vec3[] $$24 = new Vec3[this.subEntities.length];
        for (int $$25 = 0; $$25 < this.subEntities.length; ++$$25) {
            $$24[$$25] = new Vec3(this.subEntities[$$25].getX(), this.subEntities[$$25].getY(), this.subEntities[$$25].getZ());
        }
        float $$26 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
        float $$27 = Mth.cos($$26);
        float $$28 = Mth.sin($$26);
        float $$29 = this.getYRot() * ((float)Math.PI / 180);
        float $$30 = Mth.sin($$29);
        float $$31 = Mth.cos($$29);
        this.tickPart(this.body, $$30 * 0.5f, 0.0, -$$31 * 0.5f);
        this.tickPart(this.wing1, $$31 * 4.5f, 2.0, $$30 * 4.5f);
        this.tickPart(this.wing2, $$31 * -4.5f, 2.0, $$30 * -4.5f);
        Level $$13 = this.level();
        if ($$13 instanceof ServerLevel) {
            ServerLevel $$32 = (ServerLevel)$$13;
            if (this.hurtTime == 0) {
                this.knockBack($$32, $$32.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                this.knockBack($$32, $$32.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                this.hurt($$32.getEntities(this, this.head.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                this.hurt($$32.getEntities(this, this.neck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
            }
        }
        float $$33 = Mth.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
        float $$34 = Mth.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
        float $$35 = this.getHeadYOffset();
        this.tickPart(this.head, $$33 * 6.5f * $$27, $$35 + $$28 * 6.5f, -$$34 * 6.5f * $$27);
        this.tickPart(this.neck, $$33 * 5.5f * $$27, $$35 + $$28 * 5.5f, -$$34 * 5.5f * $$27);
        double[] $$36 = this.getLatencyPos(5, 1.0f);
        for (int $$37 = 0; $$37 < 3; ++$$37) {
            EnderDragonPart $$38 = null;
            if ($$37 == 0) {
                $$38 = this.tail1;
            }
            if ($$37 == 1) {
                $$38 = this.tail2;
            }
            if ($$37 == 2) {
                $$38 = this.tail3;
            }
            double[] $$39 = this.getLatencyPos(12 + $$37 * 2, 1.0f);
            float $$40 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap($$39[0] - $$36[0]) * ((float)Math.PI / 180);
            float $$41 = Mth.sin($$40);
            float $$42 = Mth.cos($$40);
            float $$43 = 1.5f;
            float $$44 = (float)($$37 + 1) * 2.0f;
            this.tickPart($$38, -($$30 * 1.5f + $$41 * $$44) * $$27, $$39[1] - $$36[1] - (double)(($$44 + 1.5f) * $$28) + 1.5, ($$31 * 1.5f + $$42 * $$44) * $$27);
        }
        if (!this.level().isClientSide) {
            this.inWall = this.checkWalls(this.head.getBoundingBox()) | this.checkWalls(this.neck.getBoundingBox()) | this.checkWalls(this.body.getBoundingBox());
            if (this.dragonFight != null) {
                this.dragonFight.updateDragon(this);
            }
        }
        for (int $$45 = 0; $$45 < this.subEntities.length; ++$$45) {
            this.subEntities[$$45].xo = $$24[$$45].x;
            this.subEntities[$$45].yo = $$24[$$45].y;
            this.subEntities[$$45].zo = $$24[$$45].z;
            this.subEntities[$$45].xOld = $$24[$$45].x;
            this.subEntities[$$45].yOld = $$24[$$45].y;
            this.subEntities[$$45].zOld = $$24[$$45].z;
        }
    }

    private void tickPart(EnderDragonPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.setPos(this.getX() + p_31117_, this.getY() + p_31118_, this.getZ() + p_31119_);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] $$0 = this.getLatencyPos(5, 1.0f);
        double[] $$1 = this.getLatencyPos(0, 1.0f);
        return (float)($$0[1] - $$1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EndCrystal> $$0 = this.level().getEntitiesOfClass(EndCrystal.class, this.getBoundingBox().inflate(32.0));
            EndCrystal $$1 = null;
            double $$2 = Double.MAX_VALUE;
            for (EndCrystal $$3 : $$0) {
                double $$4 = $$3.distanceToSqr(this);
                if (!($$4 < $$2)) continue;
                $$2 = $$4;
                $$1 = $$3;
            }
            this.nearestCrystal = $$1;
        }
    }

    private void knockBack(ServerLevel p_345435_, List<Entity> p_31132_) {
        double $$2 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double $$3 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity $$4 : p_31132_) {
            if (!($$4 instanceof LivingEntity)) continue;
            LivingEntity $$5 = (LivingEntity)$$4;
            double $$6 = $$4.getX() - $$2;
            double $$7 = $$4.getZ() - $$3;
            double $$8 = Math.max($$6 * $$6 + $$7 * $$7, 0.1);
            $$4.push($$6 / $$8 * 4.0, 0.2f, $$7 / $$8 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || $$5.getLastHurtByMobTimestamp() >= $$4.tickCount - 2) continue;
            DamageSource $$9 = this.damageSources().mobAttack(this);
            $$4.hurt($$9, 5.0f);
            EnchantmentHelper.doPostAttackEffects(p_345435_, $$4, $$9);
        }
    }

    private void hurt(List<Entity> p_31142_) {
        for (Entity $$1 : p_31142_) {
            if (!($$1 instanceof LivingEntity)) continue;
            DamageSource $$2 = this.damageSources().mobAttack(this);
            $$1.hurt($$2, 10.0f);
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel $$3 = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects($$3, $$1, $$2);
        }
    }

    private float rotWrap(double p_31165_) {
        return (float)Mth.wrapDegrees(p_31165_);
    }

    private boolean checkWalls(AABB p_31140_) {
        int $$1 = Mth.floor(p_31140_.minX);
        int $$2 = Mth.floor(p_31140_.minY);
        int $$3 = Mth.floor(p_31140_.minZ);
        int $$4 = Mth.floor(p_31140_.maxX);
        int $$5 = Mth.floor(p_31140_.maxY);
        int $$6 = Mth.floor(p_31140_.maxZ);
        boolean $$7 = false;
        boolean $$8 = false;
        for (int $$9 = $$1; $$9 <= $$4; ++$$9) {
            for (int $$10 = $$2; $$10 <= $$5; ++$$10) {
                for (int $$11 = $$3; $$11 <= $$6; ++$$11) {
                    BlockPos $$12 = new BlockPos($$9, $$10, $$11);
                    BlockState $$13 = this.level().getBlockState($$12);
                    if ($$13.isAir() || $$13.is(BlockTags.DRAGON_TRANSPARENT)) continue;
                    if (!this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || $$13.is(BlockTags.DRAGON_IMMUNE)) {
                        $$7 = true;
                        continue;
                    }
                    $$8 = this.level().removeBlock($$12, false) || $$8;
                }
            }
        }
        if ($$8) {
            BlockPos $$14 = new BlockPos($$1 + this.random.nextInt($$4 - $$1 + 1), $$2 + this.random.nextInt($$5 - $$2 + 1), $$3 + this.random.nextInt($$6 - $$3 + 1));
            this.level().levelEvent(2008, $$14, 0);
        }
        return $$7;
    }

    public boolean hurt(EnderDragonPart p_31121_, DamageSource p_31122_, float p_31123_) {
        if (this.phaseManager.getCurrentPhase().getPhase() == EnderDragonPhase.DYING) {
            return false;
        }
        p_31123_ = this.phaseManager.getCurrentPhase().onHurt(p_31122_, p_31123_);
        if (p_31121_ != this.head) {
            p_31123_ = p_31123_ / 4.0f + Math.min(p_31123_, 1.0f);
        }
        if (p_31123_ < 0.01f) {
            return false;
        }
        if (p_31122_.getEntity() instanceof Player || p_31122_.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float $$3 = this.getHealth();
            this.reallyHurt(p_31122_, p_31123_);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(EnderDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + $$3 - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(EnderDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource p_31113_, float p_31114_) {
        if (!this.level().isClientSide) {
            return this.hurt(this.body, p_31113_, p_31114_);
        }
        return false;
    }

    protected boolean reallyHurt(DamageSource p_31162_, float p_31163_) {
        return super.hurt(p_31162_, p_31163_);
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    protected void tickDeath() {
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float $$0 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float $$1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float $$2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)$$0, this.getY() + 2.0 + (double)$$1, this.getZ() + (double)$$2, 0.0, 0.0, 0.0);
        }
        boolean $$3 = this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int $$4 = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            $$4 = 12000;
        }
        if (this.level() instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && $$3) {
                ExperienceOrb.award((ServerLevel)this.level(), this.position(), Mth.floor((float)$$4 * 0.08f));
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                this.level().globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        this.move(MoverType.SELF, new Vec3(0.0, 0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.level() instanceof ServerLevel) {
            if ($$3) {
                ExperienceOrb.award((ServerLevel)this.level(), this.position(), Mth.floor((float)$$4 * 0.2f));
            }
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int $$0 = 0; $$0 < 24; ++$$0) {
                int $$8;
                int $$7;
                int $$1 = 5;
                int $$2 = $$0;
                if ($$0 < 12) {
                    int $$3 = Mth.floor(60.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)$$2)));
                    int $$4 = Mth.floor(60.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)$$2)));
                } else if ($$0 < 20) {
                    int $$5 = Mth.floor(40.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)($$2 -= 12))));
                    int $$6 = Mth.floor(40.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)));
                    $$1 += 10;
                } else {
                    $$7 = Mth.floor(20.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)($$2 -= 20))));
                    $$8 = Mth.floor(20.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)$$2)));
                }
                int $$9 = Math.max(this.level().getSeaLevel() + 10, this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos($$7, 0, $$8)).getY() + $$1);
                this.nodes[$$0] = new Node($$7, $$9, $$8);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double p_31171_, double p_31172_, double p_31173_) {
        float $$3 = 10000.0f;
        int $$4 = 0;
        Node $$5 = new Node(Mth.floor(p_31171_), Mth.floor(p_31172_), Mth.floor(p_31173_));
        int $$6 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            $$6 = 12;
        }
        for (int $$7 = $$6; $$7 < 24; ++$$7) {
            float $$8;
            if (this.nodes[$$7] == null || !(($$8 = this.nodes[$$7].distanceToSqr($$5)) < $$3)) continue;
            $$3 = $$8;
            $$4 = $$7;
        }
        return $$4;
    }

    @Nullable
    public Path findPath(int p_31105_, int p_31106_, @Nullable Node p_31107_) {
        for (int $$3 = 0; $$3 < 24; ++$$3) {
            Node $$4 = this.nodes[$$3];
            $$4.closed = false;
            $$4.f = 0.0f;
            $$4.g = 0.0f;
            $$4.h = 0.0f;
            $$4.cameFrom = null;
            $$4.heapIdx = -1;
        }
        Node $$5 = this.nodes[p_31105_];
        Node $$6 = this.nodes[p_31106_];
        $$5.g = 0.0f;
        $$5.f = $$5.h = $$5.distanceTo($$6);
        this.openSet.clear();
        this.openSet.insert($$5);
        Node $$7 = $$5;
        int $$8 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            $$8 = 12;
        }
        while (!this.openSet.isEmpty()) {
            Node $$9 = this.openSet.pop();
            if ($$9.equals($$6)) {
                if (p_31107_ != null) {
                    p_31107_.cameFrom = $$6;
                    $$6 = p_31107_;
                }
                return this.reconstructPath($$5, $$6);
            }
            if ($$9.distanceTo($$6) < $$7.distanceTo($$6)) {
                $$7 = $$9;
            }
            $$9.closed = true;
            int $$10 = 0;
            for (int $$11 = 0; $$11 < 24; ++$$11) {
                if (this.nodes[$$11] != $$9) continue;
                $$10 = $$11;
                break;
            }
            for (int $$12 = $$8; $$12 < 24; ++$$12) {
                if ((this.nodeAdjacency[$$10] & 1 << $$12) <= 0) continue;
                Node $$13 = this.nodes[$$12];
                if ($$13.closed) continue;
                float $$14 = $$9.g + $$9.distanceTo($$13);
                if ($$13.inOpenSet() && !($$14 < $$13.g)) continue;
                $$13.cameFrom = $$9;
                $$13.g = $$14;
                $$13.h = $$13.distanceTo($$6);
                if ($$13.inOpenSet()) {
                    this.openSet.changeCost($$13, $$13.g + $$13.h);
                    continue;
                }
                $$13.f = $$13.g + $$13.h;
                this.openSet.insert($$13);
            }
        }
        if ($$7 == $$5) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)p_31105_, (Object)p_31106_);
        if (p_31107_ != null) {
            p_31107_.cameFrom = $$7;
            $$7 = p_31107_;
        }
        return this.reconstructPath($$5, $$7);
    }

    private Path reconstructPath(Node p_31129_, Node p_31130_) {
        ArrayList $$2 = Lists.newArrayList();
        Node $$3 = p_31130_;
        $$2.add(0, $$3);
        while ($$3.cameFrom != null) {
            $$3 = $$3.cameFrom;
            $$2.add(0, $$3);
        }
        return new Path($$2, new BlockPos(p_31130_.x, p_31130_.y, p_31130_.z), true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_31144_) {
        super.addAdditionalSaveData(p_31144_);
        p_31144_.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        p_31144_.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_31134_) {
        super.readAdditionalSaveData(p_31134_);
        if (p_31134_.contains(DRAGON_PHASE_KEY)) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(p_31134_.getInt(DRAGON_PHASE_KEY)));
        }
        if (p_31134_.contains(DRAGON_DEATH_TIME_KEY)) {
            this.dragonDeathTime = p_31134_.getInt(DRAGON_DEATH_TIME_KEY);
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_31154_) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double $$10;
        DragonPhaseInstance $$3 = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> $$4 = $$3.getPhase();
        if ($$4 == EnderDragonPhase.LANDING || $$4 == EnderDragonPhase.TAKEOFF) {
            BlockPos $$5 = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.fightOrigin));
            double $$6 = Math.max(Math.sqrt($$5.distToCenterSqr(this.position())) / 4.0, 1.0);
            double $$7 = (double)p_31109_ / $$6;
        } else if ($$3.isSitting()) {
            double $$8 = p_31109_;
        } else if (p_31109_ == 6) {
            double $$9 = 0.0;
        } else {
            $$10 = p_31111_[1] - p_31110_[1];
        }
        return (float)$$10;
    }

    public Vec3 getHeadLookVector(float p_31175_) {
        Vec3 $$12;
        DragonPhaseInstance $$1 = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> $$2 = $$1.getPhase();
        if ($$2 == EnderDragonPhase.LANDING || $$2 == EnderDragonPhase.TAKEOFF) {
            BlockPos $$3 = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.fightOrigin));
            float $$4 = Math.max((float)Math.sqrt($$3.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float $$5 = 6.0f / $$4;
            float $$6 = this.getXRot();
            float $$7 = 1.5f;
            this.setXRot(-$$5 * 1.5f * 5.0f);
            Vec3 $$8 = this.getViewVector(p_31175_);
            this.setXRot($$6);
        } else if ($$1.isSitting()) {
            float $$9 = this.getXRot();
            float $$10 = 1.5f;
            this.setXRot(-45.0f);
            Vec3 $$11 = this.getViewVector(p_31175_);
            this.setXRot($$9);
        } else {
            $$12 = this.getViewVector(p_31175_);
        }
        return $$12;
    }

    public void onCrystalDestroyed(EndCrystal p_31125_, BlockPos p_31126_, DamageSource p_31127_) {
        Player $$4;
        if (p_31127_.getEntity() instanceof Player) {
            Player $$3 = (Player)p_31127_.getEntity();
        } else {
            $$4 = this.level().getNearestPlayer(CRYSTAL_DESTROY_TARGETING, p_31126_.getX(), p_31126_.getY(), p_31126_.getZ());
        }
        if (p_31125_ == this.nearestCrystal) {
            this.hurt(this.head, this.damageSources().explosion(p_31125_, $$4), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(p_31125_, p_31126_, p_31127_, $$4);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31136_) {
        if (DATA_PHASE.equals(p_31136_) && this.level().isClientSide) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(p_31136_);
    }

    public EnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffectInstance p_182394_, @Nullable Entity p_182395_) {
        return false;
    }

    @Override
    protected boolean canRide(Entity p_31169_) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean p_352948_) {
        return false;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
        EnderDragonPart[] $$1 = this.getSubEntities();
        for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
            $$1[$$2].setId($$2 + p_218825_.getId());
        }
    }

    @Override
    public boolean canAttack(LivingEntity p_149576_) {
        return p_149576_.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float p_341615_) {
        return 1.0f;
    }
}

