/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class ClampedNormalFloat
extends FloatProvider {
    public static final MapCodec<ClampedNormalFloat> CODEC = RecordCodecBuilder.mapCodec(p_146431_ -> p_146431_.group((App)Codec.FLOAT.fieldOf("mean").forGetter(p_146449_ -> Float.valueOf(p_146449_.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(p_146447_ -> Float.valueOf(p_146447_.deviation)), (App)Codec.FLOAT.fieldOf("min").forGetter(p_146445_ -> Float.valueOf(p_146445_.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(p_146442_ -> Float.valueOf(p_146442_.max))).apply((Applicative)p_146431_, ClampedNormalFloat::new)).validate(p_274935_ -> {
        if (p_274935_.max < p_274935_.min) {
            return DataResult.error(() -> "Max must be larger than min: [" + p_274934_.min + ", " + p_274934_.max + "]");
        }
        return DataResult.success((Object)p_274935_);
    });
    private final float mean;
    private final float deviation;
    private final float min;
    private final float max;

    public static ClampedNormalFloat of(float p_146424_, float p_146425_, float p_146426_, float p_146427_) {
        return new ClampedNormalFloat(p_146424_, p_146425_, p_146426_, p_146427_);
    }

    private ClampedNormalFloat(float p_146418_, float p_146419_, float p_146420_, float p_146421_) {
        this.mean = p_146418_;
        this.deviation = p_146419_;
        this.min = p_146420_;
        this.max = p_146421_;
    }

    @Override
    public float sample(RandomSource p_216836_) {
        return ClampedNormalFloat.sample(p_216836_, this.mean, this.deviation, this.min, this.max);
    }

    public static float sample(RandomSource p_216838_, float p_216839_, float p_216840_, float p_216841_, float p_216842_) {
        return Mth.clamp(Mth.normal(p_216838_, p_216839_, p_216840_), p_216841_, p_216842_);
    }

    @Override
    public float getMinValue() {
        return this.min;
    }

    @Override
    public float getMaxValue() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.min + "-" + this.max + "]";
    }
}

