/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.flag.FeatureFlagSet;

public class PackRepository {
    private final Set<RepositorySource> sources;
    private Map<String, Pack> available = ImmutableMap.of();
    private List<Pack> selected = ImmutableList.of();

    public PackRepository(RepositorySource ... p_251886_) {
        this.sources = ImmutableSet.copyOf((Object[])p_251886_);
    }

    public static String displayPackList(Collection<Pack> p_341622_) {
        return p_341622_.stream().map(p_341571_ -> p_341571_.getId() + (p_341571_.getCompatibility().isCompatible() ? "" : " (incompatible)")).collect(Collectors.joining(", "));
    }

    public void reload() {
        List $$0 = (List)this.selected.stream().map(Pack::getId).collect(ImmutableList.toImmutableList());
        this.available = this.discoverAvailable();
        this.selected = this.rebuildSelected($$0);
    }

    private Map<String, Pack> discoverAvailable() {
        TreeMap $$0 = Maps.newTreeMap();
        for (RepositorySource $$1 : this.sources) {
            $$1.loadPacks(p_143903_ -> $$0.put(p_143903_.getId(), p_143903_));
        }
        return ImmutableMap.copyOf((Map)$$0);
    }

    public void setSelected(Collection<String> p_10510_) {
        this.selected = this.rebuildSelected(p_10510_);
    }

    public boolean addPack(String p_276042_) {
        Pack $$1 = this.available.get(p_276042_);
        if ($$1 != null && !this.selected.contains($$1)) {
            ArrayList $$2 = Lists.newArrayList(this.selected);
            $$2.add($$1);
            this.selected = $$2;
            return true;
        }
        return false;
    }

    public boolean removePack(String p_276065_) {
        Pack $$1 = this.available.get(p_276065_);
        if ($$1 != null && this.selected.contains($$1)) {
            ArrayList $$2 = Lists.newArrayList(this.selected);
            $$2.remove($$1);
            this.selected = $$2;
            return true;
        }
        return false;
    }

    private List<Pack> rebuildSelected(Collection<String> p_10518_) {
        List $$1 = this.getAvailablePacks(p_10518_).collect(Util.toMutableList());
        for (Pack $$2 : this.available.values()) {
            if (!$$2.isRequired() || $$1.contains($$2)) continue;
            $$2.getDefaultPosition().insert($$1, $$2, Pack::selectionConfig, false);
        }
        return ImmutableList.copyOf($$1);
    }

    private Stream<Pack> getAvailablePacks(Collection<String> p_10521_) {
        return p_10521_.stream().map(this.available::get).filter(Objects::nonNull);
    }

    public Collection<String> getAvailableIds() {
        return this.available.keySet();
    }

    public Collection<Pack> getAvailablePacks() {
        return this.available.values();
    }

    public Collection<String> getSelectedIds() {
        return (Collection)this.selected.stream().map(Pack::getId).collect(ImmutableSet.toImmutableSet());
    }

    public FeatureFlagSet getRequestedFeatureFlags() {
        return this.getSelectedPacks().stream().map(Pack::getRequestedFeatures).reduce(FeatureFlagSet::join).orElse(FeatureFlagSet.of());
    }

    public Collection<Pack> getSelectedPacks() {
        return this.selected;
    }

    @Nullable
    public Pack getPack(String p_10508_) {
        return this.available.get(p_10508_);
    }

    public boolean isAvailable(String p_10516_) {
        return this.available.containsKey(p_10516_);
    }

    public List<PackResources> openAllSelected() {
        return (List)this.selected.stream().map(Pack::open).collect(ImmutableList.toImmutableList());
    }
}

