/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.tryDetectVersion();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("recreateRegionFiles");
        OptionSpecBuilder $$9 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$10 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$16 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$17 = $$1.nonOptions();
        try {
            void $$45;
            Dynamic $$38;
            OptionSet $$18 = $$1.parse(p_129699_);
            if ($$18.has((OptionSpec)$$10)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$19 = (Path)$$18.valueOf((OptionSpec)$$16);
            if ($$19 != null) {
                Main.writePidFile($$19);
            }
            CrashReport.preload();
            if ($$18.has((OptionSpec)$$15)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            Bootstrap.bootStrap();
            Bootstrap.validate();
            Util.startTimerHackThread();
            Path $$20 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings $$21 = new DedicatedServerSettings($$20);
            $$21.forceSave();
            RegionFileVersion.configure($$21.getProperties().regionFileComression);
            Path $$22 = Paths.get("eula.txt", new String[0]);
            Eula $$23 = new Eula($$22);
            if ($$18.has((OptionSpec)$$3)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)$$20.toAbsolutePath(), (Object)$$22.toAbsolutePath());
                return;
            }
            if (!$$23.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$24 = new File((String)$$18.valueOf((OptionSpec)$$11));
            Services $$25 = Services.create(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$24);
            String $$26 = Optional.ofNullable((String)$$18.valueOf((OptionSpec)$$12)).orElse($$21.getProperties().levelName);
            LevelStorageSource $$27 = LevelStorageSource.createDefault($$24.toPath());
            LevelStorageSource.LevelStorageAccess $$28 = $$27.validateAndCreateAccess($$26);
            if ($$28.hasWorldData()) {
                void $$37;
                try {
                    Dynamic<?> $$29 = $$28.getDataTag();
                    LevelSummary $$30 = $$28.getSummary($$29);
                }
                catch (IOException | NbtException | ReportedNbtException $$31) {
                    LevelStorageSource.LevelDirectory $$32 = $$28.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)$$32.dataFile(), (Object)$$31);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        Dynamic<?> $$33 = $$28.getDataTagFallback();
                        LevelSummary $$34 = $$28.getSummary($$33);
                    }
                    catch (IOException | NbtException | ReportedNbtException $$35) {
                        LOGGER.error("Failed to load world data from {}", (Object)$$32.oldDataFile(), (Object)$$35);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)$$32.dataFile(), (Object)$$32.oldDataFile());
                        return;
                    }
                    $$28.restoreLevelDataFromOld();
                }
                if ($$37.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$37.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                $$38 = null;
            }
            Dynamic $$39 = $$38;
            boolean $$40 = $$18.has((OptionSpec)$$9);
            if ($$40) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository $$41 = ServerPacksSource.createPackRepository($$28);
            try {
                WorldLoader.InitConfig $$42 = Main.loadOrCreateConfig($$21.getProperties(), $$39, $$40, $$41);
                WorldStem $$43 = (WorldStem)Util.blockUntilDone(arg_0 -> Main.lambda$main$1($$42, $$39, $$18, (OptionSpec)$$4, $$21, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$44) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$44);
                return;
            }
            RegistryAccess.Frozen $$46 = $$45.registries().compositeAccess();
            boolean $$47 = $$18.has((OptionSpec)$$8);
            if ($$18.has((OptionSpec)$$6) || $$47) {
                Main.forceUpgrade($$28, DataFixers.getDataFixer(), $$18.has((OptionSpec)$$7), () -> true, $$46, $$47);
            }
            WorldData $$48 = $$45.worldData();
            $$28.saveDataTag($$46, $$48);
            final DedicatedServer $$49 = MinecraftServer.spin(arg_0 -> Main.lambda$main$3($$28, $$41, (WorldStem)$$45, $$21, $$25, $$18, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$17, arg_0));
            Thread $$50 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$49.halt(true);
                }
            };
            $$50.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook($$50);
        }
        catch (Exception $$51) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$51);
        }
    }

    private static void writePidFile(Path p_270192_) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString(p_270192_, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static WorldLoader.InitConfig loadOrCreateConfig(DedicatedServerProperties p_248563_, @Nullable Dynamic<?> p_307444_, boolean p_249093_, PackRepository p_251069_) {
        WorldDataConfiguration $$8;
        boolean $$7;
        if (p_307444_ != null) {
            WorldDataConfiguration $$4 = LevelStorageSource.readDataConfig(p_307444_);
            boolean $$5 = false;
            WorldDataConfiguration $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new WorldDataConfiguration(p_248563_.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        WorldLoader.PackConfig $$9 = new WorldLoader.PackConfig(p_251069_, $$8, p_249093_, $$7);
        return new WorldLoader.InitConfig($$9, Commands.CommandSelection.DEDICATED, p_248563_.functionPermissionLevel);
    }

    private static void forceUpgrade(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, RegistryAccess p_323503_, boolean p_321704_) {
        LOGGER.info("Forcing world upgrade!");
        WorldUpgrader $$6 = new WorldUpgrader(p_195489_, p_195490_, p_323503_, p_195491_, p_321704_);
        Component $$7 = null;
        while (!$$6.isFinished()) {
            int $$9;
            Component $$8 = $$6.getStatus();
            if ($$7 != $$8) {
                $$7 = $$8;
                LOGGER.info($$6.getStatus().getString());
            }
            if (($$9 = $$6.getTotalChunks()) > 0) {
                int $$10 = $$6.getConverted() + $$6.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.floor((float)$$10 / (float)$$9 * 100.0f), $$10, $$9});
            }
            if (!p_195492_.getAsBoolean()) {
                $$6.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer lambda$main$3(LevelStorageSource.LevelStorageAccess p_293749_, PackRepository p_293750_, WorldStem p_293751_, DedicatedServerSettings p_293752_, Services p_293753_, OptionSet p_293754_, OptionSpec p_293755_, OptionSpec p_293756_, OptionSpec p_293757_, OptionSpec p_293758_, OptionSpec p_293759_, Thread p_293760_) {
        boolean $$13;
        DedicatedServer $$12 = new DedicatedServer(p_293760_, p_293749_, p_293750_, p_293751_, p_293752_, DataFixers.getDataFixer(), p_293753_, LoggerChunkProgressListener::createFromGameruleRadius);
        $$12.setPort((Integer)p_293754_.valueOf(p_293755_));
        $$12.setDemo(p_293754_.has(p_293756_));
        $$12.setId((String)p_293754_.valueOf(p_293757_));
        boolean bl = $$13 = !p_293754_.has(p_293758_) && !p_293754_.valuesOf(p_293759_).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.showGui();
        }
        return $$12;
    }

    private static /* synthetic */ CompletableFuture lambda$main$1(WorldLoader.InitConfig p_248080_, Dynamic p_307550_, OptionSet p_248082_, OptionSpec p_248083_, DedicatedServerSettings p_248084_, OptionSpec p_248085_, Executor p_248086_) {
        return WorldLoader.load(p_248080_, p_307161_ -> {
            WorldDimensions $$14;
            WorldOptions $$13;
            LevelSettings $$12;
            Registry<LevelStem> $$6 = p_307161_.datapackDimensions().registryOrThrow(Registries.LEVEL_STEM);
            if (p_307550_ != null) {
                LevelDataAndDimensions $$7 = LevelStorageSource.getLevelDataAndDimensions(p_307550_, p_307161_.dataConfiguration(), $$6, p_307161_.datapackWorldgen());
                return new WorldLoader.DataLoadOutput<WorldData>($$7.worldData(), $$7.dimensions().dimensionsRegistryAccess());
            }
            LOGGER.info("No existing world data, creating new world");
            if (p_248082_.has(p_248083_)) {
                LevelSettings $$8 = MinecraftServer.DEMO_SETTINGS;
                WorldOptions $$9 = WorldOptions.DEMO_OPTIONS;
                WorldDimensions $$10 = WorldPresets.createNormalWorldDimensions(p_307161_.datapackWorldgen());
            } else {
                DedicatedServerProperties $$11 = p_248084_.getProperties();
                $$12 = new LevelSettings($$11.levelName, $$11.gamemode, $$11.hardcore, $$11.difficulty, false, new GameRules(), p_307161_.dataConfiguration());
                $$13 = p_248082_.has(p_248085_) ? $$11.worldOptions.withBonusChest(true) : $$11.worldOptions;
                $$14 = $$11.createDimensions(p_307161_.datapackWorldgen());
            }
            WorldDimensions.Complete $$15 = $$14.bake($$6);
            Lifecycle $$16 = $$15.lifecycle().add(p_307161_.datapackWorldgen().allRegistriesLifecycle());
            return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData($$12, $$13, $$15.specialWorldProperty(), $$16), $$15.dimensionsRegistryAccess());
        }, WorldStem::new, Util.backgroundExecutor(), p_248086_);
    }
}

