/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public class ShortTag
extends NumericTag {
    private static final int SELF_SIZE_IN_BYTES = 10;
    public static final TagType<ShortTag> TYPE = new TagType.StaticSize<ShortTag>(){

        @Override
        public ShortTag load(DataInput p_129282_, NbtAccounter p_129284_) throws IOException {
            return ShortTag.valueOf(1.readAccounted(p_129282_, p_129284_));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197517_, StreamTagVisitor p_197518_, NbtAccounter p_302385_) throws IOException {
            return p_197518_.visit(1.readAccounted(p_197517_, p_302385_));
        }

        private static short readAccounted(DataInput p_302332_, NbtAccounter p_302335_) throws IOException {
            p_302335_.accountBytes(10L);
            return p_302332_.readShort();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public String getName() {
            return "SHORT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Short";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final short data;

    ShortTag(short p_129248_) {
        this.data = p_129248_;
    }

    public static ShortTag valueOf(short p_129259_) {
        if (p_129259_ >= -128 && p_129259_ <= 1024) {
            return Cache.cache[p_129259_ - -128];
        }
        return new ShortTag(p_129259_);
    }

    @Override
    public void write(DataOutput p_129254_) throws IOException {
        p_129254_.writeShort(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 10;
    }

    @Override
    public byte getId() {
        return 2;
    }

    public TagType<ShortTag> getType() {
        return TYPE;
    }

    @Override
    public ShortTag copy() {
        return this;
    }

    public boolean equals(Object p_129265_) {
        if (this == p_129265_) {
            return true;
        }
        return p_129265_ instanceof ShortTag && this.data == ((ShortTag)p_129265_).data;
    }

    public int hashCode() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor p_178084_) {
        p_178084_.visitShort(this);
    }

    @Override
    public long getAsLong() {
        return this.data;
    }

    @Override
    public int getAsInt() {
        return this.data;
    }

    @Override
    public short getAsShort() {
        return this.data;
    }

    @Override
    public byte getAsByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197515_) {
        return p_197515_.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    static class Cache {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final ShortTag[] cache = new ShortTag[1153];

        private Cache() {
        }

        static {
            for (int $$0 = 0; $$0 < cache.length; ++$$0) {
                Cache.cache[$$0] = new ShortTag((short)(-128 + $$0));
            }
        }
    }
}

