/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private static final int SELF_SIZE_IN_BYTES = 37;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListTag load(DataInput p_128792_, NbtAccounter p_128794_) throws IOException {
            p_128794_.pushDepth();
            try {
                ListTag listTag = 1.loadList(p_128792_, p_128794_);
                return listTag;
            }
            finally {
                p_128794_.popDepth();
            }
        }

        private static ListTag loadList(DataInput p_302382_, NbtAccounter p_302349_) throws IOException {
            p_302349_.accountBytes(37L);
            byte $$2 = p_302382_.readByte();
            int $$3 = p_302382_.readInt();
            if ($$2 == 0 && $$3 > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            p_302349_.accountBytes(4L, $$3);
            TagType<?> $$4 = TagTypes.getType($$2);
            ArrayList $$5 = Lists.newArrayListWithCapacity((int)$$3);
            for (int $$6 = 0; $$6 < $$3; ++$$6) {
                $$5.add($$4.load(p_302382_, p_302349_));
            }
            return new ListTag($$5, $$2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197491_, StreamTagVisitor p_197492_, NbtAccounter p_302333_) throws IOException {
            p_302333_.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseList(p_197491_, p_197492_, p_302333_);
                return valueResult;
            }
            finally {
                p_302333_.popDepth();
            }
        }

        /*
         * Exception decompiling
         */
        private static StreamTagVisitor.ValueResult parseList(DataInput p_302369_, StreamTagVisitor p_302372_, NbtAccounter p_302361_) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 8[CASE]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput p_302400_, NbtAccounter p_302390_) throws IOException {
            p_302390_.pushDepth();
            try {
                TagType<?> $$2 = TagTypes.getType(p_302400_.readByte());
                int $$3 = p_302400_.readInt();
                $$2.skip(p_302400_, $$3, p_302390_);
            }
            finally {
                p_302390_.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final List<Tag> list;
    private byte type;

    ListTag(List<Tag> p_128721_, byte p_128722_) {
        this.list = p_128721_;
        this.type = p_128722_;
    }

    public ListTag() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void write(DataOutput p_128734_) throws IOException {
        this.type = this.list.isEmpty() ? (byte)0 : this.list.get(0).getId();
        p_128734_.writeByte(this.type);
        p_128734_.writeInt(this.list.size());
        for (Tag $$1 : this.list) {
            $$1.write(p_128734_);
        }
    }

    @Override
    public int sizeInBytes() {
        int $$0 = 37;
        $$0 += 4 * this.list.size();
        for (Tag $$1 : this.list) {
            $$0 += $$1.sizeInBytes();
        }
        return $$0;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    private void updateTypeAfterRemove() {
        if (this.list.isEmpty()) {
            this.type = 0;
        }
    }

    @Override
    public Tag remove(int p_128751_) {
        Tag $$1 = this.list.remove(p_128751_);
        this.updateTypeAfterRemove();
        return $$1;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public CompoundTag getCompound(int p_128729_) {
        Tag $$1;
        if (p_128729_ >= 0 && p_128729_ < this.list.size() && ($$1 = this.list.get(p_128729_)).getId() == 10) {
            return (CompoundTag)$$1;
        }
        return new CompoundTag();
    }

    public ListTag getList(int p_128745_) {
        Tag $$1;
        if (p_128745_ >= 0 && p_128745_ < this.list.size() && ($$1 = this.list.get(p_128745_)).getId() == 9) {
            return (ListTag)$$1;
        }
        return new ListTag();
    }

    public short getShort(int p_128758_) {
        Tag $$1;
        if (p_128758_ >= 0 && p_128758_ < this.list.size() && ($$1 = this.list.get(p_128758_)).getId() == 2) {
            return ((ShortTag)$$1).getAsShort();
        }
        return 0;
    }

    public int getInt(int p_128764_) {
        Tag $$1;
        if (p_128764_ >= 0 && p_128764_ < this.list.size() && ($$1 = this.list.get(p_128764_)).getId() == 3) {
            return ((IntTag)$$1).getAsInt();
        }
        return 0;
    }

    public int[] getIntArray(int p_128768_) {
        Tag $$1;
        if (p_128768_ >= 0 && p_128768_ < this.list.size() && ($$1 = this.list.get(p_128768_)).getId() == 11) {
            return ((IntArrayTag)$$1).getAsIntArray();
        }
        return new int[0];
    }

    public long[] getLongArray(int p_177992_) {
        Tag $$1;
        if (p_177992_ >= 0 && p_177992_ < this.list.size() && ($$1 = this.list.get(p_177992_)).getId() == 12) {
            return ((LongArrayTag)$$1).getAsLongArray();
        }
        return new long[0];
    }

    public double getDouble(int p_128773_) {
        Tag $$1;
        if (p_128773_ >= 0 && p_128773_ < this.list.size() && ($$1 = this.list.get(p_128773_)).getId() == 6) {
            return ((DoubleTag)$$1).getAsDouble();
        }
        return 0.0;
    }

    public float getFloat(int p_128776_) {
        Tag $$1;
        if (p_128776_ >= 0 && p_128776_ < this.list.size() && ($$1 = this.list.get(p_128776_)).getId() == 5) {
            return ((FloatTag)$$1).getAsFloat();
        }
        return 0.0f;
    }

    public String getString(int p_128779_) {
        if (p_128779_ < 0 || p_128779_ >= this.list.size()) {
            return "";
        }
        Tag $$1 = this.list.get(p_128779_);
        if ($$1.getId() == 8) {
            return $$1.getAsString();
        }
        return $$1.toString();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int p_128781_) {
        return this.list.get(p_128781_);
    }

    @Override
    public Tag set(int p_128760_, Tag p_128761_) {
        Tag $$2 = this.get(p_128760_);
        if (!this.setTag(p_128760_, p_128761_)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", p_128761_.getId(), this.type));
        }
        return $$2;
    }

    @Override
    public void add(int p_128753_, Tag p_128754_) {
        if (!this.addTag(p_128753_, p_128754_)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", p_128754_.getId(), this.type));
        }
    }

    @Override
    public boolean setTag(int p_128731_, Tag p_128732_) {
        if (this.updateType(p_128732_)) {
            this.list.set(p_128731_, p_128732_);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int p_128747_, Tag p_128748_) {
        if (this.updateType(p_128748_)) {
            this.list.add(p_128747_, p_128748_);
            return true;
        }
        return false;
    }

    private boolean updateType(Tag p_128739_) {
        if (p_128739_.getId() == 0) {
            return false;
        }
        if (this.type == 0) {
            this.type = p_128739_.getId();
            return true;
        }
        return this.type == p_128739_.getId();
    }

    @Override
    public ListTag copy() {
        List<Tag> $$0 = TagTypes.getType(this.type).isValue() ? this.list : Iterables.transform(this.list, Tag::copy);
        ArrayList $$1 = Lists.newArrayList($$0);
        return new ListTag($$1, this.type);
    }

    @Override
    public boolean equals(Object p_128766_) {
        if (this == p_128766_) {
            return true;
        }
        return p_128766_ instanceof ListTag && Objects.equals(this.list, ((ListTag)p_128766_).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void accept(TagVisitor p_177990_) {
        p_177990_.visitList(this);
    }

    @Override
    public byte getElementType() {
        return this.type;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.type = 0;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197487_) {
        switch (p_197487_.visitList(TagTypes.getType(this.type), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return p_197487_.visitContainerEnd();
            }
        }
        block13: for (int $$1 = 0; $$1 < this.list.size(); ++$$1) {
            Tag $$2 = this.list.get($$1);
            switch (p_197487_.visitElement($$2.getType(), $$1)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case SKIP: {
                    continue block13;
                }
                case BREAK: {
                    return p_197487_.visitContainerEnd();
                }
                default: {
                    switch ($$2.accept(p_197487_)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return p_197487_.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return p_197487_.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

