/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

public class SpriteLoader {
    public static final Set<MetadataSectionSerializer<?>> DEFAULT_METADATA_SECTIONS = Set.of(AnimationMetadataSection.SERIALIZER);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation location;
    private final int maxSupportedTextureSize;
    private final int minWidth;
    private final int minHeight;

    public SpriteLoader(ResourceLocation p_276126_, int p_276121_, int p_276110_, int p_276114_) {
        this.location = p_276126_;
        this.maxSupportedTextureSize = p_276121_;
        this.minWidth = p_276110_;
        this.minHeight = p_276114_;
    }

    public static SpriteLoader create(TextureAtlas p_249085_) {
        return new SpriteLoader(p_249085_.location(), p_249085_.maxSupportedTextureSize(), p_249085_.getWidth(), p_249085_.getHeight());
    }

    public Preparations stitch(List<SpriteContents> p_262029_, int p_261919_, Executor p_261665_) {
        CompletableFuture<Object> $$21;
        int $$12;
        int $$3 = this.maxSupportedTextureSize;
        Stitcher<SpriteContents> $$4 = new Stitcher<SpriteContents>($$3, $$3, p_261919_);
        int $$5 = Integer.MAX_VALUE;
        int $$6 = 1 << p_261919_;
        for (SpriteContents $$7 : p_262029_) {
            $$5 = Math.min($$5, Math.min($$7.width(), $$7.height()));
            int $$8 = Math.min(Integer.lowestOneBit($$7.width()), Integer.lowestOneBit($$7.height()));
            if ($$8 < $$6) {
                LOGGER.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{$$7.name(), $$7.width(), $$7.height(), Mth.log2($$6), Mth.log2($$8)});
                $$6 = $$8;
            }
            $$4.registerSprite($$7);
        }
        int $$9 = Math.min($$5, $$6);
        int $$10 = Mth.log2($$9);
        if ($$10 < p_261919_) {
            LOGGER.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.location, p_261919_, $$10, $$9});
            int $$11 = $$10;
        } else {
            $$12 = p_261919_;
        }
        try {
            $$4.stitch();
        }
        catch (StitcherException $$13) {
            CrashReport $$14 = CrashReport.forThrowable($$13, "Stitching");
            CrashReportCategory $$15 = $$14.addCategory("Stitcher");
            $$15.setDetail("Sprites", $$13.getAllSprites().stream().map(p_249576_ -> String.format(Locale.ROOT, "%s[%dx%d]", p_249576_.name(), p_249576_.width(), p_249576_.height())).collect(Collectors.joining(",")));
            $$15.setDetail("Max Texture Size", $$3);
            throw new ReportedException($$14);
        }
        int $$16 = Math.max($$4.getWidth(), this.minWidth);
        int $$17 = Math.max($$4.getHeight(), this.minHeight);
        Map<ResourceLocation, TextureAtlasSprite> $$18 = this.getStitchedSprites($$4, $$16, $$17);
        TextureAtlasSprite $$19 = $$18.get(MissingTextureAtlasSprite.getLocation());
        if ($$12 > 0) {
            CompletableFuture<Void> $$20 = CompletableFuture.runAsync(() -> $$18.values().forEach(p_251202_ -> p_251202_.contents().increaseMipLevel($$12)), p_261665_);
        } else {
            $$21 = CompletableFuture.completedFuture(null);
        }
        return new Preparations($$16, $$17, $$12, $$19, $$18, $$21);
    }

    public static CompletableFuture<List<SpriteContents>> runSpriteSuppliers(SpriteResourceLoader p_294961_, List<Function<SpriteResourceLoader, SpriteContents>> p_261516_, Executor p_261791_) {
        List<CompletableFuture> $$3 = p_261516_.stream().map(p_293678_ -> CompletableFuture.supplyAsync(() -> (SpriteContents)p_293678_.apply(p_294961_), p_261791_)).toList();
        return Util.sequence($$3).thenApply(p_252234_ -> p_252234_.stream().filter(Objects::nonNull).toList());
    }

    public CompletableFuture<Preparations> loadAndStitch(ResourceManager p_262108_, ResourceLocation p_261754_, int p_262104_, Executor p_261687_) {
        return this.loadAndStitch(p_262108_, p_261754_, p_262104_, p_261687_, DEFAULT_METADATA_SECTIONS);
    }

    public CompletableFuture<Preparations> loadAndStitch(ResourceManager p_295469_, ResourceLocation p_294925_, int p_294855_, Executor p_294720_, Collection<MetadataSectionSerializer<?>> p_294816_) {
        SpriteResourceLoader $$5 = SpriteResourceLoader.create(p_294816_);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SpriteSourceList.load(p_295469_, p_294925_).list(p_295469_), p_294720_).thenCompose(p_293671_ -> SpriteLoader.runSpriteSuppliers($$5, p_293671_, p_294720_))).thenApply(p_261393_ -> this.stitch((List<SpriteContents>)p_261393_, p_294855_, p_294720_));
    }

    private Map<ResourceLocation, TextureAtlasSprite> getStitchedSprites(Stitcher<SpriteContents> p_276117_, int p_276111_, int p_276112_) {
        HashMap<ResourceLocation, TextureAtlasSprite> $$3 = new HashMap<ResourceLocation, TextureAtlasSprite>();
        p_276117_.gatherSprites((p_251421_, p_250533_, p_251913_) -> $$3.put(p_251421_.name(), new TextureAtlasSprite(this.location, (SpriteContents)p_251421_, p_276111_, p_276112_, p_250533_, p_251913_)));
        return $$3;
    }

    public record Preparations(int width, int height, int mipLevel, TextureAtlasSprite missing, Map<ResourceLocation, TextureAtlasSprite> regions, CompletableFuture<Void> readyForUpload) {
        public CompletableFuture<Preparations> waitForUpload() {
            return this.readyForUpload.thenApply(p_249056_ -> this);
        }
    }
}

