/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.VillagerProfessionLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;

public class VillagerRenderer
extends MobRenderer<Villager, VillagerModel<Villager>> {
    private static final ResourceLocation VILLAGER_BASE_SKIN = ResourceLocation.withDefaultNamespace("textures/entity/villager/villager.png");

    public VillagerRenderer(EntityRendererProvider.Context p_174437_) {
        super(p_174437_, new VillagerModel(p_174437_.bakeLayer(ModelLayers.VILLAGER)), 0.5f);
        this.addLayer(new CustomHeadLayer<Villager, VillagerModel<Villager>>(this, p_174437_.getModelSet(), p_174437_.getItemInHandRenderer()));
        this.addLayer(new VillagerProfessionLayer<Villager, VillagerModel<Villager>>(this, p_174437_.getResourceManager(), "villager"));
        this.addLayer(new CrossedArmsItemLayer<Villager, VillagerModel<Villager>>(this, p_174437_.getItemInHandRenderer()));
    }

    @Override
    public ResourceLocation getTextureLocation(Villager p_116312_) {
        return VILLAGER_BASE_SKIN;
    }

    @Override
    protected void scale(Villager p_116314_, PoseStack p_116315_, float p_116316_) {
        float $$3 = 0.9375f * p_116314_.getAgeScale();
        p_116315_.scale($$3, $$3, $$3);
    }

    @Override
    protected float getShadowRadius(Villager p_316668_) {
        float $$1 = super.getShadowRadius(p_316668_);
        if (p_316668_.isBaby()) {
            return $$1 * 0.5f;
        }
        return $$1;
    }

    @Override
    protected /* synthetic */ float getShadowRadius(LivingEntity livingEntity) {
        return this.getShadowRadius((Villager)livingEntity);
    }

    @Override
    protected /* synthetic */ float getShadowRadius(Entity entity) {
        return this.getShadowRadius((Villager)entity);
    }
}

