/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;

public class ItemFrameRenderer<T extends ItemFrame>
extends EntityRenderer<T> {
    private static final ModelResourceLocation FRAME_LOCATION = ModelResourceLocation.vanilla("item_frame", "map=false");
    private static final ModelResourceLocation MAP_FRAME_LOCATION = ModelResourceLocation.vanilla("item_frame", "map=true");
    private static final ModelResourceLocation GLOW_FRAME_LOCATION = ModelResourceLocation.vanilla("glow_item_frame", "map=false");
    private static final ModelResourceLocation GLOW_MAP_FRAME_LOCATION = ModelResourceLocation.vanilla("glow_item_frame", "map=true");
    public static final int GLOW_FRAME_BRIGHTNESS = 5;
    public static final int BRIGHT_MAP_LIGHT_ADJUSTMENT = 30;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public ItemFrameRenderer(EntityRendererProvider.Context p_174204_) {
        super(p_174204_);
        this.itemRenderer = p_174204_.getItemRenderer();
        this.blockRenderer = p_174204_.getBlockRenderDispatcher();
    }

    @Override
    protected int getBlockLightLevel(T p_174216_, BlockPos p_174217_) {
        if (((Entity)p_174216_).getType() == EntityType.GLOW_ITEM_FRAME) {
            return Math.max(5, super.getBlockLightLevel(p_174216_, p_174217_));
        }
        return super.getBlockLightLevel(p_174216_, p_174217_);
    }

    @Override
    public void render(T p_115076_, float p_115077_, float p_115078_, PoseStack p_115079_, MultiBufferSource p_115080_, int p_115081_) {
        super.render(p_115076_, p_115077_, p_115078_, p_115079_, p_115080_, p_115081_);
        p_115079_.pushPose();
        Direction $$6 = ((HangingEntity)p_115076_).getDirection();
        Vec3 $$7 = this.getRenderOffset(p_115076_, p_115078_);
        p_115079_.translate(-$$7.x(), -$$7.y(), -$$7.z());
        double $$8 = 0.46875;
        p_115079_.translate((double)$$6.getStepX() * 0.46875, (double)$$6.getStepY() * 0.46875, (double)$$6.getStepZ() * 0.46875);
        p_115079_.mulPose(Axis.XP.rotationDegrees(((Entity)p_115076_).getXRot()));
        p_115079_.mulPose(Axis.YP.rotationDegrees(180.0f - ((Entity)p_115076_).getYRot()));
        boolean $$9 = ((Entity)p_115076_).isInvisible();
        ItemStack $$10 = ((ItemFrame)p_115076_).getItem();
        if (!$$9) {
            ModelManager $$11 = this.blockRenderer.getBlockModelShaper().getModelManager();
            ModelResourceLocation $$12 = this.getFrameModelResourceLoc(p_115076_, $$10);
            p_115079_.pushPose();
            p_115079_.translate(-0.5f, -0.5f, -0.5f);
            this.blockRenderer.getModelRenderer().renderModel(p_115079_.last(), p_115080_.getBuffer(Sheets.solidBlockSheet()), null, $$11.getModel($$12), 1.0f, 1.0f, 1.0f, p_115081_, OverlayTexture.NO_OVERLAY);
            p_115079_.popPose();
        }
        if (!$$10.isEmpty()) {
            MapId $$13 = ((ItemFrame)p_115076_).getFramedMapId($$10);
            if ($$9) {
                p_115079_.translate(0.0f, 0.0f, 0.5f);
            } else {
                p_115079_.translate(0.0f, 0.0f, 0.4375f);
            }
            int $$14 = $$13 != null ? ((ItemFrame)p_115076_).getRotation() % 4 * 2 : ((ItemFrame)p_115076_).getRotation();
            p_115079_.mulPose(Axis.ZP.rotationDegrees((float)$$14 * 360.0f / 8.0f));
            if ($$13 != null) {
                p_115079_.mulPose(Axis.ZP.rotationDegrees(180.0f));
                float $$15 = 0.0078125f;
                p_115079_.scale(0.0078125f, 0.0078125f, 0.0078125f);
                p_115079_.translate(-64.0f, -64.0f, 0.0f);
                MapItemSavedData $$16 = MapItem.getSavedData($$13, ((Entity)p_115076_).level());
                p_115079_.translate(0.0f, 0.0f, -1.0f);
                if ($$16 != null) {
                    int $$17 = this.getLightVal(p_115076_, 15728850, p_115081_);
                    Minecraft.getInstance().gameRenderer.getMapRenderer().render(p_115079_, p_115080_, $$13, $$16, true, $$17);
                }
            } else {
                int $$18 = this.getLightVal(p_115076_, 0xF000F0, p_115081_);
                p_115079_.scale(0.5f, 0.5f, 0.5f);
                this.itemRenderer.renderStatic($$10, ItemDisplayContext.FIXED, $$18, OverlayTexture.NO_OVERLAY, p_115079_, p_115080_, ((Entity)p_115076_).level(), ((Entity)p_115076_).getId());
            }
        }
        p_115079_.popPose();
    }

    private int getLightVal(T p_174209_, int p_174210_, int p_174211_) {
        return ((Entity)p_174209_).getType() == EntityType.GLOW_ITEM_FRAME ? p_174210_ : p_174211_;
    }

    private ModelResourceLocation getFrameModelResourceLoc(T p_174213_, ItemStack p_174214_) {
        boolean $$2;
        boolean bl = $$2 = ((Entity)p_174213_).getType() == EntityType.GLOW_ITEM_FRAME;
        if (p_174214_.is(Items.FILLED_MAP)) {
            return $$2 ? GLOW_MAP_FRAME_LOCATION : MAP_FRAME_LOCATION;
        }
        return $$2 ? GLOW_FRAME_LOCATION : FRAME_LOCATION;
    }

    @Override
    public Vec3 getRenderOffset(T p_115073_, float p_115074_) {
        return new Vec3((float)((HangingEntity)p_115073_).getDirection().getStepX() * 0.3f, -0.25, (float)((HangingEntity)p_115073_).getDirection().getStepZ() * 0.3f);
    }

    @Override
    public ResourceLocation getTextureLocation(T p_115071_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    @Override
    protected boolean shouldShowName(T p_115091_) {
        if (!Minecraft.renderNames() || ((ItemFrame)p_115091_).getItem().isEmpty() || !((ItemFrame)p_115091_).getItem().has(DataComponents.CUSTOM_NAME) || this.entityRenderDispatcher.crosshairPickEntity != p_115091_) {
            return false;
        }
        double $$1 = this.entityRenderDispatcher.distanceToSqr((Entity)p_115091_);
        float $$2 = ((Entity)p_115091_).isDiscrete() ? 32.0f : 64.0f;
        return $$1 < (double)($$2 * $$2);
    }

    @Override
    protected void renderNameTag(T p_316437_, Component p_115066_, PoseStack p_115067_, MultiBufferSource p_115068_, int p_115069_, float p_316131_) {
        super.renderNameTag(p_316437_, ((ItemFrame)p_316437_).getItem().getHoverName(), p_115067_, p_115068_, p_115069_, p_316131_);
    }
}

