/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class FishingHookRenderer
extends EntityRenderer<FishingHook> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout(TEXTURE_LOCATION);
    private static final double VIEW_BOBBING_SCALE = 960.0;

    public FishingHookRenderer(EntityRendererProvider.Context p_174117_) {
        super(p_174117_);
    }

    @Override
    public void render(FishingHook p_114705_, float p_114706_, float p_114707_, PoseStack p_114708_, MultiBufferSource p_114709_, int p_114710_) {
        Player $$6 = p_114705_.getPlayerOwner();
        if ($$6 == null) {
            return;
        }
        p_114708_.pushPose();
        p_114708_.pushPose();
        p_114708_.scale(0.5f, 0.5f, 0.5f);
        p_114708_.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose $$7 = p_114708_.last();
        VertexConsumer $$8 = p_114709_.getBuffer(RENDER_TYPE);
        FishingHookRenderer.vertex($$8, $$7, p_114710_, 0.0f, 0, 0, 1);
        FishingHookRenderer.vertex($$8, $$7, p_114710_, 1.0f, 0, 1, 1);
        FishingHookRenderer.vertex($$8, $$7, p_114710_, 1.0f, 1, 1, 0);
        FishingHookRenderer.vertex($$8, $$7, p_114710_, 0.0f, 1, 0, 0);
        p_114708_.popPose();
        float $$9 = $$6.getAttackAnim(p_114707_);
        float $$10 = Mth.sin(Mth.sqrt($$9) * (float)Math.PI);
        Vec3 $$11 = this.getPlayerHandPos($$6, $$10, p_114707_);
        Vec3 $$12 = p_114705_.getPosition(p_114707_).add(0.0, 0.25, 0.0);
        float $$13 = (float)($$11.x - $$12.x);
        float $$14 = (float)($$11.y - $$12.y);
        float $$15 = (float)($$11.z - $$12.z);
        VertexConsumer $$16 = p_114709_.getBuffer(RenderType.lineStrip());
        PoseStack.Pose $$17 = p_114708_.last();
        int $$18 = 16;
        for (int $$19 = 0; $$19 <= 16; ++$$19) {
            FishingHookRenderer.stringVertex($$13, $$14, $$15, $$16, $$17, FishingHookRenderer.fraction($$19, 16), FishingHookRenderer.fraction($$19 + 1, 16));
        }
        p_114708_.popPose();
        super.render(p_114705_, p_114706_, p_114707_, p_114708_, p_114709_, p_114710_);
    }

    private Vec3 getPlayerHandPos(Player p_340935_, float p_340872_, float p_341261_) {
        int $$3 = p_340935_.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack $$4 = p_340935_.getMainHandItem();
        if (!$$4.is(Items.FISHING_ROD)) {
            $$3 = -$$3;
        }
        if (!this.entityRenderDispatcher.options.getCameraType().isFirstPerson() || p_340935_ != Minecraft.getInstance().player) {
            float $$5 = Mth.lerp(p_341261_, p_340935_.yBodyRotO, p_340935_.yBodyRot) * ((float)Math.PI / 180);
            double $$6 = Mth.sin($$5);
            double $$7 = Mth.cos($$5);
            float $$8 = p_340935_.getScale();
            double $$9 = (double)$$3 * 0.35 * (double)$$8;
            double $$10 = 0.8 * (double)$$8;
            float $$11 = p_340935_.isCrouching() ? -0.1875f : 0.0f;
            return p_340935_.getEyePosition(p_341261_).add(-$$7 * $$9 - $$6 * $$10, (double)$$11 - 0.45 * (double)$$8, -$$6 * $$9 + $$7 * $$10);
        }
        double $$12 = 960.0 / (double)this.entityRenderDispatcher.options.fov().get().intValue();
        Vec3 $$13 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)$$3 * 0.525f, -0.1f).scale($$12).yRot(p_340872_ * 0.5f).xRot(-p_340872_ * 0.7f);
        return p_340935_.getEyePosition(p_341261_).add($$13);
    }

    private static float fraction(int p_114691_, int p_114692_) {
        return (float)p_114691_ / (float)p_114692_;
    }

    private static void vertex(VertexConsumer p_254464_, PoseStack.Pose p_323724_, int p_254296_, float p_253632_, int p_254132_, int p_254171_, int p_254026_) {
        p_254464_.addVertex(p_323724_, p_253632_ - 0.5f, (float)p_254132_ - 0.5f, 0.0f).setColor(-1).setUv(p_254171_, p_254026_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_254296_).setNormal(p_323724_, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float p_174119_, float p_174120_, float p_174121_, VertexConsumer p_174122_, PoseStack.Pose p_174123_, float p_174124_, float p_174125_) {
        float $$7 = p_174119_ * p_174124_;
        float $$8 = p_174120_ * (p_174124_ * p_174124_ + p_174124_) * 0.5f + 0.25f;
        float $$9 = p_174121_ * p_174124_;
        float $$10 = p_174119_ * p_174125_ - $$7;
        float $$11 = p_174120_ * (p_174125_ * p_174125_ + p_174125_) * 0.5f + 0.25f - $$8;
        float $$12 = p_174121_ * p_174125_ - $$9;
        float $$13 = Mth.sqrt($$10 * $$10 + $$11 * $$11 + $$12 * $$12);
        p_174122_.addVertex(p_174123_, $$7, $$8, $$9).setColor(-16777216).setNormal(p_174123_, $$10 /= $$13, $$11 /= $$13, $$12 /= $$13);
    }

    @Override
    public ResourceLocation getTextureLocation(FishingHook p_114703_) {
        return TEXTURE_LOCATION;
    }
}

