/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ExperienceOrb;

public class ExperienceOrbRenderer
extends EntityRenderer<ExperienceOrb> {
    private static final ResourceLocation EXPERIENCE_ORB_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/experience_orb.png");
    private static final RenderType RENDER_TYPE = RenderType.itemEntityTranslucentCull(EXPERIENCE_ORB_LOCATION);

    public ExperienceOrbRenderer(EntityRendererProvider.Context p_174110_) {
        super(p_174110_);
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    protected int getBlockLightLevel(ExperienceOrb p_114606_, BlockPos p_114607_) {
        return Mth.clamp(super.getBlockLightLevel(p_114606_, p_114607_) + 7, 0, 15);
    }

    @Override
    public void render(ExperienceOrb p_114599_, float p_114600_, float p_114601_, PoseStack p_114602_, MultiBufferSource p_114603_, int p_114604_) {
        p_114602_.pushPose();
        int $$6 = p_114599_.getIcon();
        float $$7 = (float)($$6 % 4 * 16 + 0) / 64.0f;
        float $$8 = (float)($$6 % 4 * 16 + 16) / 64.0f;
        float $$9 = (float)($$6 / 4 * 16 + 0) / 64.0f;
        float $$10 = (float)($$6 / 4 * 16 + 16) / 64.0f;
        float $$11 = 1.0f;
        float $$12 = 0.5f;
        float $$13 = 0.25f;
        float $$14 = 255.0f;
        float $$15 = ((float)p_114599_.tickCount + p_114601_) / 2.0f;
        int $$16 = (int)((Mth.sin($$15 + 0.0f) + 1.0f) * 0.5f * 255.0f);
        int $$17 = 255;
        int $$18 = (int)((Mth.sin($$15 + 4.1887903f) + 1.0f) * 0.1f * 255.0f);
        p_114602_.translate(0.0f, 0.1f, 0.0f);
        p_114602_.mulPose(this.entityRenderDispatcher.cameraOrientation());
        float $$19 = 0.3f;
        p_114602_.scale(0.3f, 0.3f, 0.3f);
        VertexConsumer $$20 = p_114603_.getBuffer(RENDER_TYPE);
        PoseStack.Pose $$21 = p_114602_.last();
        ExperienceOrbRenderer.vertex($$20, $$21, -0.5f, -0.25f, $$16, 255, $$18, $$7, $$10, p_114604_);
        ExperienceOrbRenderer.vertex($$20, $$21, 0.5f, -0.25f, $$16, 255, $$18, $$8, $$10, p_114604_);
        ExperienceOrbRenderer.vertex($$20, $$21, 0.5f, 0.75f, $$16, 255, $$18, $$8, $$9, p_114604_);
        ExperienceOrbRenderer.vertex($$20, $$21, -0.5f, 0.75f, $$16, 255, $$18, $$7, $$9, p_114604_);
        p_114602_.popPose();
        super.render(p_114599_, p_114600_, p_114601_, p_114602_, p_114603_, p_114604_);
    }

    private static void vertex(VertexConsumer p_254515_, PoseStack.Pose p_324046_, float p_253952_, float p_254066_, int p_254283_, int p_254566_, int p_253882_, float p_254434_, float p_254223_, int p_254372_) {
        p_254515_.addVertex(p_324046_, p_253952_, p_254066_, 0.0f).setColor(p_254283_, p_254566_, p_253882_, 128).setUv(p_254434_, p_254223_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_254372_).setNormal(p_324046_, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(ExperienceOrb p_114597_) {
        return EXPERIENCE_ORB_LOCATION;
    }
}

