/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class EntityRenderer<T extends Entity> {
    protected static final float NAMETAG_SCALE = 0.025f;
    public static final int LEASH_RENDER_STEPS = 24;
    protected final EntityRenderDispatcher entityRenderDispatcher;
    private final Font font;
    protected float shadowRadius;
    protected float shadowStrength = 1.0f;

    protected EntityRenderer(EntityRendererProvider.Context p_174008_) {
        this.entityRenderDispatcher = p_174008_.getEntityRenderDispatcher();
        this.font = p_174008_.getFont();
    }

    public final int getPackedLightCoords(T p_114506_, float p_114507_) {
        BlockPos $$2 = BlockPos.containing(((Entity)p_114506_).getLightProbePosition(p_114507_));
        return LightTexture.pack(this.getBlockLightLevel(p_114506_, $$2), this.getSkyLightLevel(p_114506_, $$2));
    }

    protected int getSkyLightLevel(T p_114509_, BlockPos p_114510_) {
        return ((Entity)p_114509_).level().getBrightness(LightLayer.SKY, p_114510_);
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        if (((Entity)p_114496_).isOnFire()) {
            return 15;
        }
        return ((Entity)p_114496_).level().getBrightness(LightLayer.BLOCK, p_114497_);
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        Leashable $$6;
        Entity $$7;
        if (!((Entity)p_114491_).shouldRender(p_114493_, p_114494_, p_114495_)) {
            return false;
        }
        if (((Entity)p_114491_).noCulling) {
            return true;
        }
        AABB $$5 = ((Entity)p_114491_).getBoundingBoxForCulling().inflate(0.5);
        if ($$5.hasNaN() || $$5.getSize() == 0.0) {
            $$5 = new AABB(((Entity)p_114491_).getX() - 2.0, ((Entity)p_114491_).getY() - 2.0, ((Entity)p_114491_).getZ() - 2.0, ((Entity)p_114491_).getX() + 2.0, ((Entity)p_114491_).getY() + 2.0, ((Entity)p_114491_).getZ() + 2.0);
        }
        if (p_114492_.isVisible($$5)) {
            return true;
        }
        if (p_114491_ instanceof Leashable && ($$7 = ($$6 = (Leashable)p_114491_).getLeashHolder()) != null) {
            return p_114492_.isVisible($$7.getBoundingBoxForCulling());
        }
        return false;
    }

    public Vec3 getRenderOffset(T p_114483_, float p_114484_) {
        return Vec3.ZERO;
    }

    public void render(T p_114485_, float p_114486_, float p_114487_, PoseStack p_114488_, MultiBufferSource p_114489_, int p_114490_) {
        Leashable $$6;
        Entity $$7;
        if (p_114485_ instanceof Leashable && ($$7 = ($$6 = (Leashable)p_114485_).getLeashHolder()) != null) {
            this.renderLeash(p_114485_, p_114487_, p_114488_, p_114489_, $$7);
        }
        if (!this.shouldShowName(p_114485_)) {
            return;
        }
        this.renderNameTag(p_114485_, ((Entity)p_114485_).getDisplayName(), p_114488_, p_114489_, p_114490_, p_114487_);
    }

    private <E extends Entity> void renderLeash(T p_352225_, float p_352465_, PoseStack p_352205_, MultiBufferSource p_352444_, E p_352269_) {
        p_352205_.pushPose();
        Vec3 $$5 = p_352269_.getRopeHoldPosition(p_352465_);
        double $$6 = (double)(((Entity)p_352225_).getPreciseBodyRotation(p_352465_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 $$7 = ((Entity)p_352225_).getLeashOffset(p_352465_);
        double $$8 = Math.cos($$6) * $$7.z + Math.sin($$6) * $$7.x;
        double $$9 = Math.sin($$6) * $$7.z - Math.cos($$6) * $$7.x;
        double $$10 = Mth.lerp((double)p_352465_, ((Entity)p_352225_).xo, ((Entity)p_352225_).getX()) + $$8;
        double $$11 = Mth.lerp((double)p_352465_, ((Entity)p_352225_).yo, ((Entity)p_352225_).getY()) + $$7.y;
        double $$12 = Mth.lerp((double)p_352465_, ((Entity)p_352225_).zo, ((Entity)p_352225_).getZ()) + $$9;
        p_352205_.translate($$8, $$7.y, $$9);
        float $$13 = (float)($$5.x - $$10);
        float $$14 = (float)($$5.y - $$11);
        float $$15 = (float)($$5.z - $$12);
        float $$16 = 0.025f;
        VertexConsumer $$17 = p_352444_.getBuffer(RenderType.leash());
        Matrix4f $$18 = p_352205_.last().pose();
        float $$19 = Mth.invSqrt($$13 * $$13 + $$15 * $$15) * 0.025f / 2.0f;
        float $$20 = $$15 * $$19;
        float $$21 = $$13 * $$19;
        BlockPos $$22 = BlockPos.containing(((Entity)p_352225_).getEyePosition(p_352465_));
        BlockPos $$23 = BlockPos.containing(p_352269_.getEyePosition(p_352465_));
        int $$24 = this.getBlockLightLevel(p_352225_, $$22);
        int $$25 = this.entityRenderDispatcher.getRenderer(p_352269_).getBlockLightLevel(p_352269_, $$23);
        int $$26 = ((Entity)p_352225_).level().getBrightness(LightLayer.SKY, $$22);
        int $$27 = ((Entity)p_352225_).level().getBrightness(LightLayer.SKY, $$23);
        for (int $$28 = 0; $$28 <= 24; ++$$28) {
            EntityRenderer.addVertexPair($$17, $$18, $$13, $$14, $$15, $$24, $$25, $$26, $$27, 0.025f, 0.025f, $$20, $$21, $$28, false);
        }
        for (int $$29 = 24; $$29 >= 0; --$$29) {
            EntityRenderer.addVertexPair($$17, $$18, $$13, $$14, $$15, $$24, $$25, $$26, $$27, 0.025f, 0.0f, $$20, $$21, $$29, true);
        }
        p_352205_.popPose();
    }

    private static void addVertexPair(VertexConsumer p_352095_, Matrix4f p_352142_, float p_352462_, float p_352226_, float p_352086_, int p_352406_, int p_352470_, int p_352371_, int p_352167_, float p_352293_, float p_352138_, float p_352315_, float p_352162_, int p_352291_, boolean p_352079_) {
        float $$15 = (float)p_352291_ / 24.0f;
        int $$16 = (int)Mth.lerp($$15, p_352406_, p_352470_);
        int $$17 = (int)Mth.lerp($$15, p_352371_, p_352167_);
        int $$18 = LightTexture.pack($$16, $$17);
        float $$19 = p_352291_ % 2 == (p_352079_ ? 1 : 0) ? 0.7f : 1.0f;
        float $$20 = 0.5f * $$19;
        float $$21 = 0.4f * $$19;
        float $$22 = 0.3f * $$19;
        float $$23 = p_352462_ * $$15;
        float $$24 = p_352226_ > 0.0f ? p_352226_ * $$15 * $$15 : p_352226_ - p_352226_ * (1.0f - $$15) * (1.0f - $$15);
        float $$25 = p_352086_ * $$15;
        p_352095_.addVertex(p_352142_, $$23 - p_352315_, $$24 + p_352138_, $$25 + p_352162_).setColor($$20, $$21, $$22, 1.0f).setLight($$18);
        p_352095_.addVertex(p_352142_, $$23 + p_352315_, $$24 + p_352293_ - p_352138_, $$25 - p_352162_).setColor($$20, $$21, $$22, 1.0f).setLight($$18);
    }

    protected boolean shouldShowName(T p_114504_) {
        return ((Entity)p_114504_).shouldShowName() || ((Entity)p_114504_).hasCustomName() && p_114504_ == this.entityRenderDispatcher.crosshairPickEntity;
    }

    public abstract ResourceLocation getTextureLocation(T var1);

    public Font getFont() {
        return this.font;
    }

    protected void renderNameTag(T p_114498_, Component p_114499_, PoseStack p_114500_, MultiBufferSource p_114501_, int p_114502_, float p_316698_) {
        double $$6 = this.entityRenderDispatcher.distanceToSqr((Entity)p_114498_);
        if ($$6 > 4096.0) {
            return;
        }
        Vec3 $$7 = ((Entity)p_114498_).getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, ((Entity)p_114498_).getViewYRot(p_316698_));
        if ($$7 == null) {
            return;
        }
        boolean $$8 = !((Entity)p_114498_).isDiscrete();
        int $$9 = "deadmau5".equals(p_114499_.getString()) ? -10 : 0;
        p_114500_.pushPose();
        p_114500_.translate($$7.x, $$7.y + 0.5, $$7.z);
        p_114500_.mulPose(this.entityRenderDispatcher.cameraOrientation());
        p_114500_.scale(0.025f, -0.025f, 0.025f);
        Matrix4f $$10 = p_114500_.last().pose();
        float $$11 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int $$12 = (int)($$11 * 255.0f) << 24;
        Font $$13 = this.getFont();
        float $$14 = -$$13.width(p_114499_) / 2;
        $$13.drawInBatch(p_114499_, $$14, (float)$$9, 0x20FFFFFF, false, $$10, p_114501_, $$8 ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, $$12, p_114502_);
        if ($$8) {
            $$13.drawInBatch(p_114499_, $$14, (float)$$9, -1, false, $$10, p_114501_, Font.DisplayMode.NORMAL, 0, p_114502_);
        }
        p_114500_.popPose();
    }

    protected float getShadowRadius(T p_316475_) {
        return this.shadowRadius;
    }
}

