/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import org.joml.Matrix4f;

public class PostChain
implements AutoCloseable {
    private static final String MAIN_RENDER_TARGET = "minecraft:main";
    private final RenderTarget screenTarget;
    private final ResourceProvider resourceProvider;
    private final String name;
    private final List<PostPass> passes = Lists.newArrayList();
    private final Map<String, RenderTarget> customRenderTargets = Maps.newHashMap();
    private final List<RenderTarget> fullSizedTargets = Lists.newArrayList();
    private Matrix4f shaderOrthoMatrix;
    private int screenWidth;
    private int screenHeight;
    private float time;
    private float lastStamp;

    public PostChain(TextureManager p_110018_, ResourceProvider p_330592_, RenderTarget p_110020_, ResourceLocation p_110021_) throws IOException, JsonSyntaxException {
        this.resourceProvider = p_330592_;
        this.screenTarget = p_110020_;
        this.time = 0.0f;
        this.lastStamp = 0.0f;
        this.screenWidth = p_110020_.viewWidth;
        this.screenHeight = p_110020_.viewHeight;
        this.name = p_110021_.toString();
        this.updateOrthoMatrix();
        this.load(p_110018_, p_110021_);
    }

    private void load(TextureManager p_110034_, ResourceLocation p_110035_) throws IOException, JsonSyntaxException {
        block15: {
            Resource $$2 = this.resourceProvider.getResourceOrThrow(p_110035_);
            try (BufferedReader $$3 = $$2.openAsReader();){
                JsonObject $$4 = GsonHelper.parse($$3);
                if (GsonHelper.isArrayNode($$4, "targets")) {
                    JsonArray $$5 = $$4.getAsJsonArray("targets");
                    int $$6 = 0;
                    for (JsonElement $$7 : $$5) {
                        try {
                            this.parseTargetNode($$7);
                        }
                        catch (Exception $$8) {
                            ChainedJsonException $$9 = ChainedJsonException.forException($$8);
                            $$9.prependJsonKey("targets[" + $$6 + "]");
                            throw $$9;
                        }
                        ++$$6;
                    }
                }
                if (!GsonHelper.isArrayNode($$4, "passes")) break block15;
                JsonArray $$10 = $$4.getAsJsonArray("passes");
                int $$11 = 0;
                for (JsonElement $$12 : $$10) {
                    try {
                        this.parsePassNode(p_110034_, $$12);
                    }
                    catch (Exception $$13) {
                        ChainedJsonException $$14 = ChainedJsonException.forException($$13);
                        $$14.prependJsonKey("passes[" + $$11 + "]");
                        throw $$14;
                    }
                    ++$$11;
                }
            }
            catch (Exception $$15) {
                ChainedJsonException $$16 = ChainedJsonException.forException($$15);
                $$16.setFilenameAndFlush(p_110035_.getPath() + " (" + $$2.sourcePackId() + ")");
                throw $$16;
            }
        }
    }

    private void parseTargetNode(JsonElement p_110029_) throws ChainedJsonException {
        if (GsonHelper.isStringValue(p_110029_)) {
            this.addTempTarget(p_110029_.getAsString(), this.screenWidth, this.screenHeight);
        } else {
            JsonObject $$1 = GsonHelper.convertToJsonObject(p_110029_, "target");
            String $$2 = GsonHelper.getAsString($$1, "name");
            int $$3 = GsonHelper.getAsInt($$1, "width", this.screenWidth);
            int $$4 = GsonHelper.getAsInt($$1, "height", this.screenHeight);
            if (this.customRenderTargets.containsKey($$2)) {
                throw new ChainedJsonException($$2 + " is already defined");
            }
            this.addTempTarget($$2, $$3, $$4);
        }
    }

    private void parsePassNode(TextureManager p_110031_, JsonElement p_110032_) throws IOException {
        JsonArray $$28;
        JsonObject $$2 = GsonHelper.convertToJsonObject(p_110032_, "pass");
        String $$3 = GsonHelper.getAsString($$2, "name");
        String $$4 = GsonHelper.getAsString($$2, "intarget");
        String $$5 = GsonHelper.getAsString($$2, "outtarget");
        RenderTarget $$6 = this.getRenderTarget($$4);
        RenderTarget $$7 = this.getRenderTarget($$5);
        boolean $$8 = GsonHelper.getAsBoolean($$2, "use_linear_filter", false);
        if ($$6 == null) {
            throw new ChainedJsonException("Input target '" + $$4 + "' does not exist");
        }
        if ($$7 == null) {
            throw new ChainedJsonException("Output target '" + $$5 + "' does not exist");
        }
        PostPass $$9 = this.addPass($$3, $$6, $$7, $$8);
        JsonArray $$10 = GsonHelper.getAsJsonArray($$2, "auxtargets", null);
        if ($$10 != null) {
            int $$11 = 0;
            for (JsonElement $$12 : $$10) {
                try {
                    String $$19;
                    boolean $$18;
                    JsonObject $$13 = GsonHelper.convertToJsonObject($$12, "auxtarget");
                    String $$14 = GsonHelper.getAsString($$13, "name");
                    String $$15 = GsonHelper.getAsString($$13, "id");
                    if ($$15.endsWith(":depth")) {
                        boolean $$16 = true;
                        String $$17 = $$15.substring(0, $$15.lastIndexOf(58));
                    } else {
                        $$18 = false;
                        $$19 = $$15;
                    }
                    RenderTarget $$20 = this.getRenderTarget($$19);
                    if ($$20 == null) {
                        if ($$18) {
                            throw new ChainedJsonException("Render target '" + $$19 + "' can't be used as depth buffer");
                        }
                        ResourceLocation $$21 = ResourceLocation.withDefaultNamespace("textures/effect/" + $$19 + ".png");
                        this.resourceProvider.getResource($$21).orElseThrow(() -> new ChainedJsonException("Render target or texture '" + $$19 + "' does not exist"));
                        RenderSystem.setShaderTexture(0, $$21);
                        p_110031_.bindForSetup($$21);
                        AbstractTexture $$22 = p_110031_.getTexture($$21);
                        int $$23 = GsonHelper.getAsInt($$13, "width");
                        int $$24 = GsonHelper.getAsInt($$13, "height");
                        boolean $$25 = GsonHelper.getAsBoolean($$13, "bilinear");
                        if ($$25) {
                            RenderSystem.texParameter(3553, 10241, 9729);
                            RenderSystem.texParameter(3553, 10240, 9729);
                        } else {
                            RenderSystem.texParameter(3553, 10241, 9728);
                            RenderSystem.texParameter(3553, 10240, 9728);
                        }
                        $$9.addAuxAsset($$14, $$22::getId, $$23, $$24);
                    } else if ($$18) {
                        $$9.addAuxAsset($$14, $$20::getDepthTextureId, $$20.width, $$20.height);
                    } else {
                        $$9.addAuxAsset($$14, $$20::getColorTextureId, $$20.width, $$20.height);
                    }
                }
                catch (Exception $$26) {
                    ChainedJsonException $$27 = ChainedJsonException.forException($$26);
                    $$27.prependJsonKey("auxtargets[" + $$11 + "]");
                    throw $$27;
                }
                ++$$11;
            }
        }
        if (($$28 = GsonHelper.getAsJsonArray($$2, "uniforms", null)) != null) {
            int $$29 = 0;
            for (JsonElement $$30 : $$28) {
                try {
                    this.parseUniformNode($$30);
                }
                catch (Exception $$31) {
                    ChainedJsonException $$32 = ChainedJsonException.forException($$31);
                    $$32.prependJsonKey("uniforms[" + $$29 + "]");
                    throw $$32;
                }
                ++$$29;
            }
        }
    }

    private void parseUniformNode(JsonElement p_110048_) throws ChainedJsonException {
        JsonObject $$1 = GsonHelper.convertToJsonObject(p_110048_, "uniform");
        String $$2 = GsonHelper.getAsString($$1, "name");
        Uniform $$3 = this.passes.get(this.passes.size() - 1).getEffect().getUniform($$2);
        if ($$3 == null) {
            throw new ChainedJsonException("Uniform '" + $$2 + "' does not exist");
        }
        float[] $$4 = new float[4];
        int $$5 = 0;
        JsonArray $$6 = GsonHelper.getAsJsonArray($$1, "values");
        for (JsonElement $$7 : $$6) {
            try {
                $$4[$$5] = GsonHelper.convertToFloat($$7, "value");
            }
            catch (Exception $$8) {
                ChainedJsonException $$9 = ChainedJsonException.forException($$8);
                $$9.prependJsonKey("values[" + $$5 + "]");
                throw $$9;
            }
            ++$$5;
        }
        switch ($$5) {
            case 0: {
                break;
            }
            case 1: {
                $$3.set($$4[0]);
                break;
            }
            case 2: {
                $$3.set($$4[0], $$4[1]);
                break;
            }
            case 3: {
                $$3.set($$4[0], $$4[1], $$4[2]);
                break;
            }
            case 4: {
                $$3.set($$4[0], $$4[1], $$4[2], $$4[3]);
            }
        }
    }

    public RenderTarget getTempTarget(String p_110037_) {
        return this.customRenderTargets.get(p_110037_);
    }

    public void addTempTarget(String p_110039_, int p_110040_, int p_110041_) {
        TextureTarget $$3 = new TextureTarget(p_110040_, p_110041_, true, Minecraft.ON_OSX);
        $$3.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.customRenderTargets.put(p_110039_, $$3);
        if (p_110040_ == this.screenWidth && p_110041_ == this.screenHeight) {
            this.fullSizedTargets.add($$3);
        }
    }

    @Override
    public void close() {
        for (RenderTarget $$0 : this.customRenderTargets.values()) {
            $$0.destroyBuffers();
        }
        for (PostPass $$1 : this.passes) {
            $$1.close();
        }
        this.passes.clear();
    }

    public PostPass addPass(String p_110043_, RenderTarget p_110044_, RenderTarget p_110045_, boolean p_334079_) throws IOException {
        PostPass $$4 = new PostPass(this.resourceProvider, p_110043_, p_110044_, p_110045_, p_334079_);
        this.passes.add(this.passes.size(), $$4);
        return $$4;
    }

    private void updateOrthoMatrix() {
        this.shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)this.screenTarget.width, 0.0f, (float)this.screenTarget.height, 0.1f, 1000.0f);
    }

    public void resize(int p_110026_, int p_110027_) {
        this.screenWidth = this.screenTarget.width;
        this.screenHeight = this.screenTarget.height;
        this.updateOrthoMatrix();
        for (PostPass $$2 : this.passes) {
            $$2.setOrthoMatrix(this.shaderOrthoMatrix);
        }
        for (RenderTarget $$3 : this.fullSizedTargets) {
            $$3.resize(p_110026_, p_110027_, Minecraft.ON_OSX);
        }
    }

    private void setFilterMode(int p_333852_) {
        this.screenTarget.setFilterMode(p_333852_);
        for (RenderTarget $$1 : this.customRenderTargets.values()) {
            $$1.setFilterMode(p_333852_);
        }
    }

    public void process(float p_110024_) {
        this.time += p_110024_;
        while (this.time > 20.0f) {
            this.time -= 20.0f;
        }
        int $$1 = 9728;
        for (PostPass $$2 : this.passes) {
            int $$3 = $$2.getFilterMode();
            if ($$1 != $$3) {
                this.setFilterMode($$3);
                $$1 = $$3;
            }
            $$2.process(this.time / 20.0f);
        }
        this.setFilterMode(9728);
    }

    public void setUniform(String p_332204_, float p_331999_) {
        for (PostPass $$2 : this.passes) {
            $$2.getEffect().safeGetUniform(p_332204_).set(p_331999_);
        }
    }

    public final String getName() {
        return this.name;
    }

    @Nullable
    private RenderTarget getRenderTarget(@Nullable String p_110050_) {
        if (p_110050_ == null) {
            return null;
        }
        if (p_110050_.equals(MAIN_RENDER_TARGET)) {
            return this.screenTarget;
        }
        return this.customRenderTargets.get(p_110050_);
    }
}

