/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.util.PngInfo;
import org.slf4j.Logger;

public class ServerData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ICON_SIZE = 1024;
    public String name;
    public String ip;
    public Component status;
    public Component motd;
    @Nullable
    public ServerStatus.Players players;
    public long ping;
    public int protocol = SharedConstants.getCurrentVersion().getProtocolVersion();
    public Component version = Component.literal(SharedConstants.getCurrentVersion().getName());
    public List<Component> playerList = Collections.emptyList();
    private ServerPackStatus packStatus = ServerPackStatus.PROMPT;
    @Nullable
    private byte[] iconBytes;
    private Type type;
    private State state = State.INITIAL;

    public ServerData(String p_105375_, String p_105376_, Type p_295587_) {
        this.name = p_105375_;
        this.ip = p_105376_;
        this.type = p_295587_;
    }

    public CompoundTag write() {
        CompoundTag $$0 = new CompoundTag();
        $$0.putString("name", this.name);
        $$0.putString("ip", this.ip);
        if (this.iconBytes != null) {
            $$0.putString("icon", Base64.getEncoder().encodeToString(this.iconBytes));
        }
        if (this.packStatus == ServerPackStatus.ENABLED) {
            $$0.putBoolean("acceptTextures", true);
        } else if (this.packStatus == ServerPackStatus.DISABLED) {
            $$0.putBoolean("acceptTextures", false);
        }
        return $$0;
    }

    public ServerPackStatus getResourcePackStatus() {
        return this.packStatus;
    }

    public void setResourcePackStatus(ServerPackStatus p_105380_) {
        this.packStatus = p_105380_;
    }

    public static ServerData read(CompoundTag p_105386_) {
        ServerData $$1 = new ServerData(p_105386_.getString("name"), p_105386_.getString("ip"), Type.OTHER);
        if (p_105386_.contains("icon", 8)) {
            try {
                byte[] $$2 = Base64.getDecoder().decode(p_105386_.getString("icon"));
                $$1.setIconBytes(ServerData.validateIcon($$2));
            }
            catch (IllegalArgumentException $$3) {
                LOGGER.warn("Malformed base64 server icon", (Throwable)$$3);
            }
        }
        if (p_105386_.contains("acceptTextures", 1)) {
            if (p_105386_.getBoolean("acceptTextures")) {
                $$1.setResourcePackStatus(ServerPackStatus.ENABLED);
            } else {
                $$1.setResourcePackStatus(ServerPackStatus.DISABLED);
            }
        } else {
            $$1.setResourcePackStatus(ServerPackStatus.PROMPT);
        }
        return $$1;
    }

    @Nullable
    public byte[] getIconBytes() {
        return this.iconBytes;
    }

    public void setIconBytes(@Nullable byte[] p_272760_) {
        this.iconBytes = p_272760_;
    }

    public boolean isLan() {
        return this.type == Type.LAN;
    }

    public boolean isRealm() {
        return this.type == Type.REALM;
    }

    public Type type() {
        return this.type;
    }

    public void copyNameIconFrom(ServerData p_233804_) {
        this.ip = p_233804_.ip;
        this.name = p_233804_.name;
        this.iconBytes = p_233804_.iconBytes;
    }

    public void copyFrom(ServerData p_105382_) {
        this.copyNameIconFrom(p_105382_);
        this.setResourcePackStatus(p_105382_.getResourcePackStatus());
        this.type = p_105382_.type;
    }

    public State state() {
        return this.state;
    }

    public void setState(State p_316214_) {
        this.state = p_316214_;
    }

    @Nullable
    public static byte[] validateIcon(@Nullable byte[] p_302394_) {
        if (p_302394_ != null) {
            try {
                PngInfo $$1 = PngInfo.fromBytes(p_302394_);
                if ($$1.width() <= 1024 && $$1.height() <= 1024) {
                    return p_302394_;
                }
            }
            catch (IOException $$2) {
                LOGGER.warn("Failed to decode server icon", (Throwable)$$2);
            }
        }
        return null;
    }

    public static enum ServerPackStatus {
        ENABLED("enabled"),
        DISABLED("disabled"),
        PROMPT("prompt");

        private final Component name;

        private ServerPackStatus(String p_105399_) {
            this.name = Component.translatable("addServer.resourcePack." + p_105399_);
        }

        public Component getName() {
            return this.name;
        }
    }

    public static enum State {
        INITIAL,
        PINGING,
        UNREACHABLE,
        INCOMPATIBLE,
        SUCCESSFUL;

    }

    public static enum Type {
        LAN,
        REALM,
        OTHER;

    }
}

