/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorStandModel
extends ArmorStandArmorModel {
    private static final String RIGHT_BODY_STICK = "right_body_stick";
    private static final String LEFT_BODY_STICK = "left_body_stick";
    private static final String SHOULDER_STICK = "shoulder_stick";
    private static final String BASE_PLATE = "base_plate";
    private final ModelPart rightBodyStick;
    private final ModelPart leftBodyStick;
    private final ModelPart shoulderStick;
    private final ModelPart basePlate;

    public ArmorStandModel(ModelPart p_170356_) {
        super(p_170356_);
        this.rightBodyStick = p_170356_.getChild(RIGHT_BODY_STICK);
        this.leftBodyStick = p_170356_.getChild(LEFT_BODY_STICK);
        this.shoulderStick = p_170356_.getChild(SHOULDER_STICK);
        this.basePlate = p_170356_.getChild(BASE_PLATE);
        this.hat.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = HumanoidModel.createMesh(CubeDeformation.NONE, 0.0f);
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offset(0.0f, 1.0f, 0.0f));
        $$1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-6.0f, 0.0f, -1.5f, 12.0f, 3.0f, 3.0f), PartPose.ZERO);
        $$1.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset(-5.0f, 2.0f, 0.0f));
        $$1.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 16).mirror().addBox(0.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset(5.0f, 2.0f, 0.0f));
        $$1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(8, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset(-1.9f, 12.0f, 0.0f));
        $$1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset(1.9f, 12.0f, 0.0f));
        $$1.addOrReplaceChild(RIGHT_BODY_STICK, CubeListBuilder.create().texOffs(16, 0).addBox(-3.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.ZERO);
        $$1.addOrReplaceChild(LEFT_BODY_STICK, CubeListBuilder.create().texOffs(48, 16).addBox(1.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.ZERO);
        $$1.addOrReplaceChild(SHOULDER_STICK, CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, 10.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.ZERO);
        $$1.addOrReplaceChild(BASE_PLATE, CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, 11.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.offset(0.0f, 12.0f, 0.0f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void prepareMobModel(ArmorStand p_102172_, float p_102173_, float p_102174_, float p_102175_) {
        this.basePlate.xRot = 0.0f;
        this.basePlate.yRot = (float)Math.PI / 180 * -Mth.rotLerp(p_102175_, p_102172_.yRotO, p_102172_.getYRot());
        this.basePlate.zRot = 0.0f;
    }

    @Override
    public void setupAnim(ArmorStand p_102177_, float p_102178_, float p_102179_, float p_102180_, float p_102181_, float p_102182_) {
        super.setupAnim(p_102177_, p_102178_, p_102179_, p_102180_, p_102181_, p_102182_);
        this.leftArm.visible = p_102177_.isShowArms();
        this.rightArm.visible = p_102177_.isShowArms();
        this.basePlate.visible = !p_102177_.isNoBasePlate();
        this.rightBodyStick.xRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getX();
        this.rightBodyStick.yRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getY();
        this.rightBodyStick.zRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getZ();
        this.leftBodyStick.xRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getX();
        this.leftBodyStick.yRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getY();
        this.leftBodyStick.zRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getZ();
        this.shoulderStick.xRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getX();
        this.shoulderStick.yRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getY();
        this.shoulderStick.zRot = (float)Math.PI / 180 * p_102177_.getBodyPose().getZ();
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat(super.bodyParts(), (Iterable)ImmutableList.of((Object)this.rightBodyStick, (Object)this.leftBodyStick, (Object)this.shoulderStick, (Object)this.basePlate));
    }

    @Override
    public void translateToHand(HumanoidArm p_102157_, PoseStack p_102158_) {
        ModelPart $$2 = this.getArm(p_102157_);
        boolean $$3 = $$2.visible;
        $$2.visible = true;
        super.translateToHand(p_102157_, p_102158_);
        $$2.visible = $$3;
    }
}

