/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.reporting;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.chat.ChatLog;
import net.minecraft.client.multiplayer.chat.LoggedChatEvent;
import net.minecraft.client.multiplayer.chat.LoggedChatMessage;
import net.minecraft.client.multiplayer.chat.report.ChatReportContextBuilder;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageLink;

public class ChatSelectionLogFiller {
    private final ChatLog log;
    private final ChatReportContextBuilder contextBuilder;
    private final Predicate<LoggedChatMessage.Player> canReport;
    @Nullable
    private SignedMessageLink previousLink = null;
    private int eventId;
    private int missedCount;
    @Nullable
    private PlayerChatMessage lastMessage;

    public ChatSelectionLogFiller(ReportingContext p_251076_, Predicate<LoggedChatMessage.Player> p_250367_) {
        this.log = p_251076_.chatLog();
        this.contextBuilder = new ChatReportContextBuilder(p_251076_.sender().reportLimits().leadingContextMessageCount());
        this.canReport = p_250367_;
        this.eventId = this.log.end();
    }

    public void fillNextPage(int p_239016_, Output p_239017_) {
        LoggedChatEvent $$3;
        int $$2 = 0;
        while ($$2 < p_239016_ && ($$3 = this.log.lookup(this.eventId)) != null) {
            LoggedChatMessage.Player $$5;
            int $$4 = this.eventId--;
            if (!($$3 instanceof LoggedChatMessage.Player) || ($$5 = (LoggedChatMessage.Player)$$3).message().equals(this.lastMessage)) continue;
            if (this.acceptMessage(p_239017_, $$5)) {
                if (this.missedCount > 0) {
                    p_239017_.acceptDivider(Component.translatable("gui.chatSelection.fold", this.missedCount));
                    this.missedCount = 0;
                }
                p_239017_.acceptMessage($$4, $$5);
                ++$$2;
            } else {
                ++this.missedCount;
            }
            this.lastMessage = $$5.message();
        }
    }

    private boolean acceptMessage(Output p_254300_, LoggedChatMessage.Player p_253803_) {
        PlayerChatMessage $$2 = p_253803_.message();
        boolean $$3 = this.contextBuilder.acceptContext($$2);
        if (this.canReport.test(p_253803_)) {
            this.contextBuilder.trackContext($$2);
            if (this.previousLink != null && !this.previousLink.isDescendantOf($$2.link())) {
                p_254300_.acceptDivider(Component.translatable("gui.chatSelection.join", p_253803_.profile().getName()).withStyle(ChatFormatting.YELLOW));
            }
            this.previousLink = $$2.link();
            return true;
        }
        return $$3;
    }

    public static interface Output {
        public void acceptMessage(int var1, LoggedChatMessage.Player var2);

        public void acceptDivider(Component var1);
    }
}

