/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ItemDurabilityTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer p_43670_, ItemStack p_43671_, int p_43672_) {
        this.trigger(p_43670_, p_43676_ -> p_43676_.matches(p_43671_, p_43672_));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, MinMaxBounds.Ints durability, MinMaxBounds.Ints delta) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337370_ -> p_337370_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("durability", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::durability), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("delta", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::delta)).apply((Applicative)p_337370_, TriggerInstance::new));

        public static Criterion<TriggerInstance> changedDurability(Optional<ItemPredicate> p_299020_, MinMaxBounds.Ints p_151288_) {
            return TriggerInstance.changedDurability(Optional.empty(), p_299020_, p_151288_);
        }

        public static Criterion<TriggerInstance> changedDurability(Optional<ContextAwarePredicate> p_299196_, Optional<ItemPredicate> p_299039_, MinMaxBounds.Ints p_286730_) {
            return CriteriaTriggers.ITEM_DURABILITY_CHANGED.createCriterion(new TriggerInstance(p_299196_, p_299039_, p_286730_, MinMaxBounds.Ints.ANY));
        }

        public boolean matches(ItemStack p_43699_, int p_43700_) {
            if (this.item.isPresent() && !this.item.get().test(p_43699_)) {
                return false;
            }
            if (!this.durability.matches(p_43699_.getMaxDamage() - p_43700_)) {
                return false;
            }
            return this.delta.matches(p_43699_.getDamageValue() - p_43700_);
        }
    }
}

