/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public class Util {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_MAX_THREADS = 255;
    private static final int DEFAULT_SAFE_FILE_OPERATION_RETRIES = 10;
    private static final String MAX_THREADS_SYSTEM_PROPERTY = "max.bg.threads";
    private static final ExecutorService BACKGROUND_EXECUTOR = Util.makeExecutor("Main");
    private static final ExecutorService IO_POOL = Util.makeIoExecutor("IO-Worker-", false);
    private static final ExecutorService DOWNLOAD_POOL = Util.makeIoExecutor("Download-", true);
    private static final DateTimeFormatter FILENAME_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static final int LINEAR_LOOKUP_THRESHOLD = 8;
    private static final Set<String> ALLOWED_UNTRUSTED_LINK_PROTOCOLS = Set.of("http", "https");
    public static final long NANOS_PER_MILLI = 1000000L;
    public static TimeSource.NanoTimeSource timeSource = System::nanoTime;
    public static final Ticker TICKER = new Ticker(){

        public long read() {
            return timeSource.getAsLong();
        }
    };
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final FileSystemProvider ZIP_FILE_SYSTEM_PROVIDER = FileSystemProvider.installedProviders().stream().filter(p_201865_ -> p_201865_.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    private static Consumer<String> thePauser = p_201905_ -> {};

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, List<T>> toMutableList() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public static <T extends Comparable<T>> String getPropertyName(Property<T> p_137454_, Object p_137455_) {
        return p_137454_.getName((Comparable)p_137455_);
    }

    public static String makeDescriptionId(String p_137493_, @Nullable ResourceLocation p_137494_) {
        if (p_137494_ == null) {
            return p_137493_ + ".unregistered_sadface";
        }
        return p_137493_ + "." + p_137494_.getNamespace() + "." + p_137494_.getPath().replace('/', '.');
    }

    public static long getMillis() {
        return Util.getNanos() / 1000000L;
    }

    public static long getNanos() {
        return timeSource.getAsLong();
    }

    public static long getEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    public static String getFilenameFormattedDateTime() {
        return FILENAME_DATE_TIME_FORMATTER.format(ZonedDateTime.now());
    }

    private static ExecutorService makeExecutor(String p_137478_) {
        ForkJoinPool $$4;
        int $$1 = Mth.clamp(Runtime.getRuntime().availableProcessors() - 1, 1, Util.getMaxThreads());
        if ($$1 <= 0) {
            ListeningExecutorService $$2 = MoreExecutors.newDirectExecutorService();
        } else {
            AtomicInteger $$3 = new AtomicInteger(1);
            $$4 = new ForkJoinPool($$1, p_314383_ -> {
                ForkJoinWorkerThread $$3 = new ForkJoinWorkerThread(p_314383_){

                    @Override
                    protected void onTermination(Throwable p_211561_) {
                        if (p_211561_ != null) {
                            LOGGER.warn("{} died", (Object)this.getName(), (Object)p_211561_);
                        } else {
                            LOGGER.debug("{} shutdown", (Object)this.getName());
                        }
                        super.onTermination(p_211561_);
                    }
                };
                $$3.setName("Worker-" + p_137478_ + "-" + $$3.getAndIncrement());
                return $$3;
            }, Util::onThreadException, true);
        }
        return $$4;
    }

    private static int getMaxThreads() {
        String $$0 = System.getProperty(MAX_THREADS_SYSTEM_PROPERTY);
        if ($$0 != null) {
            try {
                int $$1 = Integer.parseInt($$0);
                if ($$1 >= 1 && $$1 <= 255) {
                    return $$1;
                }
                LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, $$0, 255});
            }
            catch (NumberFormatException $$2) {
                LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, $$0, 255});
            }
        }
        return 255;
    }

    public static ExecutorService backgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static ExecutorService ioPool() {
        return IO_POOL;
    }

    public static ExecutorService nonCriticalIoPool() {
        return DOWNLOAD_POOL;
    }

    public static void shutdownExecutors() {
        Util.shutdownExecutor(BACKGROUND_EXECUTOR);
        Util.shutdownExecutor(IO_POOL);
    }

    private static void shutdownExecutor(ExecutorService p_137532_) {
        boolean $$3;
        p_137532_.shutdown();
        try {
            boolean $$1 = p_137532_.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException $$2) {
            $$3 = false;
        }
        if (!$$3) {
            p_137532_.shutdownNow();
        }
    }

    private static ExecutorService makeIoExecutor(String p_314465_, boolean p_314461_) {
        AtomicInteger $$2 = new AtomicInteger(1);
        return Executors.newCachedThreadPool(p_314387_ -> {
            Thread $$4 = new Thread(p_314387_);
            $$4.setName(p_314465_ + $$2.getAndIncrement());
            $$4.setDaemon(p_314461_);
            $$4.setUncaughtExceptionHandler(Util::onThreadException);
            return $$4;
        });
    }

    public static void throwAsRuntime(Throwable p_137560_) {
        throw p_137560_ instanceof RuntimeException ? (RuntimeException)p_137560_ : new RuntimeException(p_137560_);
    }

    private static void onThreadException(Thread p_137496_, Throwable p_137497_) {
        Util.pauseInIde(p_137497_);
        if (p_137497_ instanceof CompletionException) {
            p_137497_ = p_137497_.getCause();
        }
        if (p_137497_ instanceof ReportedException) {
            ReportedException $$2 = (ReportedException)p_137497_;
            Bootstrap.realStdoutPrintln($$2.getReport().getFriendlyReport(ReportType.CRASH));
            System.exit(-1);
        }
        LOGGER.error(String.format(Locale.ROOT, "Caught exception in thread %s", p_137496_), p_137497_);
    }

    @Nullable
    public static Type<?> fetchChoiceType(DSL.TypeReference p_137457_, String p_137458_) {
        if (!SharedConstants.CHECK_DATA_FIXER_SCHEMA) {
            return null;
        }
        return Util.doFetchChoiceType(p_137457_, p_137458_);
    }

    @Nullable
    private static Type<?> doFetchChoiceType(DSL.TypeReference p_137552_, String p_137553_) {
        Type $$2;
        block2: {
            $$2 = null;
            try {
                $$2 = DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getDataVersion().getVersion())).getChoiceType(p_137552_, p_137553_);
            }
            catch (IllegalArgumentException $$3) {
                LOGGER.error("No data fixer registered for {}", (Object)p_137553_);
                if (!SharedConstants.IS_RUNNING_IN_IDE) break block2;
                throw $$3;
            }
        }
        return $$2;
    }

    public static Runnable wrapThreadWithTaskName(String p_143788_, Runnable p_143789_) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return () -> {
                Thread $$2 = Thread.currentThread();
                String $$3 = $$2.getName();
                $$2.setName(p_143788_);
                try {
                    p_143789_.run();
                }
                finally {
                    $$2.setName($$3);
                }
            };
        }
        return p_143789_;
    }

    public static <V> Supplier<V> wrapThreadWithTaskName(String p_183947_, Supplier<V> p_183948_) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return () -> {
                Thread $$2 = Thread.currentThread();
                String $$3 = $$2.getName();
                $$2.setName(p_183947_);
                try {
                    Object t = p_183948_.get();
                    return t;
                }
                finally {
                    $$2.setName($$3);
                }
            };
        }
        return p_183948_;
    }

    public static <T> String getRegisteredName(Registry<T> p_331026_, T p_331334_) {
        ResourceLocation $$2 = p_331026_.getKey(p_331334_);
        if ($$2 == null) {
            return "[unregistered]";
        }
        return $$2.toString();
    }

    public static <T> Predicate<T> allOf(List<? extends Predicate<T>> p_323679_) {
        return switch (p_323679_.size()) {
            case 0 -> p_323042_ -> true;
            case 1 -> p_323679_.get(0);
            case 2 -> p_323679_.get(0).and(p_323679_.get(1));
            default -> {
                Predicate[] $$1 = (Predicate[])p_323679_.toArray(Predicate[]::new);
                yield p_352651_ -> {
                    for (Predicate $$2 : $$1) {
                        if ($$2.test(p_352651_)) continue;
                        return false;
                    }
                    return true;
                };
            }
        };
    }

    public static <T> Predicate<T> anyOf(List<? extends Predicate<T>> p_323722_) {
        return switch (p_323722_.size()) {
            case 0 -> p_323047_ -> false;
            case 1 -> p_323722_.get(0);
            case 2 -> p_323722_.get(0).or(p_323722_.get(1));
            default -> {
                Predicate[] $$1 = (Predicate[])p_323722_.toArray(Predicate[]::new);
                yield p_352655_ -> {
                    for (Predicate $$2 : $$1) {
                        if (!$$2.test(p_352655_)) continue;
                        return true;
                    }
                    return false;
                };
            }
        };
    }

    public static <T> boolean isSymmetrical(int p_345051_, int p_345034_, List<T> p_346318_) {
        if (p_345051_ == 1) {
            return true;
        }
        int $$3 = p_345051_ / 2;
        for (int $$4 = 0; $$4 < p_345034_; ++$$4) {
            for (int $$5 = 0; $$5 < $$3; ++$$5) {
                T $$8;
                int $$6 = p_345051_ - 1 - $$5;
                T $$7 = p_346318_.get($$5 + $$4 * p_345051_);
                if ($$7.equals($$8 = p_346318_.get($$6 + $$4 * p_345051_))) continue;
                return false;
            }
        }
        return true;
    }

    public static OS getPlatform() {
        String $$0 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if ($$0.contains("win")) {
            return OS.WINDOWS;
        }
        if ($$0.contains("mac")) {
            return OS.OSX;
        }
        if ($$0.contains("solaris")) {
            return OS.SOLARIS;
        }
        if ($$0.contains("sunos")) {
            return OS.SOLARIS;
        }
        if ($$0.contains("linux")) {
            return OS.LINUX;
        }
        if ($$0.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static URI parseAndValidateUntrustedUri(String p_352394_) throws URISyntaxException {
        URI $$1 = new URI(p_352394_);
        String $$2 = $$1.getScheme();
        if ($$2 == null) {
            throw new URISyntaxException(p_352394_, "Missing protocol in URI: " + p_352394_);
        }
        String $$3 = $$2.toLowerCase(Locale.ROOT);
        if (!ALLOWED_UNTRUSTED_LINK_PROTOCOLS.contains($$3)) {
            throw new URISyntaxException(p_352394_, "Unsupported protocol in URI: " + p_352394_);
        }
        return $$1;
    }

    public static Stream<String> getVmArguments() {
        RuntimeMXBean $$0 = ManagementFactory.getRuntimeMXBean();
        return $$0.getInputArguments().stream().filter(p_201903_ -> p_201903_.startsWith("-X"));
    }

    public static <T> T lastOf(List<T> p_137510_) {
        return p_137510_.get(p_137510_.size() - 1);
    }

    public static <T> T findNextInIterable(Iterable<T> p_137467_, @Nullable T p_137468_) {
        Iterator<T> $$2 = p_137467_.iterator();
        T $$3 = $$2.next();
        if (p_137468_ != null) {
            T $$4 = $$3;
            while (true) {
                if ($$4 == p_137468_) {
                    if (!$$2.hasNext()) break;
                    return $$2.next();
                }
                if (!$$2.hasNext()) continue;
                $$4 = $$2.next();
            }
        }
        return $$3;
    }

    public static <T> T findPreviousInIterable(Iterable<T> p_137555_, @Nullable T p_137556_) {
        Iterator<T> $$2 = p_137555_.iterator();
        T $$3 = null;
        while ($$2.hasNext()) {
            T $$4 = $$2.next();
            if ($$4 == p_137556_) {
                if ($$3 != null) break;
                $$3 = (T)($$2.hasNext() ? Iterators.getLast($$2) : p_137556_);
                break;
            }
            $$3 = $$4;
        }
        return $$3;
    }

    public static <T> T make(Supplier<T> p_137538_) {
        return p_137538_.get();
    }

    public static <T> T make(T p_137470_, Consumer<? super T> p_137471_) {
        p_137471_.accept(p_137470_);
        return p_137470_;
    }

    public static <V> CompletableFuture<List<V>> sequence(List<? extends CompletableFuture<V>> p_137568_) {
        if (p_137568_.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (p_137568_.size() == 1) {
            return p_137568_.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> $$1 = CompletableFuture.allOf(p_137568_.toArray(new CompletableFuture[0]));
        return $$1.thenApply(p_203746_ -> p_137568_.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFast(List<? extends CompletableFuture<? extends V>> p_143841_) {
        CompletableFuture $$1 = new CompletableFuture();
        return Util.fallibleSequence(p_143841_, $$1::completeExceptionally).applyToEither((CompletionStage)$$1, Function.identity());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFastAndCancel(List<? extends CompletableFuture<? extends V>> p_214685_) {
        CompletableFuture $$1 = new CompletableFuture();
        return Util.fallibleSequence(p_214685_, p_274642_ -> {
            if ($$1.completeExceptionally((Throwable)p_274642_)) {
                for (CompletableFuture $$3 : p_214685_) {
                    $$3.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)$$1, Function.identity());
    }

    private static <V> CompletableFuture<List<V>> fallibleSequence(List<? extends CompletableFuture<? extends V>> p_214632_, Consumer<Throwable> p_214633_) {
        ArrayList $$2 = Lists.newArrayListWithCapacity((int)p_214632_.size());
        CompletableFuture[] $$3 = new CompletableFuture[p_214632_.size()];
        p_214632_.forEach(p_214641_ -> {
            int $$4 = $$2.size();
            $$2.add(null);
            p_214639_[$$4] = p_214641_.whenComplete((p_214650_, p_214651_) -> {
                if (p_214651_ != null) {
                    p_214633_.accept((Throwable)p_214651_);
                } else {
                    $$2.set($$4, p_214650_);
                }
            });
        });
        return CompletableFuture.allOf($$3).thenApply(p_214626_ -> $$2);
    }

    public static <T> Optional<T> ifElse(Optional<T> p_137522_, Consumer<T> p_137523_, Runnable p_137524_) {
        if (p_137522_.isPresent()) {
            p_137523_.accept(p_137522_.get());
        } else {
            p_137524_.run();
        }
        return p_137522_;
    }

    public static <T> Supplier<T> name(Supplier<T> p_214656_, Supplier<String> p_214657_) {
        return p_214656_;
    }

    public static Runnable name(Runnable p_137475_, Supplier<String> p_137476_) {
        return p_137475_;
    }

    public static void logAndPauseIfInIde(String p_143786_) {
        LOGGER.error(p_143786_);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(p_143786_);
        }
    }

    public static void logAndPauseIfInIde(String p_200891_, Throwable p_200892_) {
        LOGGER.error(p_200891_, p_200892_);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(p_200891_);
        }
    }

    public static <T extends Throwable> T pauseInIde(T p_137571_) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.error("Trying to throw a fatal exception, pausing in IDE", p_137571_);
            Util.doPause(p_137571_.getMessage());
        }
        return p_137571_;
    }

    public static void setPause(Consumer<String> p_183970_) {
        thePauser = p_183970_;
    }

    private static void doPause(String p_183985_) {
        boolean $$2;
        Instant $$1 = Instant.now();
        LOGGER.warn("Did you remember to set a breakpoint here?");
        boolean bl = $$2 = Duration.between($$1, Instant.now()).toMillis() > 500L;
        if (!$$2) {
            thePauser.accept(p_183985_);
        }
    }

    public static String describeError(Throwable p_137576_) {
        if (p_137576_.getCause() != null) {
            return Util.describeError(p_137576_.getCause());
        }
        if (p_137576_.getMessage() != null) {
            return p_137576_.getMessage();
        }
        return p_137576_.toString();
    }

    public static <T> T getRandom(T[] p_214671_, RandomSource p_214672_) {
        return p_214671_[p_214672_.nextInt(p_214671_.length)];
    }

    public static int getRandom(int[] p_214668_, RandomSource p_214669_) {
        return p_214668_[p_214669_.nextInt(p_214668_.length)];
    }

    public static <T> T getRandom(List<T> p_214622_, RandomSource p_214623_) {
        return p_214622_.get(p_214623_.nextInt(p_214622_.size()));
    }

    public static <T> Optional<T> getRandomSafe(List<T> p_214677_, RandomSource p_214678_) {
        if (p_214677_.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Util.getRandom(p_214677_, p_214678_));
    }

    private static BooleanSupplier createRenamer(final Path p_137503_, final Path p_137504_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(p_137503_, p_137504_, new CopyOption[0]);
                    return true;
                }
                catch (IOException $$0) {
                    LOGGER.error("Failed to rename", (Throwable)$$0);
                    return false;
                }
            }

            public String toString() {
                return "rename " + String.valueOf(p_137503_) + " to " + String.valueOf(p_137504_);
            }
        };
    }

    private static BooleanSupplier createDeleter(final Path p_137501_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(p_137501_);
                    return true;
                }
                catch (IOException $$0) {
                    LOGGER.warn("Failed to delete", (Throwable)$$0);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + String.valueOf(p_137501_);
            }
        };
    }

    private static BooleanSupplier createFileDeletedCheck(final Path p_137562_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(p_137562_, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(p_137562_) + " is deleted";
            }
        };
    }

    private static BooleanSupplier createFileCreatedCheck(final Path p_137573_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(p_137573_, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(p_137573_) + " is present";
            }
        };
    }

    private static boolean executeInSequence(BooleanSupplier ... p_137549_) {
        for (BooleanSupplier $$1 : p_137549_) {
            if ($$1.getAsBoolean()) continue;
            LOGGER.warn("Failed to execute {}", (Object)$$1);
            return false;
        }
        return true;
    }

    private static boolean runWithRetries(int p_137450_, String p_137451_, BooleanSupplier ... p_137452_) {
        for (int $$3 = 0; $$3 < p_137450_; ++$$3) {
            if (Util.executeInSequence(p_137452_)) {
                return true;
            }
            LOGGER.error("Failed to {}, retrying {}/{}", new Object[]{p_137451_, $$3, p_137450_});
        }
        LOGGER.error("Failed to {}, aborting, progress might be lost", (Object)p_137451_);
        return false;
    }

    public static void safeReplaceFile(Path p_137506_, Path p_137507_, Path p_137508_) {
        Util.safeReplaceOrMoveFile(p_137506_, p_137507_, p_137508_, false);
    }

    public static boolean safeReplaceOrMoveFile(Path p_307599_, Path p_307197_, Path p_307407_, boolean p_212228_) {
        if (Files.exists(p_307599_, new LinkOption[0]) && !Util.runWithRetries(10, "create backup " + String.valueOf(p_307407_), Util.createDeleter(p_307407_), Util.createRenamer(p_307599_, p_307407_), Util.createFileCreatedCheck(p_307407_))) {
            return false;
        }
        if (!Util.runWithRetries(10, "remove old " + String.valueOf(p_307599_), Util.createDeleter(p_307599_), Util.createFileDeletedCheck(p_307599_))) {
            return false;
        }
        if (!Util.runWithRetries(10, "replace " + String.valueOf(p_307599_) + " with " + String.valueOf(p_307197_), Util.createRenamer(p_307197_, p_307599_), Util.createFileCreatedCheck(p_307599_)) && !p_212228_) {
            Util.runWithRetries(10, "restore " + String.valueOf(p_307599_) + " from " + String.valueOf(p_307407_), Util.createRenamer(p_307407_, p_307599_), Util.createFileCreatedCheck(p_307599_));
            return false;
        }
        return true;
    }

    public static int offsetByCodepoints(String p_137480_, int p_137481_, int p_137482_) {
        int $$3 = p_137480_.length();
        if (p_137482_ >= 0) {
            for (int $$4 = 0; p_137481_ < $$3 && $$4 < p_137482_; ++$$4) {
                if (!Character.isHighSurrogate(p_137480_.charAt(p_137481_++)) || p_137481_ >= $$3 || !Character.isLowSurrogate(p_137480_.charAt(p_137481_))) continue;
                ++p_137481_;
            }
        } else {
            for (int $$5 = p_137482_; p_137481_ > 0 && $$5 < 0; ++$$5) {
                if (!Character.isLowSurrogate(p_137480_.charAt(--p_137481_)) || p_137481_ <= 0 || !Character.isHighSurrogate(p_137480_.charAt(p_137481_ - 1))) continue;
                --p_137481_;
            }
        }
        return p_137481_;
    }

    public static Consumer<String> prefix(String p_137490_, Consumer<String> p_137491_) {
        return p_214645_ -> p_137491_.accept(p_137490_ + p_214645_);
    }

    public static DataResult<int[]> fixedSize(IntStream p_137540_, int p_137541_) {
        int[] $$2 = p_137540_.limit(p_137541_ + 1).toArray();
        if ($$2.length != p_137541_) {
            Supplier<String> $$3 = () -> "Input is not a list of " + p_137541_ + " ints";
            if ($$2.length >= p_137541_) {
                return DataResult.error($$3, (Object)Arrays.copyOf($$2, p_137541_));
            }
            return DataResult.error($$3);
        }
        return DataResult.success((Object)$$2);
    }

    public static DataResult<long[]> fixedSize(LongStream p_287579_, int p_287631_) {
        long[] $$2 = p_287579_.limit(p_287631_ + 1).toArray();
        if ($$2.length != p_287631_) {
            Supplier<String> $$3 = () -> "Input is not a list of " + p_287631_ + " longs";
            if ($$2.length >= p_287631_) {
                return DataResult.error($$3, (Object)Arrays.copyOf($$2, p_287631_));
            }
            return DataResult.error($$3);
        }
        return DataResult.success((Object)$$2);
    }

    public static <T> DataResult<List<T>> fixedSize(List<T> p_143796_, int p_143797_) {
        if (p_143796_.size() != p_143797_) {
            Supplier<String> $$2 = () -> "Input is not a list of " + p_143797_ + " elements";
            if (p_143796_.size() >= p_143797_) {
                return DataResult.error($$2, p_143796_.subList(0, p_143797_));
            }
            return DataResult.error($$2);
        }
        return DataResult.success(p_143796_);
    }

    public static void startTimerHackThread() {
        Thread $$0 = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException $$0) {
                    LOGGER.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        $$0.setDaemon(true);
        $$0.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        $$0.start();
    }

    public static void copyBetweenDirs(Path p_137564_, Path p_137565_, Path p_137566_) throws IOException {
        Path $$3 = p_137564_.relativize(p_137566_);
        Path $$4 = p_137565_.resolve($$3);
        Files.copy(p_137566_, $$4, new CopyOption[0]);
    }

    public static String sanitizeName(String p_137484_, CharPredicate p_137485_) {
        return p_137484_.toLowerCase(Locale.ROOT).chars().mapToObj(p_214666_ -> p_137485_.test((char)p_214666_) ? Character.toString((char)p_214666_) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> singleKeyCache(Function<K, V> p_270326_) {
        return new SingleKeyCache<K, V>(p_270326_);
    }

    public static <T, R> Function<T, R> memoize(final Function<T, R> p_143828_) {
        return new Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T p_214691_) {
                return this.cache.computeIfAbsent(p_214691_, p_143828_);
            }

            public String toString() {
                return "memoize/1[function=" + String.valueOf(p_143828_) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(final BiFunction<T, U, R> p_143822_) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T p_214700_, U p_214701_) {
                return this.cache.computeIfAbsent(Pair.of(p_214700_, p_214701_), p_214698_ -> p_143822_.apply(p_214698_.getFirst(), p_214698_.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + String.valueOf(p_143822_) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T> List<T> toShuffledList(Stream<T> p_214662_, RandomSource p_214663_) {
        ObjectArrayList $$2 = (ObjectArrayList)p_214662_.collect(ObjectArrayList.toList());
        Util.shuffle($$2, p_214663_);
        return $$2;
    }

    public static IntArrayList toShuffledList(IntStream p_214659_, RandomSource p_214660_) {
        int $$3;
        IntArrayList $$2 = IntArrayList.wrap((int[])p_214659_.toArray());
        for (int $$4 = $$3 = $$2.size(); $$4 > 1; --$$4) {
            int $$5 = p_214660_.nextInt($$4);
            $$2.set($$4 - 1, $$2.set($$5, $$2.getInt($$4 - 1)));
        }
        return $$2;
    }

    public static <T> List<T> shuffledCopy(T[] p_214682_, RandomSource p_214683_) {
        ObjectArrayList $$2 = new ObjectArrayList((Object[])p_214682_);
        Util.shuffle($$2, p_214683_);
        return $$2;
    }

    public static <T> List<T> shuffledCopy(ObjectArrayList<T> p_214612_, RandomSource p_214613_) {
        ObjectArrayList $$2 = new ObjectArrayList(p_214612_);
        Util.shuffle($$2, p_214613_);
        return $$2;
    }

    public static <T> void shuffle(List<T> p_309187_, RandomSource p_214675_) {
        int $$2;
        for (int $$3 = $$2 = p_309187_.size(); $$3 > 1; --$$3) {
            int $$4 = p_214675_.nextInt($$3);
            p_309187_.set($$3 - 1, p_309187_.set($$4, p_309187_.get($$3 - 1)));
        }
    }

    public static <T> CompletableFuture<T> blockUntilDone(Function<Executor, CompletableFuture<T>> p_214680_) {
        return Util.blockUntilDone(p_214680_, CompletableFuture::isDone);
    }

    public static <T> T blockUntilDone(Function<Executor, T> p_214653_, Predicate<T> p_214654_) {
        int $$6;
        LinkedBlockingQueue $$2 = new LinkedBlockingQueue();
        T $$3 = p_214653_.apply($$2::add);
        while (!p_214654_.test($$3)) {
            try {
                Runnable $$4 = (Runnable)$$2.poll(100L, TimeUnit.MILLISECONDS);
                if ($$4 == null) continue;
                $$4.run();
            }
            catch (InterruptedException $$5) {
                LOGGER.warn("Interrupted wait");
                break;
            }
        }
        if (($$6 = $$2.size()) > 0) {
            LOGGER.warn("Tasks left in queue: {}", (Object)$$6);
        }
        return $$3;
    }

    public static <T> ToIntFunction<T> createIndexLookup(List<T> p_214687_) {
        int $$1 = p_214687_.size();
        if ($$1 < 8) {
            return p_214687_::indexOf;
        }
        Object2IntOpenHashMap $$2 = new Object2IntOpenHashMap($$1);
        $$2.defaultReturnValue(-1);
        for (int $$3 = 0; $$3 < $$1; ++$$3) {
            $$2.put(p_214687_.get($$3), $$3);
        }
        return $$2;
    }

    public static <T> ToIntFunction<T> createIndexIdentityLookup(List<T> p_304758_) {
        int $$1 = p_304758_.size();
        if ($$1 < 8) {
            ReferenceImmutableList $$2 = new ReferenceImmutableList(p_304758_);
            return arg_0 -> ((ReferenceList)$$2).indexOf(arg_0);
        }
        Reference2IntOpenHashMap $$3 = new Reference2IntOpenHashMap($$1);
        $$3.defaultReturnValue(-1);
        for (int $$4 = 0; $$4 < $$1; ++$$4) {
            $$3.put(p_304758_.get($$4), $$4);
        }
        return $$3;
    }

    public static <A, B> Typed<B> writeAndReadTypedOrThrow(Typed<A> p_311873_, Type<B> p_312554_, UnaryOperator<Dynamic<?>> p_311990_) {
        Dynamic $$3 = (Dynamic)p_311873_.write().getOrThrow();
        return Util.readTypedOrThrow(p_312554_, (Dynamic)p_311990_.apply($$3), true);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> p_312508_, Dynamic<?> p_312911_) {
        return Util.readTypedOrThrow(p_312508_, p_312911_, false);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> p_313853_, Dynamic<?> p_313851_, boolean p_313933_) {
        DataResult $$3 = p_313853_.readTyped(p_313851_).map(Pair::getFirst);
        try {
            if (p_313933_) {
                return (Typed)$$3.getPartialOrThrow(IllegalStateException::new);
            }
            return (Typed)$$3.getOrThrow(IllegalStateException::new);
        }
        catch (IllegalStateException $$4) {
            CrashReport $$5 = CrashReport.forThrowable($$4, "Reading type");
            CrashReportCategory $$6 = $$5.addCategory("Info");
            $$6.setDetail("Data", p_313851_);
            $$6.setDetail("Type", p_313853_);
            throw new ReportedException($$5);
        }
    }

    public static <T> List<T> copyAndAdd(List<T> p_331978_, T p_331554_) {
        return ImmutableList.builderWithExpectedSize((int)(p_331978_.size() + 1)).addAll(p_331978_).add(p_331554_).build();
    }

    public static <T> List<T> copyAndAdd(T p_335459_, List<T> p_335538_) {
        return ImmutableList.builderWithExpectedSize((int)(p_335538_.size() + 1)).add(p_335459_).addAll(p_335538_).build();
    }

    public static <K, V> Map<K, V> copyAndPut(Map<K, V> p_330429_, K p_330814_, V p_330949_) {
        return ImmutableMap.builderWithExpectedSize((int)(p_330429_.size() + 1)).putAll(p_330429_).put(p_330814_, p_330949_).buildKeepingLast();
    }

    public static enum OS {
        LINUX("linux"),
        SOLARIS("solaris"),
        WINDOWS("windows"){

            @Override
            protected String[] getOpenUriArguments(URI p_352177_) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", p_352177_.toString()};
            }
        }
        ,
        OSX("mac"){

            @Override
            protected String[] getOpenUriArguments(URI p_352407_) {
                return new String[]{"open", p_352407_.toString()};
            }
        }
        ,
        UNKNOWN("unknown");

        private final String telemetryName;

        OS(String p_183998_) {
            this.telemetryName = p_183998_;
        }

        public void openUri(URI p_137649_) {
            try {
                Process $$1 = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.getOpenUriArguments(p_137649_)));
                $$1.getInputStream().close();
                $$1.getErrorStream().close();
                $$1.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException $$2) {
                LOGGER.error("Couldn't open location '{}'", (Object)p_137649_, (Object)$$2);
            }
        }

        public void openFile(File p_137645_) {
            this.openUri(p_137645_.toURI());
        }

        public void openPath(Path p_352210_) {
            this.openUri(p_352210_.toUri());
        }

        protected String[] getOpenUriArguments(URI p_352257_) {
            String $$1 = p_352257_.toString();
            if ("file".equals(p_352257_.getScheme())) {
                $$1 = $$1.replace("file:", "file://");
            }
            return new String[]{"xdg-open", $$1};
        }

        public void openUri(String p_137647_) {
            try {
                this.openUri(new URI(p_137647_));
            }
            catch (IllegalArgumentException | URISyntaxException $$1) {
                LOGGER.error("Couldn't open uri '{}'", (Object)p_137647_, (Object)$$1);
            }
        }

        public String telemetryName() {
            return this.telemetryName;
        }
    }
}

