/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.util.RealmsTextureManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RealmsWorldSlotButton
extends Button {
    private static final ResourceLocation SLOT_FRAME_SPRITE = ResourceLocation.withDefaultNamespace("widget/slot_frame");
    private static final ResourceLocation CHECKMARK_SPRITE = ResourceLocation.withDefaultNamespace("icon/checkmark");
    public static final ResourceLocation EMPTY_SLOT_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/realms/empty_frame.png");
    public static final ResourceLocation DEFAULT_WORLD_SLOT_1 = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_0.png");
    public static final ResourceLocation DEFAULT_WORLD_SLOT_2 = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_2.png");
    public static final ResourceLocation DEFAULT_WORLD_SLOT_3 = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_3.png");
    private static final Component SLOT_ACTIVE_TOOLTIP = Component.translatable("mco.configure.world.slot.tooltip.active");
    private static final Component SWITCH_TO_MINIGAME_SLOT_TOOLTIP = Component.translatable("mco.configure.world.slot.tooltip.minigame");
    private static final Component SWITCH_TO_WORLD_SLOT_TOOLTIP = Component.translatable("mco.configure.world.slot.tooltip");
    static final Component MINIGAME = Component.translatable("mco.worldSlot.minigame");
    private final int slotIndex;
    @Nullable
    private State state;

    public RealmsWorldSlotButton(int p_87929_, int p_87930_, int p_87931_, int p_87932_, int p_87935_, Button.OnPress p_87936_) {
        super(p_87929_, p_87930_, p_87931_, p_87932_, CommonComponents.EMPTY, p_87936_, DEFAULT_NARRATION);
        this.slotIndex = p_87935_;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public void setServerData(RealmsServer p_307266_) {
        this.state = new State(p_307266_, this.slotIndex);
        this.setTooltipAndNarration(this.state, p_307266_.minigameName);
    }

    private void setTooltipAndNarration(State p_307359_, @Nullable String p_307244_) {
        Component $$2;
        switch (p_307359_.action.ordinal()) {
            case 2: {
                Component component = SLOT_ACTIVE_TOOLTIP;
                break;
            }
            case 1: {
                Component component;
                if (p_307359_.minigame) {
                    component = SWITCH_TO_MINIGAME_SLOT_TOOLTIP;
                    break;
                }
                component = SWITCH_TO_WORLD_SLOT_TOOLTIP;
                break;
            }
            default: {
                Component component = $$2 = null;
            }
        }
        if ($$2 != null) {
            this.setTooltip(Tooltip.create($$2));
        }
        MutableComponent $$3 = Component.literal(p_307359_.slotName);
        if (p_307359_.minigame && p_307244_ != null) {
            $$3 = $$3.append(CommonComponents.SPACE).append(p_307244_);
        }
        this.setMessage($$3);
    }

    static Action getAction(RealmsServer p_87960_, boolean p_87961_, boolean p_87962_) {
        if (p_87961_ && !p_87960_.expired && p_87960_.state != RealmsServer.State.UNINITIALIZED) {
            return Action.JOIN;
        }
        if (!(p_87961_ || p_87962_ && p_87960_.expired)) {
            return Action.SWITCH_SLOT;
        }
        return Action.NOTHING;
    }

    @Override
    public void renderWidget(GuiGraphics p_282947_, int p_87965_, int p_87966_, float p_87967_) {
        boolean $$14;
        ResourceLocation $$13;
        if (this.state == null) {
            return;
        }
        int $$4 = this.getX();
        int $$5 = this.getY();
        boolean $$6 = this.isHoveredOrFocused();
        if (this.state.minigame) {
            ResourceLocation $$7 = RealmsTextureManager.worldTemplate(String.valueOf(this.state.imageId), this.state.image);
        } else if (this.state.empty) {
            ResourceLocation $$8 = EMPTY_SLOT_LOCATION;
        } else if (this.state.image != null && this.state.imageId != -1L) {
            ResourceLocation $$9 = RealmsTextureManager.worldTemplate(String.valueOf(this.state.imageId), this.state.image);
        } else if (this.slotIndex == 1) {
            ResourceLocation $$10 = DEFAULT_WORLD_SLOT_1;
        } else if (this.slotIndex == 2) {
            ResourceLocation $$11 = DEFAULT_WORLD_SLOT_2;
        } else if (this.slotIndex == 3) {
            ResourceLocation $$12 = DEFAULT_WORLD_SLOT_3;
        } else {
            $$13 = EMPTY_SLOT_LOCATION;
        }
        if (this.state.isCurrentlyActiveSlot) {
            p_282947_.setColor(0.56f, 0.56f, 0.56f, 1.0f);
        }
        p_282947_.blit($$13, $$4 + 3, $$5 + 3, 0.0f, 0.0f, 74, 74, 74, 74);
        boolean bl = $$14 = $$6 && this.state.action != Action.NOTHING;
        if ($$14) {
            p_282947_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        } else if (this.state.isCurrentlyActiveSlot) {
            p_282947_.setColor(0.8f, 0.8f, 0.8f, 1.0f);
        } else {
            p_282947_.setColor(0.56f, 0.56f, 0.56f, 1.0f);
        }
        p_282947_.blitSprite(SLOT_FRAME_SPRITE, $$4, $$5, 80, 80);
        p_282947_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.state.isCurrentlyActiveSlot) {
            RenderSystem.enableBlend();
            p_282947_.blitSprite(CHECKMARK_SPRITE, $$4 + 67, $$5 + 4, 9, 8);
            RenderSystem.disableBlend();
        }
        Font $$15 = Minecraft.getInstance().font;
        p_282947_.drawCenteredString($$15, this.state.slotName, $$4 + 40, $$5 + 66, -1);
        p_282947_.drawCenteredString($$15, RealmsMainScreen.getVersionComponent(this.state.slotVersion, this.state.compatibility.isCompatible()), $$4 + 40, $$5 + 80 + 2, -1);
    }

    public static class State {
        final boolean isCurrentlyActiveSlot;
        final String slotName;
        final String slotVersion;
        final RealmsServer.Compatibility compatibility;
        final long imageId;
        @Nullable
        final String image;
        public final boolean empty;
        public final boolean minigame;
        public final Action action;

        public State(RealmsServer p_307209_, int p_307377_) {
            boolean bl = this.minigame = p_307377_ == 4;
            if (this.minigame) {
                this.isCurrentlyActiveSlot = p_307209_.isMinigameActive();
                this.slotName = MINIGAME.getString();
                this.imageId = p_307209_.minigameId;
                this.image = p_307209_.minigameImage;
                this.empty = p_307209_.minigameId == -1;
                this.slotVersion = "";
                this.compatibility = RealmsServer.Compatibility.UNVERIFIABLE;
            } else {
                RealmsWorldOptions $$2 = p_307209_.slots.get(p_307377_);
                this.isCurrentlyActiveSlot = p_307209_.activeSlot == p_307377_ && !p_307209_.isMinigameActive();
                this.slotName = $$2.getSlotName(p_307377_);
                this.imageId = $$2.templateId;
                this.image = $$2.templateImage;
                this.empty = $$2.empty;
                this.slotVersion = $$2.version;
                this.compatibility = $$2.compatibility;
            }
            this.action = RealmsWorldSlotButton.getAction(p_307209_, this.isCurrentlyActiveSlot, this.minigame);
        }
    }

    public static enum Action {
        NOTHING,
        SWITCH_SLOT,
        JOIN;

    }
}

