/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer.detector;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public interface IFileDetector {
    public String name();

    public boolean enabled(HashMap<String, IFileDetector> var1);

    default public Path getLibraryDir() {
        String libraryDir = System.getProperty("forgewrapper.librariesDir");
        if (libraryDir != null) {
            return Paths.get(libraryDir, new String[0]).toAbsolutePath();
        }
        try {
            URL launcherLocation = null;
            String[] classNames = new String[]{"cpw/mods/modlauncher/Launcher.class", "net/neoforged/fml/loading/FMLLoader.class"};
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            for (String classResource : classNames) {
                String path;
                URL url = cl.getResource(classResource);
                if (url == null || !(path = url.toString()).startsWith("jar:") || !path.contains("!")) continue;
                path = path.substring(4, path.indexOf(33));
                try {
                    launcherLocation = new URL(path);
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (launcherLocation == null) {
                throw new UnsupportedOperationException("Could not detect the libraries folder - it can be manually specified with `-Dforgewrapper.librariesDir=` (Java runtime argument)");
            }
            Path launcher = Paths.get(launcherLocation.toURI());
            while (!launcher.getFileName().toString().equals("libraries")) {
                if ((launcher = launcher.getParent()) != null && launcher.getFileName() != null) continue;
                throw new UnsupportedOperationException("Could not detect the libraries folder - it can be manually specified with `-Dforgewrapper.librariesDir=` (Java runtime argument)");
            }
            return launcher.toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    default public Path getInstallerJar(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        String installer = System.getProperty("forgewrapper.installer");
        if (installer != null) {
            return Paths.get(installer, new String[0]).toAbsolutePath();
        }
        return null;
    }

    default public Path getMinecraftJar(String mcVersion) {
        String minecraft = System.getProperty("forgewrapper.minecraft");
        if (minecraft != null) {
            return Paths.get(minecraft, new String[0]).toAbsolutePath();
        }
        return null;
    }
}

