/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.api;

import cpw.mods.modlauncher.TransformList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class TargetType<T> {
    public static final TargetType<ClassNode> PRE_CLASS = new TargetType<ClassNode>("PRE_CLASS", ClassNode.class);
    public static final TargetType<ClassNode> CLASS = new TargetType<ClassNode>("CLASS", ClassNode.class);
    public static final TargetType<MethodNode> METHOD = new TargetType<MethodNode>("METHOD", MethodNode.class);
    public static final TargetType<FieldNode> FIELD = new TargetType<FieldNode>("FIELD", FieldNode.class);
    public static final TargetType<?>[] VALUES = new TargetType[]{PRE_CLASS, CLASS, METHOD, FIELD};
    private final String name;
    private final Class<T> nodeType;

    private TargetType(String name, Class<T> nodeType) {
        this.name = name;
        this.nodeType = nodeType;
    }

    public Class<T> getNodeType() {
        return this.nodeType;
    }

    public static TargetType<?> byName(String name) {
        return Stream.of(VALUES).filter(type -> type.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No TargetType of name " + name + " found"));
    }

    public TransformList<T> get(Map<TargetType<?>, TransformList<?>> transformers) {
        return transformers.get(this);
    }

    public Supplier<TransformList<T>> mapSupplier(Map<TargetType<?>, TransformList<?>> transformers) {
        return () -> (TransformList)transformers.get(this);
    }
}

