/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformerAuditTrail;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class LaunchPluginHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ILaunchPluginService> plugins;

    public LaunchPluginHandler(ModuleLayerHandler layerHandler) {
        this(ServiceLoaderUtils.streamServiceLoader(() -> ServiceLoader.load(layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow(), ILaunchPluginService.class), e -> LOGGER.fatal(LogMarkers.MODLAUNCHER, "Encountered serious error loading launch plugin service. Things will not work well", (Throwable)e)));
    }

    @VisibleForTesting
    public LaunchPluginHandler(Stream<ILaunchPluginService> plugins) {
        this.plugins = plugins.collect(Collectors.toMap(ILaunchPluginService::name, Function.identity()));
        List<Map> modlist = this.plugins.entrySet().stream().map(e -> Map.of("name", (String)e.getKey(), "type", "PLUGINSERVICE", "file", ServiceLoaderUtils.fileNameFor(((ILaunchPluginService)e.getValue()).getClass()))).toList();
        if (Launcher.INSTANCE != null) {
            Launcher.INSTANCE.environment().getProperty(IEnvironment.Keys.MODLIST.get()).ifPresentOrElse(mods -> mods.addAll(modlist), () -> {
                throw new RuntimeException("The MODLIST isn't set, huh?");
            });
        }
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found launch plugins: [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.plugins.keySet())});
    }

    public Optional<ILaunchPluginService> get(String name) {
        return Optional.ofNullable(this.plugins.get(name));
    }

    public EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>> computeLaunchPluginTransformerSet(Type className, boolean isEmpty, String reason, TransformerAuditTrail auditTrail) {
        HashSet<ILaunchPluginService> uniqueValues = new HashSet<ILaunchPluginService>();
        EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>> phaseObjectEnumMap = new EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>>(ILaunchPluginService.Phase.class);
        for (ILaunchPluginService plugin : this.plugins.values()) {
            for (ILaunchPluginService.Phase ph : plugin.handlesClass(className, isEmpty, reason)) {
                phaseObjectEnumMap.computeIfAbsent(ph, e -> new ArrayList()).add(plugin);
                if (!uniqueValues.add(plugin)) continue;
                plugin.customAuditConsumer(className.getClassName(), strings -> auditTrail.addPluginCustomAuditTrail(className.getClassName(), plugin, (String)strings));
            }
        }
        LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LaunchPluginService {}", new Supplier[]{() -> phaseObjectEnumMap});
        return phaseObjectEnumMap;
    }

    void offerScanResultsToPlugins(List<SecureJar> scanResults) {
        this.plugins.forEach((n, p) -> p.addResources(scanResults));
    }

    int offerClassNodeToPlugins(ILaunchPluginService.Phase phase, List<ILaunchPluginService> plugins, @Nullable ClassNode node, Type className, TransformerAuditTrail auditTrail, String reason) {
        int flags = 0;
        for (ILaunchPluginService iLaunchPluginService : plugins) {
            LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LauncherPluginService {} offering transform {}", (Object)iLaunchPluginService.name(), (Object)className.getClassName());
            int pluginFlags = iLaunchPluginService.processClassWithFlags(phase, node, className, reason);
            if (pluginFlags == 0) continue;
            auditTrail.addPluginAuditTrail(className.getClassName(), iLaunchPluginService, phase);
            LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LauncherPluginService {} transformed {} with class compute flags {}", (Object)iLaunchPluginService.name(), (Object)className.getClassName(), (Object)pluginFlags);
            flags |= pluginFlags;
        }
        LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "Final flags state for {} is {}", (Object)className.getClassName(), (Object)flags);
        return flags;
    }

    void announceLaunch(TransformingClassLoader transformerLoader, NamedPath[] specialPaths) {
        this.plugins.forEach((k, p) -> p.initializeLaunch(s -> transformerLoader.buildTransformedClassNodeFor(s, (String)k), specialPaths));
    }
}

