---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Терминалы
  icon: crafting_terminal
  position: 210
categories:
- devices
item_ids:
- ae2:terminal
- ae2:crafting_terminal
- ae2:pattern_encoding_terminal
- ae2:pattern_access_terminal
---

# Терминалы

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/terminals.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

В то время как <ItemLink id="pattern_provider" />, <ItemLink id="import_bus" />, <ItemLink id="storage_bus" /> и т. д.
являются основным способом взаимодействия сети AE2 с окружающим миром, терминалы являются основным способом взаимодействия сети AE2
с *вами*. Существует несколько вариантов с разными функциями.

Терминалы будут наследовать цвет [кабеля](cables.md), на который они установлены.

Терминалы являются [подразделами кабелями](../ae2-mechanics/cable-subparts.md).

## Размещение терминала

Поскольку терминал часто является первым [подразделом](../ae2-mechanics/cable-subparts.md), которую кто-то может установить,
часто случается, что ее устанавливают неправильно, обратной стороной. Вот пример того, что нужно делать, а чего не нужно:

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/terminal_placement.snbt" />
  <IsometricCamera yaw="195" pitch="30" />

  <LineAnnotation color="#ff3333" from="2.5 .5 .5" to="4.5 2.5 .5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#ff3333" from="2.5 2.5 .5" to="4.5 .5 .5" alwaysOnTop={true} thickness="0.05"/>

  <LineAnnotation color="#33ff33" from="-.5 2.5 .5" to="1 .5 .5" alwaysOnTop={true} thickness="0.05"/>
  <LineAnnotation color="#33ff33" from="1 .5 .5" to="1.5 1 .5" alwaysOnTop={true} thickness="0.05"/>
</GameScene>

У вас по-прежнему есть терминал и приемник энергии, только теперь терминал расположен правильно и действительно
подключен к сети, и все это помещается в более компактном пространстве.

<a name="terminal-ui"></a>

# Терминал

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Ваш основной терминал, позволяющий просматривать и получать доступ к содержимому вашего [сетевого хранилища](../ae2-mechanics/import-export-storage.md)
и запрашивать вещи из вашей установки [автоматического крафта](../ae2-mechanics/autocrafting.md).

## Пользовательский интерфейс

Пользовательский интерфейс основного терминала состоит из нескольких разделов

Центральная часть интерфейса предоставляет доступ к хранилищу вашей сети. Вы можете помещать предметы внутрь и забирать их обратно.
Существует несколько сочетаний клавиш и кнопок мыши:

*   Левой кнопкой мыши захватывается стак, правой — половина стака.
*   Если предмет, жидкость и т. д. могут быть [автоматически созданы](../ae2-mechanics/autocrafting.md),
   все, что вы привязали к «выбору блока» (обычно средняя кнопка мыши), вызывает интерфейс для указания количества, которое нужно изготовить. Вы также можете вводить формулы, такие как `3*64/2`,
    или набрать `=32`, чтобы изготовить только то количество предметов, которое необходимо для достижения 32 в вашем хранилище.
*   Удерживание клавиши Shift приведет к заморозке отображаемых предметов на месте, предотвращая их перегруппировку при изменении количества или появлении новых предметов в системе.
*   Щелчок правой кнопкой мыши с ведром или другим контейнером для жидкости приведет к выливанию жидкости, а щелчок левой кнопкой мыши по жидкости в терминале с
  пустым контейнером для жидкости приведет к извлечению жидкости.

В левой части находятся кнопки настроек:

*   Сортировка по различным атрибутам, таким как название, мод и количество
*   Просмотр хранимых, создаваемых или обоих
*   Просмотр предметов, жидкостей или и того, и другого
*   Изменить порядок сортировки
*   Открыть окно с подробными настройками терминала
*   Изменить высоту интерфейса терминала

Справа есть слоты для <ItemLink id="view_cell" />

В правом верхнем углу центральной секции (кнопка молотка) отображается статус пользовательского интерфейса [автоматического крафта](../ae2-mechanics/autocrafting.md), позволяющий вам видеть прогресс ваших автоматических крафтов и то, что делает каждый [процессор изготовления](crafting_cpu_multiblock.md).

## Рецепт

<RecipeFor id="terminal" />

<a name="crafting-terminal-ui"></a>

# Терминал изготовления

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/crafting_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Терминал изготовления похож на обычный терминал, с теми же настройками и разделами, но с добавленной сеткой крафта, которая будет автоматически
пополняться из [сетевого хранилища](../ae2-mechanics/import-export-storage.md). **Будьте осторожны, когда нажимаете Shift и щелкаете по выводу!**

Вам следует как можно скорее улучшить свой терминал до терминала изготовления предметов.

## Пользовательский интерфейс

Терминал изготовления имеет тот же интерфейс, что и обычный терминал, но с добавленной сеткой для крафта в центре.

Есть 2 дополнительные кнопки, чтобы очистить сетку крафта в сетевое хранилище или ваш инвентарь.

## Рецепт

<RecipeFor id="crafting_terminal" />

<a name="pattern-encoding-terminal-ui"></a>

# Терминал для закодированных шаблонов

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/pattern_encoding_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Терминал для закодированных шаблонов похож на обычный терминал, с теми же настройками и разделами, но с добавленным
интерфейсом кодирования [шаблонов](patterns.md). Он похож на интерфейс терминала изготовления, но эта сетка крафта на самом деле не
выполняет крафт.

У вас должно быть одно из них в дополнение к терминалу изготовления для предметов.

## Пользовательский интерфейс

Терминал изгтовления имеет тот же интерфейс, что и обычный терминал, добавлен интерфейс кодирования [шаблонов](patterns.md).

Интерфейс кодирования шаблонов состоит из нескольких разделов:

Слот для вставки <ItemLink id="blank_pattern" />.

Большая стрелка для кодирования шаблона.

Слот для закодированных шаблонов. Поместите в этот слот уже закодированный шаблон, чтобы отредактировать его, затем нажмите стрелку «кодировать».

4 вкладки справа для переключения типа кодируемого шаблона между

*   Изготовление
*   Обработка
*   Кузнечное дела
*   Камнерезание

Центральный пользовательский интерфейс меняется в зависимости от типа кодируемого шаблона:

*   В режиме изготовления:
    *   Щелкните левой кнопкой мыши или перетащите из JEI/REI ингредиенты, чтобы сформировать рецепт. Щелкните правой кнопкой мыши, чтобы удалить ингредиент.
    *   Включение подстановки позволяет, например, изготавливать палки из любого типа досок. Эту функцию следует использовать только
        в случае крайней необходимости.
    *   Замена жидкостей позволяет использовать запасенные жидкости вместо ведер с жидкостями.
    *   Вы также можете напрямую закодировать шаблон на экране рецептов JEI/REI.

*   В режиме обработки:
    * Щелкните левой или правой кнопкой мыши в JEI/REI или перетащите ингредиенты, чтобы указать входные и выходные данные рецепта.
    * Щелкните правой кнопкой мыши по емкости с жидкостью (например, ведру или резервуару), чтобы установить эту жидкость в качестве ингредиента вместо ведра или резервуара.
    * При удержании стопки левой кнопкой мыши размещается вся стопка, правой кнопкой мыши — один предмет. Щелкните левой кнопкой мыши по существующей стопке ингредиентов, чтобы
        удалите весь стак и щелкните правой кнопкой мыши, чтобы уменьшить стак на 1. Все, что вы привязали к «выбору блока» (обычно средняя кнопка мыши)
        позволяет указать точное количество предмета или жидкости.
    * Слоты вывода имеют первичный вывод и место для любых вторичных выводов, о которых вы хотите сообщить алгоритму автокрафта.
    * Слоты ввода и вывода прокручиваются, поэтому вы можете иметь 81 различных ингредиента и 26 вторичных выходов.
    * Вы также можете напрямую закодировать шаблон на экране рецептов JEI/REI.

*   Интерфейсы режимов кузнечного дела и камнерезания работают аналогично кузнечному столу и камнерезу соответственно.

## Рецепт

<RecipeFor id="pattern_encoding_terminal" />

<a name="pattern-access-terminal-ui"></a>

# Терминал доступа к шаблонам

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/blocks/pattern_access_terminal.snbt" />
  <IsometricCamera yaw="180" />
</GameScene>

Терминал доступа к шаблонам служит для решения конкретной проблемы: в плотной башне из <ItemLink id="pattern_provider" />
и <ItemLink id="molecular_assembler" /> вы не можете физически получить доступ к поставщикам, чтобы вставить новые шаблоны. Кроме того,
возможно, вы ленивы и не хотите пересекать всю базу, чтобы вставить [шаблон](patterns.md). Терминал доступа к шаблонам
позволяет получить доступ ко всем поставщикам шаблонов в сети.

## Пользовательский интерфейс

Этот терминал имеет интерфейс, отличный от всех других терминалов.

В нем есть настройки высоты терминала и отображаемых поставщиков шаблонов.

Каждая строка в терминале соответствует определенному поставщику шаблонов.

Поставщики шаблонов в терминале сортируются по тому, к каким блокам они подключены, или по тому, какое имя вы им дали (в наковальне или
с помощью <ItemLink id="name_press" />).

## Рецепт

<RecipeFor id="pattern_access_terminal" />
