---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: МЭ шина хранения
  icon: storage_bus
  position: 220
categories:
- devices
item_ids:
- ae2:storage_bus
---

# Шина хранения

<GameScene zoom="8" background="transparent">
<ImportStructure src="../assets/blocks/storage_bus.snbt" />
</GameScene>

Когда либо хотели "сохранить" вашего сундучного монстра, вместо замены его с чем-то более путным? Представляем вам шину хранения!

Шина хранения превращает инвентарь, к которому она прилигает в [сетевое хранилище](../ae2-mechanics/import-export-storage.md). Для этого он позволяет сети видеть содержимое этого инвентаря и также отправлять и извлекать из этого инвентаря, чтобы удовлетворить потребности [устройств](../ae2-mechanics/devices.md), отправляющие и извлекающие предметы из сетевого хранилища.

В связи с философией AE2, заключающейся в появлении новых механик в результате взаимодействия функций [устройств](../ae2-mechanics/devices.md), вам не обязательно использовать шину хранения для *хранения*. Используя [подсети](../ae2-mechanics/subnetworks.md), чтобы сделать шину хранения (или нескольких шин хранения) *единственным* хранилищем в сети, вы можете использовать их как источник или места назначения для передачи предметов (см. ["кабельная подсеть"](../example-setups/pipe-subnet.md))

Является [подразделом кабеля](../ae2-mechanics/cable-subparts.md).

## Фильтрация

По умолчанию шина будет хранить всё. Предметы вставленные в слоты фильра будут действовать как белый список, позволяя только выбранным предметам храниться.

Предметы и жидкости могут быть перетащены в слоты фильтра из JEI/REI, даже если у вас на самом деле нет этого предмета.

ПКМ с контейнером с жидкостью (ведро или жидкостный бак), чтобы выбрать эту жидкость в фильтре, вместо ведра или бака.

## Приоритет

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу графического интерфейса. Предметы, попадающие в сеть, в качестве первого адресата начнут использовать хранилище с наивысшим приоритетом. В случае если два хранилища или ячейки имеют одинаковый приоритет, если одно из них уже содержит предмет, он предпочтет это хранилище любому другому. Любые отфильтрованные ячейки будут рассматриваться как уже содержащие предмет, если они находятся в той же группе приоритетов, что и другие хранилища. Предметы, извлекаемые из хранилища, будут извлекаться из хранилища с наименьшим приоритетом. Такая система приоритетов означает, что по мере вставки и извлечения предметов из сетевого хранилища, хранилища с более высоким приоритетом будут заполняться, а хранилища с более низким приоритетом - опустошаться.

## Настройки

*   Шина может быть разбита на разделы (фильтрована) на предметы, которые находятся в прилегающем инвентаре
*   Сети может быть разрешено или запрещено видеть предметы в прилегающем инвентаре, из которого шина не может извлекать (к примеру, шина хранения не может извлекать предметы из центрального вводного слота из <ItemLink id="inscriber" />)
*   Шина может фильтровать, как на вставке и извлечении, так и на просто вставке
*   Шина может быть двухнаправленной, только на вставку или только на извлечение

## Улучшения

Шина хранения поддерживает следующие [улучшения](upgrade_cards.md):

*   <ItemLink id="capacity_card" /> увеличивает количество слотов фильтра
*   <ItemLink id="fuzzy_card" /> позволяет шине фильтровать по уровню повреждения и/или игнорировать NBT предмета
*   <ItemLink id="inverter_card" /> переключает фильтр с белого списка на чёрный
*   <ItemLink id="void_card" /> аннигилирует вставленные предметы , если прилегающий инвентарь полон, полезно для предотвращения переполнения ферм. Будьте осторожны при использовании!

## Рецепт

<RecipeFor id="storage_bus" />
