---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Поставщик шаблонов
  icon: pattern_provider
  position: 210
categories:
- devices
item_ids:
- ae2:pattern_provider
- ae2:cable_pattern_provider
---

# Поставщик шаблонов

<Row gap="20">
<BlockImage id="pattern_provider" scale="8" />
<BlockImage id="pattern_provider" p:push_direction="up" scale="8" />
<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/cable_pattern_provider.snbt" />
</GameScene>
</Row>

Поставщики шаблонов являются основным способом взаимодействия вашей системы [автоматического крафта](../ae2-mechanics/autocrafting.md) с миром. Они перемещают ингредиенты из
своих [шаблонов](patterns.md) в соседние инвентари, и предметы могут быть вставлены в них, чтобы ввести их в сеть. Часто
канал можно сохранить, направляя вывод машины обратно в ближайший поставщик шаблонов (часто тот, который переместил ингредиенты)
вместо использования <ItemLink id="import_bus" /> для перемещения вывода машины в сеть.

Следует отметить, что, поскольку они выталкивают ингредиенты непосредственно из [хранилища для крафта](crafting_cpu_multiblock.md#crafting-storage) в процессоре изготовления, они
на самом деле никогда не содержат ингредиенты в своем инвентаре, поэтому вы не можете выводить их из них. Вы должны заставить поставщика выталкивать
их в другой инвентарь (например, в бочку), а затем выводить из него.

Также следует отметить, что поставщик должен отправлять ВСЕ ингредиенты сразу, он не может отправлять половину партии. Это полезно
использовать.

Поставщики шаблонов имеют особое взаимодействие с интерфейсами в [подсетях](../ae2-mechanics/subnetworks.md): если интерфейс не изменен (нет ничего в слотах запроса),
 поставщик полностью пропустит интерфейс и отправит данные непосредственно в [хранилище](../ae2-mechanics/import-export-storage.md) этой подсети,
пропустив интерфейс и не заполняя его партиями рецептов, и, что более важно, не вставляя следующую партию, пока в машине не появится место.
Это работает правильно в блокирующем режиме, поставщик будет контролировать слоты в машине на наличие ингредиентов, а не слоты в интерфейсе.

Например, эта установка будет проталкивать как вещи, которые необходимо пережарить, так и топливо непосредственно в соответствующие слоты печи.
Вы можете использовать это для подачи шаблонов на несколько сторон машины или на несколько машин.

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/furnace_automation.snbt" />

<BoxAnnotation color="#dddddd" min="1 0 0" max="2 1 1">
        (1) Поставщик шаблонов: направленный вариант, с использованием ключа из истинного кварца, с соответствующими шаблонами обработки.

        ![Шаблон железа](../assets/diagrams/furnace_pattern_small.png)
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 1 0" max="2 1.3 1">
        (2) Интерфейс: установлены настройки по умолчанию.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 1 0" max="1.3 2 1">
        (3) Шина хранения №1: отфильтровано на угль.
        <ItemImage id="minecraft:coal" scale="2" />
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 2 0" max="1 2.3 1">
        (4) Шина хранения №2: отфильтрован для внесения угля в черный список с помощью карты инвертирования.
        <Row><ItemImage id="minecraft:coal" scale="2" /><ItemImage id="inverter_card" scale="2" /></Row>
  </BoxAnnotation>

<DiamondAnnotation pos="4 0.5 0.5" color="#00ff00">
        В основную сеть
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Это общая иллюстрация поставки к нескольким машинам.

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/provider_interface_storage.snbt" />

<BoxAnnotation color="#dddddd" min="2.7 0 1" max="3 1 2">
        Интерфейс (должен быть плоским, не полноблочным)
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 4">
        Шины хранения
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 0 0" max="1 1 4">
        Места, которым вы хотите предоставить шаблоны
  </BoxAnnotation>

<IsometricCamera yaw="185" pitch="30" />
</GameScene>

Поддерживаются несколько поставщиков шаблонов с идентичными шаблонами, которые работают параллельно.

Поставщики шаблонов будут пытаться распределять свои партии по всем своим интерфейсам, используя таким образом все подключенные машины параллельно.

## Варианты

Поставщики шаблонов бывают трех различных типов: обычные, направленные и плоские/[подразделельные](../ae2-mechanics/cable-subparts.md). Это влияет на то, в какую сторону они продвигают
ингредиенты, из какой стороны получают предметы и к какой сети подключаются.

*   Обычные поставщики шаблонов передают ингредиенты во все стороны, получают входные данные со всех сторон и, как и большинство машин AE2, действуют
    как кабель, обеспечивающий сетевое соединение со всеми сторонами.

*   Направленные поставщики шаблонов создаются с помощью использования <ItemLink id="certus_quartz_wrench" /> на обычном поставщике шаблонов для изменения его
направления. Они только передают ингредиенты на выбранную сторону, принимают входные данные со всех сторон и специально не предоставляют сетевое
соединение на выбранной стороне. Это позволяет им передавать данные на машины AE2 без подключения к сетям, если вы хотите создать подсеть.

*   Плоские поставщики шаблонов являются [подразделом кабеля](../ae2-mechanics/cable-subparts.md), поэтому на одном кабеле можно разместить несколько таких поставщиков, что позволяет создавать компактные установки.
    Они действуют аналогично выбранной стороне направленного поставщика шаблонов, поставляя шаблоны, принимая вводные данные и **не**
    предоставляя сетевое соединение на своей поверхности.

Поставщики шаблонов могут переключаться между нормальным и плоским режимом в сетке крафта.

## Настройки

У поставщиков шаблонов есть различные режимы работы:

*   **Режим блокирования** не позволяет поставщику отправлять новую партию ингредиентов, если в машине уже есть
    ингредиенты.
*   **Заблокировать создание** может заблокировать поставщик при различных условиях редстоуна или до тех пор, пока результат
предыдущего крафта не будет вставлен в этот конкретный поставщик шаблонов.
*   Поставщик может быть отображён или скрыт на <ItemLink id="pattern_access_terminal" />.

## Приоритет

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу графического интерфейса. В случае наличия нескольких [шаблонов](patterns.md)
для одного и того же предмета, шаблоны в поставщиках  с более высоким приоритетом будут использоваться вместо шаблонов в провайдерах с более низким приоритетом,
только если в сети нет ингредиентов для шаблона с более высоким приоритетом.

## Распространенное заблуждение

По какой-то причине люди продолжают так поступать, я не понимаю почему, но я помещаю это здесь в надежде помочь. (Возможно,
люди ошибаются, думая, что <ItemLink id="export_bus" /> — это единственный способ вывода из сети, не зная,
что поставщики шаблонов также экспортируют предметы)

Это не даст желаемого результата. Как упоминалось в разделе [кабелей](cables.md), кабели не являются конвейерами предметов, у них нет внутреннего
инвентаря, поставщики не будут отправлять в них предметы.

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/assemblies/provider_misconception_1.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 3" max="2 1 4">
        Не плавильная печь
  </BoxAnnotation>

  <IsometricCamera yaw="95" pitch="5" />
</GameScene>

Поскольку у поставщика шаблонов нет ничего, что можно было бы передать, он
не сможет функционировать. Все, что он здесь делает, — это действует как кабель, соединяя <ItemLink id="export_bus" /> с
сетью.

Поставщик шаблонов также не будет каким-либо образом указывать <ItemLink id="export_bus" />, что экспортировать, экспортная шина просто экспортирует
все, что вы поместите в ее фильтр.

По сути, мы сделали следующее:

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/assemblies/provider_misconception_2.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 3" max="2 1 4">
        Не плавильная печь
  </BoxAnnotation>

  <IsometricCamera yaw="95" pitch="5" />
</GameScene>

Вероятно, на самом деле вам нужно сделать следующее: чтобы поставщик шаблонов мог экспортировать содержимое своих шаблонов на
соседнюю машину:

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/assemblies/provider_misconception_3.snbt" />

  <BoxAnnotation color="#dddddd" min="1 0 3" max="2 1 4">
        Не плавильная печь
  </BoxAnnotation>

  <IsometricCamera yaw="95" pitch="5" />
</GameScene>

## Рецепты

<RecipeFor id="pattern_provider" />

<RecipeFor id="cable_pattern_provider" />
