---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Интерфейс
  icon: interface
  position: 210
categories:
- devices
item_ids:
- ae2:interface
- ae2:cable_interface
---

# Интерфейс

<Row gap="20">
<BlockImage id="interface" scale="8" />
<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/cable_interface.snbt" />
</GameScene>
</Row>

Интерфейсы действуют как небольшой сундук и резервуар для жидкости, который наполняется и опустошается из [сетевого хранилища](../ae2-mechanics/import-export-storage.md)
в зависимости от того, что вы настроили для хранения в его слотах. Он пытается выполнить это за один игровой тик, поэтому может наполняться
или опустошаться до 9 стаков за игровой тик, что делает его быстрым методом импорта или экспорта, если у вас есть быстрые трубы для предметов.

Еще одна полезная особенность заключается в том, что в то время как большинство резервуаров для жидкостей могут хранить только 1 тип жидкости, интерфейсы могут хранить до 9, также как и предметы.
По сути, они представляют собой просто сундуки/резервуары для нескольких типов жидкостей с некоторыми дополнительными функциями, и вы можете предотвратить эти дополнительные функции, не подключая
их к каким-либо сетям.
Таким образом, они полезны в некоторых нишевых случаях, когда нужно хранить небольшое количество разных вещей.

## Как работает интерфейс изнутри

Как уже упоминалось ранее, интерфейс — это, по сути, сундук/резервуар с несколькими супер-пупер <ItemLink id="import_bus" /> и
<ItemLink id="export_bus" />, к которым прикреплены несколько <ItemLink id="level_emitter" />.

<GameScene zoom="3" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_internals.snbt" />

  <BoxAnnotation color="#dddddd" min="1.3 0.3 1.3" max="9.7 1 1.7">
        Набор излучателей уровня, которые используются для контроля запрашиваемого количества запасов 
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/level_emitter.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 4 1.3" max="9.7 4.7 1.7">
        Набор излучателей уровня, которые используются для контроля запрашиваемого количества запасов 
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/level_emitter.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 1.3 1.3" max="9.7 2 1.7">
        Куча супер-пупер шин импорта, которые могут переносить 1 стак за каждый игровой тик
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/import_bus.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1.3 3 1.3" max="9.7 3.7 1.7">
        Куча супер-пупер шин экспорта, которые могут переносить 1 стак за каждый игровой тик
        <GameScene zoom="4" background="transparent">
        <ImportStructure src="../assets/blocks/export_bus.snbt" />
        </GameScene>
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 1" max="10 3 2">
        9 отдельных внутренних слотов
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="15" />
</GameScene>

## Особые взаимодействия

Интерфейсы также имеют несколько специальных функций с другими AE2 [устройствами](../ae2-mechanics/devices.md):

<ItemLink id="storage_bus" /> на не настроеном интерфейсе будет представлять всё [сетевое хранилище](../ae2-mechanics/import-export-storage.md)
своей сети для сети шины хранения, как если бы сеть интерфейса была одним большим сундуком, на котором размещена шина хранения.
Установка предмета для хранения в слотах фильтра интерфейса отключает эту функцию. 

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_storage.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

У поставщиков шаблонов есть особое взаимодействие с интерфейсами в [подсетях](../ae2-mechanics/subnetworks.md): если интерфейс не настроен,
 поставщик полностью пропустит интерфейс и отправит данные непосредственно в [хранилище](../ae2-mechanics/import-export-storage.md) этой подсети,
пропуская интерфейс и не заполняя его партиями рецептов, и, что более важно, не вставляя следующую партию, пока в хранилище не появится место.

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/provider_interface_storage.snbt" />

<BoxAnnotation color="#dddddd" min="2.7 0 1" max="3 1 2">
        Интерфейс (должен быть плоским, не полноблочным)
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 4">
        Шины хранения
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 0 0" max="1 1 4">
        Места, куда вы хотите подавать ресурсы по шаблону (несколько машин или несколько сторон одной машины)
  </BoxAnnotation>

<IsometricCamera yaw="185" pitch="30" />
</GameScene>

## Вариации

Интерфейсы бывают двух типов: обычные и плоские/[подраздельные](../ae2-mechanics/cable-subparts.md). Это влияет на то, с каких сторон можно получить доступ к их инвентарю
и к каким сетевым подключениям они предоставляют доступ.

*   Обычные интерфейсы позволяют передавать, извлекать и получать доступ к инвентарю со всех сторон и, как и большинство машин AE2, действуют
    как кабель, обеспечивающий сетевое соединение со всех сторон.

*   Плоские интерфейсы представляют собой [подраздел кабеля](../ae2-mechanics/cable-subparts.md), поэтому на одном кабеле можно разместить несколько таких интерфейсов, что позволяет создавать компактные установки.
    Они позволяют закидывать, извлекать и получать доступ к инвентарю с их лицевой стороны, но не обеспечивают сетевое соединение на лицевой стороне.

Интерфейсы можно переключать между обычным и плоским режимом в сетке крафта.

## Настройки

Верхние слоты в интерфейсе определяют, что интерфейс будет хранить внутри себя. Когда что-то помещается в
них или перетаскивается из JEI/REI, появляется гаечный ключ, который позволяет установить количество.

Щелкните правой кнопкой мыши с контейнером с жидкостью (например, ведру или резервуару), чтобы установить эту жидкость в качестве фильтра вместо ведра или резервуара.

## Улучшения

Интерфейс поддерживает следующие [улучшения](upgrade_cards.md):

*   <ItemLink id="fuzzy_card" /> позволяет шине фильтровать по уровню повреждения и/или игнорировать NBT предмета
*   <ItemLink id="crafting_card" /> позволяет интерфейсу отправлять запросы на изготовление в вашу систему [автокрафта](../ae2-mechanics/autocrafting.md)
    для получения необходимых предметов. По возможности, она извлечет предметы из хранилища, прежде чем отправлять запрос
    на изготовление нового предмета.

## Приоритет

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу графического интерфейса. Интерфейсы с более высоким приоритетом будут получать свои предметы
раньше, чем интерфейсы с более низким приоритетом.

## Рецепты

<Recipe id="network/blocks/interfaces_interface" />

<RecipeFor id="cable_interface" />
