---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Вырезатель
  icon: inscriber
  position: 310
categories:
- machines
item_ids:
- ae2:inscriber
---

# Вырезатель

<BlockImage id="inscriber" scale="8" />

Вырезатель используется для начертания схем и [процессоров](processors.md) с помощью [печатей](presses.md), а также для измельчения различных предметов в пыль.
Он может работать как от энергии AE2 (AE), так и от энергии Fabric/Forge (E/FE). Он может быть двусторонним, так что вставка предметов с разных сторон
вставляет их в разные слоты в его инвентаре. Для облегчения этого его можно поворачивать с помощью <ItemLink id="certus_quartz_wrench" />.
Его также можно настроить так, чтобы он перемещал результаты крафта в соседние инвентари.

Размер входного буфера можно настроить. Например, если вы хотите подавать материалы из одного инвентаря в большой массив вырезателей,
вам нужен небольшой буфер, чтобы материалы распределялись между вырезателями более оптимально (а не так, что первый
вырезатель заполняется до 64, а остальные остаются пустыми).

Всего 4 типа печатей используются для изготовления [процессоров](processors.md)

<Row>
  <ItemImage id="silicon_press" scale="4" />

  <ItemImage id="logic_processor_press" scale="4" />

  <ItemImage id="calculation_processor_press" scale="4" />

  <ItemImage id="engineering_processor_press" scale="4" />
</Row>

Именующую печать можно использовать для маркировки вещей в <ItemLink id="pattern_access_terminal" />.

<ItemImage id="name_press" scale="4" />

## Настройки

* Вырезатель может быть настроен на односторонний режим (как описано ниже) или на ввод в любой слот с любой стороны, при этом внутренний фильтр решает,
    что куда пойдет. В одностороннем режиме предметы не могут извлекаться из верхнего и нижнего слотов.
* Вырезатель может быть настроен на перемещение предметов в соседние инвентари.
* Размер входного буфера можно настроить: больший вариант предназначен для автономного вырезателя, который загружается вручную, а
малый вариант — для больших параллельных установок для улучшения их эффективности.

## GUI и односторонность

В одностороннем режиме вырезатель фильтрует, что куда попадает, в зависимости от того, с какой стороны вы вставляете или извлекаете.

![GUI Вырезателя](../assets/diagrams/inscriber_gui.png) ![Стороны Вырезателя](../assets/diagrams/inscriber_sides.png)

A. **Верхний ввод**, доступный через верхнюю часть вырезателя (предметы можно как вставлять в этот слот, так и извлекать из него)

B. **Центральный ввод** вставлен в левую, правую, переднюю и заднюю стороны вырезателя (предметы можно только вставлять в этот слот, но не извлекать из него)

C. **Нижний ввод**, доступный через нижнюю часть вырезателя (предметы можно как вставлять в этот слот, так и извлекать из него)

D. **Вывод** с левой, правой, передней и задней сторон вырезателя (предметы можно только вытаскивать из этого слота, но не вставлять в него)

## Простая автоматизация

Например, благодаря односторонности и возможности поворота можно частично автоматизировать вырезатели следующим образом:

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/inscriber_hopper_automation.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Или просто подключите кабель к вырезателю в режиме без определённых сторон.

## Улучшения

Вырезатель поддерживает следующие [улучшения](upgrade_cards.md):

*   <ItemLink id="speed_card" />

## Рецепт

<RecipeFor id="inscriber" />
