---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: МЭ сундук
  icon: chest
  position: 210
categories:
- devices
item_ids:
- ae2:chest
---

# МЭ сундук

<GameScene zoom="8" background="transparent">
<ImportStructure src="../assets/blocks/chest.snbt" />
</GameScene>

МЭ сундук работает как миниатюрная сеть с <ItemLink id="terminal" />, <ItemLink id="drive" /> и <ItemLink id="energy_acceptor" />.
В то время, как он может быть использован как крошечное сетевое хранилище, его внутренне хранилище может содержать лишь одну единственную [ячейку хранения](../items-blocks-machines/storage_cells.md) за раз, это обозначает, что он имеет крайне лимитированное использование.

Вместо этого, он полезен для взаимодействия со специфическими ячейками хранения, установленные в него. В МЭ сундук встроен терминал, который только позволяет видеть и взаимодействовать с предметами в вставленной ячейке хранения, пока у [устройств](../ae2-mechanics/devices.md) в главной сети есть доступ к предметам в любом [сетевом хранилище](../ae2-mechanics/import-export-storage.md),
включая МЭ сундуки.

У него есть 2 различных графических интерфейса и у него опр. стороны выполняют опр. функции. Взаимодействие с верхним терминалом открывает встроенный терминал. Предметы могут быть перемещены внутрь вставленной ячейки хранения через верхний терминал, однако они не могут быть извлечены от туда. Взаимодействие с любыми иными сторонами открывает графический интерфейс для взаимодействия с содержимым ячейки хранения и настройки приоритета. Ячейка может быть вставлена или извлечена с помощью блоков для логистики предметов только через сторону с слотом для ячейки.

Может быть повёрнут с помощью <ItemLink id="certus_quartz_wrench" />.

У МЭ сундука маленький буфферное хранилище энергии, поэтому если у сети нет энергохранилища, то вставка или извлечение большого объёма предметов за раз может привести к кратковременному отключению электричества.

Терминал в верхней часте сундука может быть покрашен с помощью <ItemLink id="color_applicator" />.

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/chest_color.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Настройки

У МЭ сундука всё те же настройки, что и у  <ItemLink id="terminal" /> или <ItemLink id="crafting_terminal" />.
Однако оно не поддерживает <ItemLink id="view_cell" />.

## Светодиодные индикаторы состояния ячеек

Ячейки на сундуке оснащены светодиодными индикаторами, которые показывают их состояние:

| Цвет      | Статус                                                                           |
| :-----    | :------------------------------------------------------------------------------- |
| Зелёный   | Пусто                                                                            |
| Синий     | Имеет некоторое содержание                                                                |
| Оранжевый | [Типы](../ae2-mechanics/bytes-and-types.md) переполнены, новые типы не могут быть добавлены     |
| Красный   | [Байты](../ae2-mechanics/bytes-and-types.md) переполнены, больше предметы не могут быть вставлены |
| Чёрный    | Нет питания или сундук не имеет [канала](../ae2-mechanics/channels.md)                 |

## Приоритет

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу графического интерфейса слота для ячеек. Предметы, попадающие в сеть, в качестве первого адресата начнут использовать хранилище с наивысшим приоритетом. В случае если два хранилища или ячейки имеют одинаковый приоритет, если одно из них уже содержит предмет, он предпочтет это хранилище любому другому. Любые [разбитые на разделы](cell_workbench.md) ячейки будут рассматриваться как уже содержащие предмет, если они находятся в той же группе приоритетов, что и другие хранилища. Предметы, удаляемые из хранилища, будут удаляться из хранилища с наименьшим приоритетом. Такая система приоритетов означает, что по мере вставки и удаления элементов из сетевого хранилища хранилища с более высоким приоритетом будут заполняться, а хранилища с более низким приоритетом - опустошаться.

## Рецепт

<RecipeFor id="chest" />
