---
navigation:
  parent: example-setups/example-setups-index.md
  title: Извлечение и заполнение содержимого ячейки
  icon: io_port
---

# Извлечение и заполнение содержимого ячейки

Можно задать вопрос: "Как быстро опустошить ячейку в сундуке, ящике или рюкзаке или, наоборот, наполнить ячейку из них?"

Ответ заключается в использовании <ItemLink id="io_port" /> и некоторого подсетевого разделения для ограничения мест, куда можно помещать предметы или из которых можно извлекать предметы.

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/cell_dumper_filler.snbt" />

<BoxAnnotation color="#dddddd" min="1 1 0" max="2 2 1">
        (1) Порт ввода/вывода: Может быть настроен на "Передачу данных в сеть" или "Передачу данных в ячейку хранения" с помощью кнопки со стрелкой
        в центре графического интерфейса. Имеет 3 карты ускорения.
        <ItemImage id="speed_card" scale="2" />
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 0.7 0" max="1 1 1">
        (2) Шина хранения: настройка по умолчанию.
  </BoxAnnotation>

<BoxAnnotation color="#33dd33" min="0 1 0" max="1 2 1">
        Поместите сюда все, что хотите заполнить или опустошить.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="2 0.35 0.35" max="2.3 0.65 0.65">
        Кварцевое волокно: Требуется только в том случае, если источником энергии является другая сеть.
  </BoxAnnotation>

<DiamondAnnotation pos="3 0.5 0.5" color="#00ff00">
        К какому-либо источнику энергии, например, к другой сети или к приемнику энергии.
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Настройки

* <ItemLink id="io_port" /> (1) можно установить на "Передачу данных в сеть" или «Передачу данных в ячейку хранения» с помощью кнопки со стрелкой
  в середине графического интерфейса. Он имеет 3 карты ускорения  для максимальной скорости.
* <ItemLink id="storage_bus" /> (2) находится в настройке по умолчанию.

## Как это работает

### В режиме "Передача в сеть"

1. <ItemLink id="io_port" /> пытается выгрузить содержимое вставленной [ячейки хранения](../items-blocks-machines/storage_cells.md).
    в [сетевое хранилище](../ae2-mechanics/import-export-storage.md).
2. Единственным хранилищем в подсети является <ItemLink id="storage_bus" />, в котором хранятся предметы, жидкости и т. д., в зависимости от того, что
    вы помещаете перед ним.
* <ItemLink id="energy_cell" /> обеспечивает достаточно большой запас [энергии](../ae2-mechanics/energy.md), чтобы сеть
    не исчерпала свой запас энергии при передаче такого количества предметов за один игровой тик.

### В режиме "Перенос в ячейку хранения"

1. <ItemLink id="io_port" /> пытается выгрузить содержимое [сетевого хранилища](../ae2-mechanics/import-export-storage.md)
   в вставленную [ячейку хранения](../items-blocks-machines/storage_cells.md).
2. Единственное хранилище в подсети — это <ItemLink id="storage_bus" />, которое извлекает предметы, жидкости и т. д. из того, что
   вы помещаете перед ним.
* <ItemLink id="energy_cell" /> обеспечивает достаточно большой запас [энергии](../ae2-mechanics/energy.md), чтобы сеть
  не исчерпала свой запас энергии при передаче такого количества предметов за каждый игровой тик.