---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Подсети
---

# Подсети

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/subnet_demonstration.snbt" />

<DiamondAnnotation pos="6.5 2.5 0.5" color="#00ff00">
        Подсеть предметного трубопровода
    </DiamondAnnotation>

<DiamondAnnotation pos="5.5 2.5 0.5" color="#00ff00">
        Подсеть жидкостного трубопровода
    </DiamondAnnotation>

<DiamondAnnotation pos="4.5 2.5 0.5" color="#00ff00">
        Плоскость уничтожения с фильтром
    </DiamondAnnotation>

<DiamondAnnotation pos="3.5 2.5 0.5" color="#00ff00">
        Подсеть плоскости формирования
    </DiamondAnnotation>

<DiamondAnnotation pos="2.5 2.5 0.5" color="#00ff00">
        Подсеть, использующая взаимодействие Интерфейс-Шина хранения для работы в качестве локального подхранилища, к которому может обращаться основная сеть
    </DiamondAnnotation>

<DiamondAnnotation pos="1.5 1.5 0.5" color="#00ff00">
        Еще одна подсеть предметного трубопровода, чтобы вернуть заряженные предметы поставщику шаблонов
    </DiamondAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Понятие "подсеть" довольно расплывчато, но можно сказать, что подсеть - это любая сеть, которая поддерживает вашу основную сеть или выполняет какую-то небольшую задачу. Обычно они достаточно малы, чтобы не требовать контроллеров. Их основные два применения:

*   Чтобы ограничить доступ [устройств](../ae2-mechanics/devices.md) к каким хранилищам (вы не хотите, чтобы шина импорта в подсети "трубопровода" имела доступ к хранилищу основной сети, иначе она будет помещать предметы в ваши ячейки хранилища, а не в инвентарь назначения).
*   Чтобы сэкономить каналы в основной сети, например, если провайдер шаблонов выводится на интерфейс, подключенный к нескольким шинам хранения на нескольких машинах, используйте 1 канал, вместо того чтобы размещать провайдер шаблонов на каждой машине, используя несколько каналов.

Кабели разных цветов не имеют никакого отношения к созданию подсети, кроме того, что они не будут соединяться друг с другом.

Они могут быть

*   шиной импорта и шиной хранения, установленными для передачи предметов или жидкостей из одного контейнера в другой, как труба для предметов или жидкостей.
*   плоскостью аннигиляции и шиной хранения, так что единственное место, куда плоскость аннигиляции может поместить то, что она разрушает, - это шина хранения, позволяющая фильтровать плоскость
*   интерфейсом и плоскостью формирования, так что все, что вставляется в интерфейс, переносится на плоскость формирования и ставится/выбрасывается в мир
*   установкой для автоматического изготовления кварца certus, регулируемой и контролируемой <ItemLink id="level_emitter" /> в основной сети.
*   специализированными системами хранения, доступными из основной сети через специальное взаимодействие шина хранения-интерфейс, для хранения продукции ферм без бесконечного переполнения основного хранилища.
*   и так далее.

Очень полезным блоком для создания подсетей является <ItemLink id="quartz_fiber" />. Оно передает энергию между сетями, не соединяя их, позволяя питать подсети без необходимости размещать повсюду приемники энергии и кабели питания.
