---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Импорт, Экспорт и Хранение
---

# Импорт, Экспорт и Хранение

**ваша МЭ система и мир**

Важной концепцией в AE2 является идея сетевого хранилища. Это место, в котором хранится содержимое сети, обычно [ячейки хранения](../items-blocks-machines/storage_cells.md) или любой инвентарь, к которому подключена <ItemLink id="storage_bus" />. Большинство AE2 [устройств](../ae2-mechanics/devices.md) так или иначе взаимодействуют с ним.

К примеру,

*   <ItemLink id="import_bus" /> загружает вещи в сетевое хранилище
*   <ItemLink id="export_bus" /> забирает вещи из сетевого хранилища
*   <ItemLink id="interface" /> осуществляет как доставку из сетевого хранилища, так и доставку в него.
*   [Терминалы](../items-blocks-machines/terminals.md) как загружают, так и забирают предметы из сетевого хранилища, когда вы вставляете или берете предметы, или пополняете слоты крафта
* 	<ItemLink id="storage_bus" /> на самом деле не загружают в хранилище и не забирают из него, они заружают в подключённый инвентарь и забирают из него, чтобы использовать его в качестве сетевого хранилища (поэтому на самом деле другие устройства загружают *в них* и забирают *из них*).

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/import_export_storage.snbt" />

  <BoxAnnotation color="#dddddd" min="8 1 1" max="9 1.3 2">
		Шина импорта импортируют вещи из инвентаря, на который они указывают, в сетевое хранилище
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="8 2 1" max="9 3 1.3">
        Вставка чего-либо в терминал из вашего инвентаря считается импортом в сеть
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="7 0 1" max="8 1 2">
        Интерфейсы будут импортировать из своих внутренних запасов, если слот не настроен на хранение чего-либо, или в нем больше предметов, чем настроено на хранение, поэтому в него можно загружать вещи для вставки в сеть
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="6 0 1" max="7 1 2">
        Поставщики шаблонов будут импортировать из своего внутреннего инвентаря слотов возврата, так что вещи могут быть загружены в них для вставки в сеть
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="4 1 1" max="5 2 2">
        Дисководы обеспечивают работу вставленных ячеек в качестве сетевого хранилища.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="3 1 1" max="4 1.3 2">
        Шины хранилища используют инвентарь, на который указывают, в качестве сетевого хранилища
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 1 1" max="2 1.3 2">
        Шины экспорта экспортируют вещи из сетевого хранилища в инвентарь, на который они указывают.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 1" max="2 3 1.3">
        Вытаскивание чего-либо из терминала считается экспортом из сети
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="0 1 1" max="1 2 2">
        Интерфейсы будут экспортировать в свои внутренние запасы, если этот слот настроен на хранение чего-либо, так что вещи могут быть извлечены из них для извлечения из сети
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Действия/события, связанные с пересылкой в сетевое хранилище и извлечением из него, важно учитывать при проектировании систем автоматизации и логистики.

## Приоритет хранения

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу некоторых графических интерфейсов. Предметы, попавшие в сеть, будут отправляться в хранилище с наивысшим приоритетом. Если два хранилища имеют одинаковый приоритет, то если одно из них уже содержит предмет, он предпочтет это хранилище любому другому. Любые ячейки из белого списка будут рассматриваться как уже содержащие предмет, если они находятся в той же группе приоритетов, что и другие хранилища. Предметы, забираемые из хранилища, будут забираться из хранилища с наименьшим приоритетом. Эта система приоритетов означает, что по мере загрузки и выгрузки предметов из сетевого хранилища, хранилища с более высоким приоритетом будут заполняться, а хранилища с более низким приоритетом - опустошаться.
