---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Байты и Типы
  icon: creative_item_cell
---

# Байты и Типы

<Row>
    <ItemImage id="item_storage_cell_1k" scale="4" />

    <ItemImage id="item_storage_cell_4k" scale="4" />

    <ItemImage id="item_storage_cell_16k" scale="4" />

    <ItemImage id="item_storage_cell_64k" scale="4" />

    <ItemImage id="item_storage_cell_256k" scale="4" />
  </Row>

[Ячейки хранилища](../items-blocks-machines/storage_cells.md) определяются как *байтами*, так и *типами*. Байты, как и в настоящем компьютере, являются мерой общего количества "вещей" в ячейке хранения. Типы - это мера того, сколько различных *типов* вещей хранится в ячейке. Каждый тип представляет собой уникальный предмет, поэтому 4096 булыжников - это 1 тип, а 16 разных мечей с разными зачарованиями - это 16 типов.

Каждая ячейка памяти может хранить фиксированное количество данных. Каждый тип занимает определенное количество байт (которое зависит от размера ячейки), а каждый элемент занимает один бит памяти, поэтому восемь элементов занимают один байт, а полный стак из 64 элементов занимает 8 байт, независимо от того, как элементы будут сложены вне сети MЭ. Например, 64 одинаковых седла не занимают больше места, чем 64 камня.

Опять же, каждый элемент - это 1 бит, поэтому 8 элементов равны 1 байту. Для ячеек с жидкостью это 8 ведер в байте.

Многие люди жалуются на ограниченное количество типов, которые может содержать ячейка, но это ***необходимое ограничение***. Ячейки хранят свои данные в NBT-метке на самом предмете, что делает их довольно стабильными. Однако это означает, что слишком большое количество данных на ячейке может привести к тому, что игроку будет отправлено слишком много данных, что вызовет эффект, похожий на "Бан книгами" в ванильном minecraft. Кроме того, наличие слишком большого количества различных типов в системе увеличивает нагрузку на сортировку и обработку предметов. Однако это ограничение в конечном итоге оказывается не слишком жестким. Один отсек <ItemLink id="drive" />, заполненный ячейками, имеет 630 типов, что на самом деле довольно много, если вы не храните много уникальных нестакающихся предметов.

По этой причине, типы существуют, чтобы "решительно не позволять" вам сбрасывать сотни случайно поврежденных доспехов и инструментов из фермы мобов прямо в вашу MЭ-систему. Каждый предмет брони с уникальным уроном и зачарованиями должен храниться как отдельная запись, что приводит к раздуванию системы. Рекомендуется отфильтровывать их из потока предметов, прежде чем они попадут в вашу систему.

Стремиться сразу к ячейкам верхнего уровня, как правило, не лучшая идея, так как вы используете больше ресурсов, но не получаете никакого дополнительного типа хранимого. Это означает, что все размеры ячеек полезны даже в поздней игре, поскольку они имеют свои преимущества.

Ниже приведена таблица, в которой сравниваются различные уровни ячеек для хранения данных, их объем и приблизительная стоимость.

## Содержание ячейки для хранения в зависимости от стоимости

| Ячейка                                     |   Байт | Кол-во типов | Байт на тип | Истинный кварц | Редстоун | Золото | Светокаменная пыль |
| ---------------------------------------- | ------: | ----: | -------------: | -----: | -------: | ---: | --------: |
| <ItemLink id="item_storage_cell_1k" />   |   1,024 |    63 |              8 |      4 |        5 |    1 |         0 |
| <ItemLink id="item_storage_cell_4k" />   |   4,096 |    63 |             32 |  14.25 |       20 |    3 |         0 |
| <ItemLink id="item_storage_cell_16k" />  |  16,384 |    63 |            128 |     45 |       61 |    9 |         4 |
| <ItemLink id="item_storage_cell_64k" />  |  65,536 |    63 |            512 | 137.25 |      184 |   27 |        16 |
| <ItemLink id="item_storage_cell_256k" /> | 262,144 |    63 |           2048 |    414 |      553 |   81 |        48 |

## Вместимость хранилища при различном количестве типов

Первоначальная стоимость типов такова, что ячейка с 1 типом может вместить в 2 раза больше, чем ячейка со всеми 63 типами.

| Ячейка                                     | Общая емкость ячейки с 1 используемым типом | Общая емкость ячейки с 63 используемыми типами |
| ---------------------------------------- | ----------------------------------------: | ------------------------------------------: |
| <ItemLink id="item_storage_cell_1k" />   |                                     8,128 |                                       4,160 |
| <ItemLink id="item_storage_cell_4k" />   |                                    32,512 |                                      16,640 |
| <ItemLink id="item_storage_cell_16k" />  |                                   130,048 |                                      66,560 |
| <ItemLink id="item_storage_cell_64k" />  |                                   520,192 |                                     266,240 |
| <ItemLink id="item_storage_cell_256k" /> |                                 2,080,768 |                                   1,064,960 |

![A Cell With 1 Type](../assets/diagrams/1_type_cell.png)

![A Cell With 63 Types](../assets/diagrams/63_type_cell.png)