/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class Parser {
    private Parser() {
    }

    @Nonnull
    public static Matcher matchOrThrow(@Nonnull Pattern pattern, String input) throws RegexException {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher;
        }
        String errorMessage = "Failed to find pattern \"" + pattern.pattern() + "\"";
        if (input.length() <= 1024) {
            errorMessage = errorMessage + " inside of \"" + input + "\"";
        }
        throw new RegexException(errorMessage);
    }

    @Nonnull
    public static String matchGroup1(String pattern, String input) throws RegexException {
        return Parser.matchGroup(pattern, input, 1);
    }

    @Nonnull
    public static String matchGroup1(Pattern pattern, String input) throws RegexException {
        return Parser.matchGroup(pattern, input, 1);
    }

    @Nonnull
    public static String matchGroup(String pattern, String input, int group) throws RegexException {
        return Parser.matchGroup(Pattern.compile(pattern), input, group);
    }

    @Nonnull
    public static String matchGroup(@Nonnull Pattern pattern, String input, int group) throws RegexException {
        return Parser.matchOrThrow(pattern, input).group(group);
    }

    public static String matchGroup1MultiplePatterns(Pattern[] patterns, String input) throws RegexException {
        return Parser.matchMultiplePatterns(patterns, input).group(1);
    }

    public static Matcher matchMultiplePatterns(Pattern[] patterns, String input) throws RegexException {
        RegexException exception = null;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(input);
            if (matcher.find()) {
                return matcher;
            }
            if (exception != null) continue;
            exception = new RegexException("Failed to find pattern \"" + pattern.pattern() + "\"" + (String)(input.length() <= 1000 ? "inside of \"" + input + "\"" : ""));
        }
        throw exception != null ? exception : new RegexException("Empty patterns array passed to matchMultiplePatterns");
    }

    public static boolean isMatch(String pattern, String input) {
        return Parser.isMatch(Pattern.compile(pattern), input);
    }

    public static boolean isMatch(@Nonnull Pattern pattern, String input) {
        return pattern.matcher(input).find();
    }

    @Nonnull
    public static Map<String, String> compatParseMap(@Nonnull String input) {
        return Arrays.stream(input.split("&")).map(arg -> arg.split("=")).filter(splitArg -> ((String[])splitArg).length > 1).collect(Collectors.toMap(splitArg -> splitArg[0], splitArg -> Utils.decodeUrlUtf8(splitArg[1]), (existing, replacement) -> replacement));
    }

    public static class RegexException
    extends ParsingException {
        public RegexException(String message) {
            super(message);
        }
    }
}

