/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.util.Comparator;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;

public class StreamInfoItemsCollector
extends InfoItemsCollector<StreamInfoItem, StreamInfoItemExtractor> {
    public StreamInfoItemsCollector(int serviceId) {
        super(serviceId);
    }

    public StreamInfoItemsCollector(int serviceId, Comparator<StreamInfoItem> comparator) {
        super(serviceId, comparator);
    }

    @Override
    public StreamInfoItem extract(StreamInfoItemExtractor extractor) throws ParsingException {
        if (extractor.isAd()) {
            throw new FoundAdException("Found ad");
        }
        StreamInfoItem resultItem = new StreamInfoItem(this.getServiceId(), extractor.getUrl(), extractor.getName(), extractor.getStreamType());
        try {
            resultItem.setDuration(extractor.getDuration());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setUploaderName(extractor.getUploaderName());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setTextualUploadDate(extractor.getTextualUploadDate());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setUploadDate(extractor.getUploadDate());
        }
        catch (ParsingException e) {
            this.addError(e);
        }
        try {
            resultItem.setViewCount(extractor.getViewCount());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setThumbnails(extractor.getThumbnails());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setUploaderUrl(extractor.getUploaderUrl());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setUploaderAvatars(extractor.getUploaderAvatars());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setUploaderVerified(extractor.isUploaderVerified());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setShortDescription(extractor.getShortDescription());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setShortFormContent(extractor.isShortFormContent());
        }
        catch (Exception e) {
            this.addError(e);
        }
        try {
            resultItem.setContentAvailability(extractor.getContentAvailability());
        }
        catch (Exception e) {
            this.addError(e);
        }
        return resultItem;
    }

    @Override
    public void commit(StreamInfoItemExtractor extractor) {
        try {
            this.addItem(this.extract(extractor));
        }
        catch (FoundAdException foundAdException) {
        }
        catch (Exception e) {
            this.addError(e);
        }
    }
}

