/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Extractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.ContentAvailability;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Frameset;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamSegment;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.SubtitlesStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public abstract class StreamExtractor
extends Extractor {
    public static final int NO_AGE_LIMIT = 0;
    public static final long UNKNOWN_SUBSCRIBER_COUNT = -1L;

    public StreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        return null;
    }

    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return null;
    }

    @Nonnull
    public abstract List<Image> getThumbnails() throws ParsingException;

    @Nonnull
    public Description getDescription() throws ParsingException {
        return Description.EMPTY_DESCRIPTION;
    }

    public int getAgeLimit() throws ParsingException {
        return 0;
    }

    public long getLength() throws ParsingException {
        return 0L;
    }

    public long getTimeStamp() throws ParsingException {
        return 0L;
    }

    public long getViewCount() throws ParsingException {
        return -1L;
    }

    public long getLikeCount() throws ParsingException {
        return -1L;
    }

    public long getDislikeCount() throws ParsingException {
        return -1L;
    }

    @Nonnull
    public abstract String getUploaderUrl() throws ParsingException;

    @Nonnull
    public abstract String getUploaderName() throws ParsingException;

    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    public long getUploaderSubscriberCount() throws ParsingException {
        return -1L;
    }

    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        return List.of();
    }

    @Nonnull
    public String getSubChannelUrl() throws ParsingException {
        return "";
    }

    @Nonnull
    public String getSubChannelName() throws ParsingException {
        return "";
    }

    @Nonnull
    public List<Image> getSubChannelAvatars() throws ParsingException {
        return List.of();
    }

    @Nonnull
    public String getDashMpdUrl() throws ParsingException {
        return "";
    }

    @Nonnull
    public String getHlsUrl() throws ParsingException {
        return "";
    }

    public abstract List<AudioStream> getAudioStreams() throws IOException, ExtractionException;

    public abstract List<VideoStream> getVideoStreams() throws IOException, ExtractionException;

    public abstract List<VideoStream> getVideoOnlyStreams() throws IOException, ExtractionException;

    @Nonnull
    public List<SubtitlesStream> getSubtitlesDefault() throws IOException, ExtractionException {
        return Collections.emptyList();
    }

    @Nonnull
    public List<SubtitlesStream> getSubtitles(MediaFormat format) throws IOException, ExtractionException {
        return Collections.emptyList();
    }

    public abstract StreamType getStreamType() throws ParsingException;

    @Nullable
    public InfoItemsCollector<? extends InfoItem, ? extends InfoItemExtractor> getRelatedItems() throws IOException, ExtractionException {
        return null;
    }

    @Deprecated
    @Nullable
    public StreamInfoItemsCollector getRelatedStreams() throws IOException, ExtractionException {
        InfoItemsCollector<? extends InfoItem, ? extends InfoItemExtractor> collector = this.getRelatedItems();
        if (collector instanceof StreamInfoItemsCollector) {
            return (StreamInfoItemsCollector)collector;
        }
        return null;
    }

    @Nonnull
    public List<Frameset> getFrames() throws ExtractionException {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    protected long getTimestampSeconds(String regexPattern) throws ParsingException {
        String timestamp;
        try {
            timestamp = Parser.matchGroup1(regexPattern, this.getOriginalUrl());
        }
        catch (Parser.RegexException e) {
            return -2L;
        }
        if (!timestamp.isEmpty()) {
            try {
                String hoursString;
                String minutesString;
                String secondsString;
                block7: {
                    secondsString = "";
                    minutesString = "";
                    hoursString = "";
                    try {
                        secondsString = Parser.matchGroup1("(\\d+)s", timestamp);
                        minutesString = Parser.matchGroup1("(\\d+)m", timestamp);
                        hoursString = Parser.matchGroup1("(\\d+)h", timestamp);
                    }
                    catch (Exception e) {
                        if (!secondsString.isEmpty() || !minutesString.isEmpty()) break block7;
                        secondsString = Parser.matchGroup1("t=(\\d+)", timestamp);
                    }
                }
                int seconds = secondsString.isEmpty() ? 0 : Integer.parseInt(secondsString);
                int minutes = minutesString.isEmpty() ? 0 : Integer.parseInt(minutesString);
                int hours = hoursString.isEmpty() ? 0 : Integer.parseInt(hoursString);
                return (long)seconds + 60L * (long)minutes + 3600L * (long)hours;
            }
            catch (ParsingException e) {
                throw new ParsingException("Could not get timestamp.", e);
            }
        }
        return 0L;
    }

    @Nonnull
    public String getHost() throws ParsingException {
        return "";
    }

    public Privacy getPrivacy() throws ParsingException {
        return Privacy.PUBLIC;
    }

    @Nonnull
    public String getCategory() throws ParsingException {
        return "";
    }

    @Nonnull
    public String getLicence() throws ParsingException {
        return "";
    }

    @Nullable
    public Locale getLanguageInfo() throws ParsingException {
        return null;
    }

    @Nonnull
    public List<String> getTags() throws ParsingException {
        return Collections.emptyList();
    }

    @Nonnull
    public String getSupportInfo() throws ParsingException {
        return "";
    }

    @Nonnull
    public List<StreamSegment> getStreamSegments() throws ParsingException {
        return Collections.emptyList();
    }

    @Nonnull
    public List<MetaInfo> getMetaInfo() throws ParsingException {
        return Collections.emptyList();
    }

    public boolean isShortFormContent() throws ParsingException {
        return false;
    }

    @Nonnull
    public ContentAvailability getContentAvailability() throws ParsingException {
        return ContentAvailability.UNKNOWN;
    }

    public static enum Privacy {
        PUBLIC,
        UNLISTED,
        PRIVATE,
        INTERNAL,
        OTHER;

    }
}

